// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the response from the server from the request to get the specified user as an administrator.
 */
public class AdminGetUserResponse private constructor(builder: Builder) {
    /**
     * Indicates that the status is `enabled`.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * *This response parameter is no longer supported.* It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.
     */
    public val mfaOptions: List<MfaOptionType>? = builder.mfaOptions
    /**
     * The user's preferred MFA setting.
     */
    public val preferredMfaSetting: kotlin.String? = builder.preferredMfaSetting
    /**
     * An array of name-value pairs representing user attributes.
     */
    public val userAttributes: List<AttributeType>? = builder.userAttributes
    /**
     * The date the user was created.
     */
    public val userCreateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.userCreateDate
    /**
     * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java `Date` object.
     */
    public val userLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.userLastModifiedDate
    /**
     * The MFA options that are activated for the user. The possible values in this list are `SMS_MFA` and `SOFTWARE_TOKEN_MFA`.
     */
    public val userMfaSettingList: List<String>? = builder.userMfaSettingList
    /**
     * The user status. Can be one of the following:
     * + UNCONFIRMED - User has been created but not confirmed.
     * + CONFIRMED - User has been confirmed.
     * + UNKNOWN - User status isn't known.
     * + RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.
     * + FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else.
     */
    public val userStatus: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserStatusType? = builder.userStatus
    /**
     * The username of the user that you requested.
     */
    public val username: kotlin.String = requireNotNull(builder.username) { "A non-null value must be provided for username" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetUserResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminGetUserResponse(")
        append("enabled=$enabled,")
        append("mfaOptions=$mfaOptions,")
        append("preferredMfaSetting=$preferredMfaSetting,")
        append("userAttributes=$userAttributes,")
        append("userCreateDate=$userCreateDate,")
        append("userLastModifiedDate=$userLastModifiedDate,")
        append("userMfaSettingList=$userMfaSettingList,")
        append("userStatus=$userStatus,")
        append("username=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (mfaOptions?.hashCode() ?: 0)
        result = 31 * result + (preferredMfaSetting?.hashCode() ?: 0)
        result = 31 * result + (userAttributes?.hashCode() ?: 0)
        result = 31 * result + (userCreateDate?.hashCode() ?: 0)
        result = 31 * result + (userLastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (userMfaSettingList?.hashCode() ?: 0)
        result = 31 * result + (userStatus?.hashCode() ?: 0)
        result = 31 * result + (username.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminGetUserResponse

        if (enabled != other.enabled) return false
        if (mfaOptions != other.mfaOptions) return false
        if (preferredMfaSetting != other.preferredMfaSetting) return false
        if (userAttributes != other.userAttributes) return false
        if (userCreateDate != other.userCreateDate) return false
        if (userLastModifiedDate != other.userLastModifiedDate) return false
        if (userMfaSettingList != other.userMfaSettingList) return false
        if (userStatus != other.userStatus) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetUserResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates that the status is `enabled`.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * *This response parameter is no longer supported.* It provides information only about SMS MFA configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.
         */
        public var mfaOptions: List<MfaOptionType>? = null
        /**
         * The user's preferred MFA setting.
         */
        public var preferredMfaSetting: kotlin.String? = null
        /**
         * An array of name-value pairs representing user attributes.
         */
        public var userAttributes: List<AttributeType>? = null
        /**
         * The date the user was created.
         */
        public var userCreateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java `Date` object.
         */
        public var userLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The MFA options that are activated for the user. The possible values in this list are `SMS_MFA` and `SOFTWARE_TOKEN_MFA`.
         */
        public var userMfaSettingList: List<String>? = null
        /**
         * The user status. Can be one of the following:
         * + UNCONFIRMED - User has been created but not confirmed.
         * + CONFIRMED - User has been confirmed.
         * + UNKNOWN - User status isn't known.
         * + RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.
         * + FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else.
         */
        public var userStatus: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserStatusType? = null
        /**
         * The username of the user that you requested.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetUserResponse) : this() {
            this.enabled = x.enabled
            this.mfaOptions = x.mfaOptions
            this.preferredMfaSetting = x.preferredMfaSetting
            this.userAttributes = x.userAttributes
            this.userCreateDate = x.userCreateDate
            this.userLastModifiedDate = x.userLastModifiedDate
            this.userMfaSettingList = x.userMfaSettingList
            this.userStatus = x.userStatus
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetUserResponse = AdminGetUserResponse(this)

        internal fun correctErrors(): Builder {
            if (username == null) username = ""
            return this
        }
    }
}
