// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Confirm a user's registration as a user pool administrator.
 */
public class AdminConfirmSignUpRequest private constructor(builder: Builder) {
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
     *
     * If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the *post confirmation* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the `clientMetadata` attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    public val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * The user pool ID for which you want to confirm user registration.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The username of the user that you want to query or modify. The value of this parameter is typically your user's username, but it can be any of their alias attributes. If `username` isn't an alias attribute in your user pool, this value must be the `sub` of a local user or the username of a user from a third-party IdP.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminConfirmSignUpRequest(")
        append("clientMetadata=$clientMetadata,")
        append("userPoolId=$userPoolId,")
        append("username=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientMetadata?.hashCode() ?: 0
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminConfirmSignUpRequest

        if (clientMetadata != other.clientMetadata) return false
        if (userPoolId != other.userPoolId) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
         *
         * If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the *post confirmation* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the `clientMetadata` attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        public var clientMetadata: Map<String, String>? = null
        /**
         * The user pool ID for which you want to confirm user registration.
         */
        public var userPoolId: kotlin.String? = null
        /**
         * The username of the user that you want to query or modify. The value of this parameter is typically your user's username, but it can be any of their alias attributes. If `username` isn't an alias attribute in your user pool, this value must be the `sub` of a local user or the username of a user from a third-party IdP.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest) : this() {
            this.clientMetadata = x.clientMetadata
            this.userPoolId = x.userPoolId
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest = AdminConfirmSignUpRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
