// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthFlowType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InitiateAuthOperationSerializer: HttpSerialize<InitiateAuthRequest> {
    override suspend fun serialize(context: ExecutionContext, input: InitiateAuthRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeInitiateAuthOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeInitiateAuthOperationBody(context: ExecutionContext, input: InitiateAuthRequest): ByteArray {
    val serializer = JsonSerializer()
    val ANALYTICSMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AnalyticsMetadata"))
    val AUTHFLOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthFlow"))
    val AUTHPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AuthParameters"))
    val CLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientId"))
    val CLIENTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ClientMetadata"))
    val USERCONTEXTDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserContextData"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANALYTICSMETADATA_DESCRIPTOR)
        field(AUTHFLOW_DESCRIPTOR)
        field(AUTHPARAMETERS_DESCRIPTOR)
        field(CLIENTID_DESCRIPTOR)
        field(CLIENTMETADATA_DESCRIPTOR)
        field(USERCONTEXTDATA_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.analyticsMetadata?.let { field(ANALYTICSMETADATA_DESCRIPTOR, it, ::serializeAnalyticsMetadataTypeDocument) }
        input.authFlow?.let { field(AUTHFLOW_DESCRIPTOR, it.value) }
        if (input.authParameters != null) {
            mapField(AUTHPARAMETERS_DESCRIPTOR) {
                input.authParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.clientId?.let { field(CLIENTID_DESCRIPTOR, it) }
        if (input.clientMetadata != null) {
            mapField(CLIENTMETADATA_DESCRIPTOR) {
                input.clientMetadata.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.userContextData?.let { field(USERCONTEXTDATA_DESCRIPTOR, it, ::serializeUserContextDataTypeDocument) }
    }
    return serializer.toByteArray()
}
