// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class InitiateAuthOperationDeserializer: HttpDeserialize<InitiateAuthResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InitiateAuthResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInitiateAuthError(context, call)
        }
        val builder = InitiateAuthResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeInitiateAuthOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwInitiateAuthError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnexpectedLambdaException" -> UnexpectedLambdaExceptionDeserializer().deserialize(context, wrappedCall)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidLambdaResponseException" -> InvalidLambdaResponseExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidUserPoolConfigurationException" -> InvalidUserPoolConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidSmsRoleTrustRelationshipException" -> InvalidSmsRoleTrustRelationshipExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidSmsRoleAccessPolicyException" -> InvalidSmsRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedCall)
        "PasswordResetRequiredException" -> PasswordResetRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UserLambdaValidationException" -> UserLambdaValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeInitiateAuthOperationBody(builder: InitiateAuthResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHENTICATIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AuthenticationResult"))
    val CHALLENGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ChallengeName"))
    val CHALLENGEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ChallengeParameters"))
    val SESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Session"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONRESULT_DESCRIPTOR)
        field(CHALLENGENAME_DESCRIPTOR)
        field(CHALLENGEPARAMETERS_DESCRIPTOR)
        field(SESSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHENTICATIONRESULT_DESCRIPTOR.index -> builder.authenticationResult = deserializeAuthenticationResultTypeDocument(deserializer)
                CHALLENGENAME_DESCRIPTOR.index -> builder.challengeName = deserializeString().let { ChallengeNameType.fromValue(it) }
                CHALLENGEPARAMETERS_DESCRIPTOR.index -> builder.challengeParameters =
                    deserializer.deserializeMap(CHALLENGEPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SESSION_DESCRIPTOR.index -> builder.session = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
