// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthEventType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class AdminListUserAuthEventsOperationDeserializer: HttpDeserialize<AdminListUserAuthEventsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AdminListUserAuthEventsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAdminListUserAuthEventsError(context, call)
        }
        val builder = AdminListUserAuthEventsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAdminListUserAuthEventsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAdminListUserAuthEventsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UserPoolAddOnNotEnabledException" -> UserPoolAddOnNotEnabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAdminListUserAuthEventsOperationBody(builder: AdminListUserAuthEventsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AuthEvents"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHEVENTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHEVENTS_DESCRIPTOR.index -> builder.authEvents =
                    deserializer.deserializeList(AUTHEVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<AuthEventType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAuthEventTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
