// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListDevicesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class AdminListDevicesOperationDeserializer: HttpDeserialize<AdminListDevicesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AdminListDevicesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAdminListDevicesError(context, call)
        }
        val builder = AdminListDevicesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAdminListDevicesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAdminListDevicesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidUserPoolConfigurationException" -> InvalidUserPoolConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAdminListDevicesOperationBody(builder: AdminListDevicesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Devices"))
    val PAGINATIONTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PaginationToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICES_DESCRIPTOR)
        field(PAGINATIONTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICES_DESCRIPTOR.index -> builder.devices =
                    deserializer.deserializeList(DEVICES_DESCRIPTOR) {
                        val col0 = mutableListOf<DeviceType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeviceTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PAGINATIONTOKEN_DESCRIPTOR.index -> builder.paginationToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
