// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A container for information about the user pool.
 */
public class UserPoolType private constructor(builder: Builder) {
    /**
     * The available verified method a user can use to recover their password when they call `ForgotPassword`. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
     */
    public val accountRecoverySetting: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType? = builder.accountRecoverySetting
    /**
     * The configuration for `AdminCreateUser` requests.
     */
    public val adminCreateUserConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType? = builder.adminCreateUserConfig
    /**
     * The attributes that are aliased in a user pool.
     */
    public val aliasAttributes: List<AliasAttributeType>? = builder.aliasAttributes
    /**
     * The Amazon Resource Name (ARN) for the user pool.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The attributes that are auto-verified in a user pool.
     */
    public val autoVerifiedAttributes: List<VerifiedAttributeType>? = builder.autoVerifiedAttributes
    /**
     * The date and time, in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format, when the item was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be `auth.example.com`.
     *
     * For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
     */
    public val customDomain: kotlin.String? = builder.customDomain
    /**
     * When active, `DeletionProtection` prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature.
     *
     * When you try to delete a protected user pool in a `DeleteUserPool` API request, Amazon Cognito returns an `InvalidParameterException` error. To delete a protected user pool, send a new `DeleteUserPool` request after you deactivate deletion protection in an `UpdateUserPool` API request.
     */
    public val deletionProtection: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeletionProtectionType? = builder.deletionProtection
    /**
     * The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.
     *
     * When you provide a value for any `DeviceConfiguration` field, you activate the Amazon Cognito device-remembering feature.
     */
    public val deviceConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType? = builder.deviceConfiguration
    /**
     * The domain prefix, if the user pool has a domain associated with it.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.
     */
    public val emailConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType? = builder.emailConfiguration
    /**
     * Deprecated. Review error codes from API requests with `EventSource:cognito-idp.amazonaws.com` in CloudTrail for information about problems with user pool email configuration.
     */
    public val emailConfigurationFailure: kotlin.String? = builder.emailConfigurationFailure
    /**
     * This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
     */
    public val emailVerificationMessage: kotlin.String? = builder.emailVerificationMessage
    /**
     * This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
     */
    public val emailVerificationSubject: kotlin.String? = builder.emailVerificationSubject
    /**
     * A number estimating the size of the user pool.
     */
    public val estimatedNumberOfUsers: kotlin.Int = builder.estimatedNumberOfUsers
    /**
     * The ID of the user pool.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Lambda triggers associated with the user pool.
     */
    public val lambdaConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType? = builder.lambdaConfig
    /**
     * The date and time, in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format, when the item was modified.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * Can be one of the following values:
     * + `OFF` - MFA tokens aren't required and can't be specified during user registration.
     * + `ON` - MFA tokens are required for all user registrations. You can only specify required when you're initially creating a user pool.
     * + `OPTIONAL` - Users have the option when registering to create an MFA token.
     */
    public val mfaConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType? = builder.mfaConfiguration
    /**
     * The name of the user pool.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The policies associated with the user pool.
     */
    public val policies: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType? = builder.policies
    /**
     * A list of the user attributes and their properties in your user pool. The attribute schema contains standard attributes, custom attributes with a `custom:` prefix, and developer attributes with a `dev:` prefix. For more information, see [User pool attributes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html).
     *
     * Developer-only attributes are a legacy feature of user pools, are read-only to all app clients. You can create and update developer-only attributes only with IAM-authenticated API operations. Use app client read/write permissions instead.
     */
    public val schemaAttributes: List<SchemaAttributeType>? = builder.schemaAttributes
    /**
     * The contents of the SMS authentication message.
     */
    public val smsAuthenticationMessage: kotlin.String? = builder.smsAuthenticationMessage
    /**
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.
     */
    public val smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = builder.smsConfiguration
    /**
     * The reason why the SMS configuration can't send the messages to your users.
     *
     * This message might include comma-separated values to describe why your SMS configuration can't send messages to user pool end users.
     *
     * ## InvalidSmsRoleAccessPolicyException
     * The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn't properly configured. For more information, see [SmsConfigurationType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html).
     *
     * ## SNSSandbox
     * The Amazon Web Services account is in the SNS SMS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see [Moving out of the SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html).
     */
    public val smsConfigurationFailure: kotlin.String? = builder.smsConfigurationFailure
    /**
     * This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
     */
    public val smsVerificationMessage: kotlin.String? = builder.smsVerificationMessage
    /**
     * The status of a user pool.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val status: aws.sdk.kotlin.services.cognitoidentityprovider.model.StatusType? = builder.status
    /**
     * The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate`, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For more information, see [ Verifying updates to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates).
     */
    public val userAttributeUpdateSettings: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType? = builder.userAttributeUpdateSettings
    /**
     * User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to `AUDIT`. To configure automatic security responses to risky traffic to your user pool, set to `ENFORCED`.
     *
     * For more information, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html).
     */
    public val userPoolAddOns: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType? = builder.userPoolAddOns
    /**
     * The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     */
    public val userPoolTags: Map<String, String>? = builder.userPoolTags
    /**
     * Specifies whether a user can use an email address or phone number as a username when they sign up.
     */
    public val usernameAttributes: List<UsernameAttributeType>? = builder.usernameAttributes
    /**
     * Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to `False`, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see [UsernameConfigurationType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html).
     */
    public val usernameConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType? = builder.usernameConfiguration
    /**
     * The template for verification messages.
     */
    public val verificationMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType? = builder.verificationMessageTemplate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserPoolType(")
        append("accountRecoverySetting=$accountRecoverySetting,")
        append("adminCreateUserConfig=$adminCreateUserConfig,")
        append("aliasAttributes=$aliasAttributes,")
        append("arn=$arn,")
        append("autoVerifiedAttributes=$autoVerifiedAttributes,")
        append("creationDate=$creationDate,")
        append("customDomain=$customDomain,")
        append("deletionProtection=$deletionProtection,")
        append("deviceConfiguration=$deviceConfiguration,")
        append("domain=$domain,")
        append("emailConfiguration=$emailConfiguration,")
        append("emailConfigurationFailure=$emailConfigurationFailure,")
        append("emailVerificationMessage=$emailVerificationMessage,")
        append("emailVerificationSubject=$emailVerificationSubject,")
        append("estimatedNumberOfUsers=$estimatedNumberOfUsers,")
        append("id=$id,")
        append("lambdaConfig=$lambdaConfig,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("mfaConfiguration=$mfaConfiguration,")
        append("name=$name,")
        append("policies=$policies,")
        append("schemaAttributes=$schemaAttributes,")
        append("smsAuthenticationMessage=$smsAuthenticationMessage,")
        append("smsConfiguration=$smsConfiguration,")
        append("smsConfigurationFailure=$smsConfigurationFailure,")
        append("smsVerificationMessage=$smsVerificationMessage,")
        append("status=$status,")
        append("userAttributeUpdateSettings=$userAttributeUpdateSettings,")
        append("userPoolAddOns=$userPoolAddOns,")
        append("userPoolTags=$userPoolTags,")
        append("usernameAttributes=$usernameAttributes,")
        append("usernameConfiguration=$usernameConfiguration,")
        append("verificationMessageTemplate=$verificationMessageTemplate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountRecoverySetting?.hashCode() ?: 0
        result = 31 * result + (adminCreateUserConfig?.hashCode() ?: 0)
        result = 31 * result + (aliasAttributes?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (autoVerifiedAttributes?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customDomain?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (deviceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (emailConfiguration?.hashCode() ?: 0)
        result = 31 * result + (emailConfigurationFailure?.hashCode() ?: 0)
        result = 31 * result + (emailVerificationMessage?.hashCode() ?: 0)
        result = 31 * result + (emailVerificationSubject?.hashCode() ?: 0)
        result = 31 * result + (estimatedNumberOfUsers)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lambdaConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (mfaConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (schemaAttributes?.hashCode() ?: 0)
        result = 31 * result + (smsAuthenticationMessage?.hashCode() ?: 0)
        result = 31 * result + (smsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (smsConfigurationFailure?.hashCode() ?: 0)
        result = 31 * result + (smsVerificationMessage?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userAttributeUpdateSettings?.hashCode() ?: 0)
        result = 31 * result + (userPoolAddOns?.hashCode() ?: 0)
        result = 31 * result + (userPoolTags?.hashCode() ?: 0)
        result = 31 * result + (usernameAttributes?.hashCode() ?: 0)
        result = 31 * result + (usernameConfiguration?.hashCode() ?: 0)
        result = 31 * result + (verificationMessageTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserPoolType

        if (accountRecoverySetting != other.accountRecoverySetting) return false
        if (adminCreateUserConfig != other.adminCreateUserConfig) return false
        if (aliasAttributes != other.aliasAttributes) return false
        if (arn != other.arn) return false
        if (autoVerifiedAttributes != other.autoVerifiedAttributes) return false
        if (creationDate != other.creationDate) return false
        if (customDomain != other.customDomain) return false
        if (deletionProtection != other.deletionProtection) return false
        if (deviceConfiguration != other.deviceConfiguration) return false
        if (domain != other.domain) return false
        if (emailConfiguration != other.emailConfiguration) return false
        if (emailConfigurationFailure != other.emailConfigurationFailure) return false
        if (emailVerificationMessage != other.emailVerificationMessage) return false
        if (emailVerificationSubject != other.emailVerificationSubject) return false
        if (estimatedNumberOfUsers != other.estimatedNumberOfUsers) return false
        if (id != other.id) return false
        if (lambdaConfig != other.lambdaConfig) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (mfaConfiguration != other.mfaConfiguration) return false
        if (name != other.name) return false
        if (policies != other.policies) return false
        if (schemaAttributes != other.schemaAttributes) return false
        if (smsAuthenticationMessage != other.smsAuthenticationMessage) return false
        if (smsConfiguration != other.smsConfiguration) return false
        if (smsConfigurationFailure != other.smsConfigurationFailure) return false
        if (smsVerificationMessage != other.smsVerificationMessage) return false
        if (status != other.status) return false
        if (userAttributeUpdateSettings != other.userAttributeUpdateSettings) return false
        if (userPoolAddOns != other.userPoolAddOns) return false
        if (userPoolTags != other.userPoolTags) return false
        if (usernameAttributes != other.usernameAttributes) return false
        if (usernameConfiguration != other.usernameConfiguration) return false
        if (verificationMessageTemplate != other.verificationMessageTemplate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The available verified method a user can use to recover their password when they call `ForgotPassword`. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
         */
        public var accountRecoverySetting: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType? = null
        /**
         * The configuration for `AdminCreateUser` requests.
         */
        public var adminCreateUserConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType? = null
        /**
         * The attributes that are aliased in a user pool.
         */
        public var aliasAttributes: List<AliasAttributeType>? = null
        /**
         * The Amazon Resource Name (ARN) for the user pool.
         */
        public var arn: kotlin.String? = null
        /**
         * The attributes that are auto-verified in a user pool.
         */
        public var autoVerifiedAttributes: List<VerifiedAttributeType>? = null
        /**
         * The date and time, in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format, when the item was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be `auth.example.com`.
         *
         * For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
         */
        public var customDomain: kotlin.String? = null
        /**
         * When active, `DeletionProtection` prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature.
         *
         * When you try to delete a protected user pool in a `DeleteUserPool` API request, Amazon Cognito returns an `InvalidParameterException` error. To delete a protected user pool, send a new `DeleteUserPool` request after you deactivate deletion protection in an `UpdateUserPool` API request.
         */
        public var deletionProtection: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeletionProtectionType? = null
        /**
         * The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.
         *
         * When you provide a value for any `DeviceConfiguration` field, you activate the Amazon Cognito device-remembering feature.
         */
        public var deviceConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType? = null
        /**
         * The domain prefix, if the user pool has a domain associated with it.
         */
        public var domain: kotlin.String? = null
        /**
         * The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.
         */
        public var emailConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType? = null
        /**
         * Deprecated. Review error codes from API requests with `EventSource:cognito-idp.amazonaws.com` in CloudTrail for information about problems with user pool email configuration.
         */
        public var emailConfigurationFailure: kotlin.String? = null
        /**
         * This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
         */
        public var emailVerificationMessage: kotlin.String? = null
        /**
         * This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
         */
        public var emailVerificationSubject: kotlin.String? = null
        /**
         * A number estimating the size of the user pool.
         */
        public var estimatedNumberOfUsers: kotlin.Int = 0
        /**
         * The ID of the user pool.
         */
        public var id: kotlin.String? = null
        /**
         * The Lambda triggers associated with the user pool.
         */
        public var lambdaConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType? = null
        /**
         * The date and time, in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format, when the item was modified.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Can be one of the following values:
         * + `OFF` - MFA tokens aren't required and can't be specified during user registration.
         * + `ON` - MFA tokens are required for all user registrations. You can only specify required when you're initially creating a user pool.
         * + `OPTIONAL` - Users have the option when registering to create an MFA token.
         */
        public var mfaConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType? = null
        /**
         * The name of the user pool.
         */
        public var name: kotlin.String? = null
        /**
         * The policies associated with the user pool.
         */
        public var policies: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType? = null
        /**
         * A list of the user attributes and their properties in your user pool. The attribute schema contains standard attributes, custom attributes with a `custom:` prefix, and developer attributes with a `dev:` prefix. For more information, see [User pool attributes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html).
         *
         * Developer-only attributes are a legacy feature of user pools, are read-only to all app clients. You can create and update developer-only attributes only with IAM-authenticated API operations. Use app client read/write permissions instead.
         */
        public var schemaAttributes: List<SchemaAttributeType>? = null
        /**
         * The contents of the SMS authentication message.
         */
        public var smsAuthenticationMessage: kotlin.String? = null
        /**
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.
         */
        public var smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = null
        /**
         * The reason why the SMS configuration can't send the messages to your users.
         *
         * This message might include comma-separated values to describe why your SMS configuration can't send messages to user pool end users.
         *
         * ## InvalidSmsRoleAccessPolicyException
         * The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn't properly configured. For more information, see [SmsConfigurationType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html).
         *
         * ## SNSSandbox
         * The Amazon Web Services account is in the SNS SMS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see [Moving out of the SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html).
         */
        public var smsConfigurationFailure: kotlin.String? = null
        /**
         * This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
         */
        public var smsVerificationMessage: kotlin.String? = null
        /**
         * The status of a user pool.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var status: aws.sdk.kotlin.services.cognitoidentityprovider.model.StatusType? = null
        /**
         * The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate`, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For more information, see [ Verifying updates to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates).
         */
        public var userAttributeUpdateSettings: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType? = null
        /**
         * User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to `AUDIT`. To configure automatic security responses to risky traffic to your user pool, set to `ENFORCED`.
         *
         * For more information, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html).
         */
        public var userPoolAddOns: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType? = null
        /**
         * The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
         */
        public var userPoolTags: Map<String, String>? = null
        /**
         * Specifies whether a user can use an email address or phone number as a username when they sign up.
         */
        public var usernameAttributes: List<UsernameAttributeType>? = null
        /**
         * Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to `False`, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see [UsernameConfigurationType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html).
         */
        public var usernameConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType? = null
        /**
         * The template for verification messages.
         */
        public var verificationMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolType) : this() {
            this.accountRecoverySetting = x.accountRecoverySetting
            this.adminCreateUserConfig = x.adminCreateUserConfig
            this.aliasAttributes = x.aliasAttributes
            this.arn = x.arn
            this.autoVerifiedAttributes = x.autoVerifiedAttributes
            this.creationDate = x.creationDate
            this.customDomain = x.customDomain
            this.deletionProtection = x.deletionProtection
            this.deviceConfiguration = x.deviceConfiguration
            this.domain = x.domain
            this.emailConfiguration = x.emailConfiguration
            this.emailConfigurationFailure = x.emailConfigurationFailure
            this.emailVerificationMessage = x.emailVerificationMessage
            this.emailVerificationSubject = x.emailVerificationSubject
            this.estimatedNumberOfUsers = x.estimatedNumberOfUsers
            this.id = x.id
            this.lambdaConfig = x.lambdaConfig
            this.lastModifiedDate = x.lastModifiedDate
            this.mfaConfiguration = x.mfaConfiguration
            this.name = x.name
            this.policies = x.policies
            this.schemaAttributes = x.schemaAttributes
            this.smsAuthenticationMessage = x.smsAuthenticationMessage
            this.smsConfiguration = x.smsConfiguration
            this.smsConfigurationFailure = x.smsConfigurationFailure
            this.smsVerificationMessage = x.smsVerificationMessage
            this.status = x.status
            this.userAttributeUpdateSettings = x.userAttributeUpdateSettings
            this.userPoolAddOns = x.userPoolAddOns
            this.userPoolTags = x.userPoolTags
            this.usernameAttributes = x.usernameAttributes
            this.usernameConfiguration = x.usernameConfiguration
            this.verificationMessageTemplate = x.verificationMessageTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolType = UserPoolType(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType] inside the given [block]
         */
        public fun accountRecoverySetting(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType.Builder.() -> kotlin.Unit) {
            this.accountRecoverySetting = aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType] inside the given [block]
         */
        public fun adminCreateUserConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType.Builder.() -> kotlin.Unit) {
            this.adminCreateUserConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType] inside the given [block]
         */
        public fun deviceConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType.Builder.() -> kotlin.Unit) {
            this.deviceConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType] inside the given [block]
         */
        public fun emailConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType.Builder.() -> kotlin.Unit) {
            this.emailConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType] inside the given [block]
         */
        public fun lambdaConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType.Builder.() -> kotlin.Unit) {
            this.lambdaConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType] inside the given [block]
         */
        public fun policies(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType.Builder.() -> kotlin.Unit) {
            this.policies = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType] inside the given [block]
         */
        public fun smsConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.Builder.() -> kotlin.Unit) {
            this.smsConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType] inside the given [block]
         */
        public fun userAttributeUpdateSettings(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.Builder.() -> kotlin.Unit) {
            this.userAttributeUpdateSettings = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType] inside the given [block]
         */
        public fun userPoolAddOns(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType.Builder.() -> kotlin.Unit) {
            this.userPoolAddOns = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType] inside the given [block]
         */
        public fun usernameConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType.Builder.() -> kotlin.Unit) {
            this.usernameConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType] inside the given [block]
         */
        public fun verificationMessageTemplate(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType.Builder.() -> kotlin.Unit) {
            this.verificationMessageTemplate = aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
