// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The SMS configuration type is the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.
 */
public class SmsConfigurationType private constructor(builder: Builder) {
    /**
     * The external ID provides additional security for your IAM role. You can use an `ExternalId` with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an `ExternalId`, your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the `ExternalID`. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the `ExternalId`.
     *
     * For more information about the `ExternalId` of a role, see [How to use an external ID when granting access to your Amazon Web Services resources to a third party](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html)
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a [spending limit](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html).
     */
    public val snsCallerArn: kotlin.String = requireNotNull(builder.snsCallerArn) { "A non-null value must be provided for snsCallerArn" }
    /**
     * The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported **Legacy Amazon SNS alternate Region**.
     *
     *  Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
     */
    public val snsRegion: kotlin.String? = builder.snsRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsConfigurationType(")
        append("externalId=$externalId,")
        append("snsCallerArn=$snsCallerArn,")
        append("snsRegion=$snsRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = externalId?.hashCode() ?: 0
        result = 31 * result + (snsCallerArn.hashCode())
        result = 31 * result + (snsRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsConfigurationType

        if (externalId != other.externalId) return false
        if (snsCallerArn != other.snsCallerArn) return false
        if (snsRegion != other.snsRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The external ID provides additional security for your IAM role. You can use an `ExternalId` with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an `ExternalId`, your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the `ExternalID`. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the `ExternalId`.
         *
         * For more information about the `ExternalId` of a role, see [How to use an external ID when granting access to your Amazon Web Services resources to a third party](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html)
         */
        public var externalId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a [spending limit](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html).
         */
        public var snsCallerArn: kotlin.String? = null
        /**
         * The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported **Legacy Amazon SNS alternate Region**.
         *
         *  Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
         */
        public var snsRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType) : this() {
            this.externalId = x.externalId
            this.snsCallerArn = x.snsCallerArn
            this.snsRegion = x.snsRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType = SmsConfigurationType(this)

        internal fun correctErrors(): Builder {
            if (snsCallerArn == null) snsCallerArn = ""
            return this
        }
    }
}
