// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Represents the request to list users.
 */
public class ListUsersRequest private constructor(builder: Builder) {
    /**
     * A JSON array of user attribute names, for example `given_name`, that you want Amazon Cognito to include in the response for each user. When you don't provide an `AttributesToGet` parameter, Amazon Cognito returns all attributes for each user.
     */
    public val attributesToGet: List<String>? = builder.attributesToGet
    /**
     * A filter string of the form "*AttributeName**Filter-Type* "*AttributeValue*"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "`family_name` = \"Reddy\"".
     * + *AttributeName*: The name of the attribute to search for. You can only search for one attribute at a time.
     * + *Filter-Type*: For an exact match, use =, for example, "`given_name` = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "`given_name` ^= \"Jon\"".
     * + *AttributeValue*: The attribute value that must be matched for each user.
     *
     * If the filter string is empty, `ListUsers` returns all users in the user pool.
     *
     * You can only search for the following standard attributes:
     * + `username` (case-sensitive)
     * + `email`
     * + `phone_number`
     * + `name`
     * + `given_name`
     * + `family_name`
     * + `preferred_username`
     * + `cognito:user_status` (called **Status** in the Console) (case-insensitive)
     * + `status (called <b>Enabled</b> in the Console) (case-sensitive)`
     * + `sub`
     *
     * Custom attributes aren't searchable.
     *
     * You can also list users with a client-side filter. The server-side filter matches no more than one attribute. For an advanced search, use a client-side filter with the `--query` parameter of the `list-users` action in the CLI. When you use a client-side filter, ListUsers returns a paginated list of zero or more users. You can receive multiple pages in a row with zero results. Repeat the query with each pagination token that is returned until you receive a null pagination token value, and then review the combined result.
     *
     * For more information about server-side and client-side filtering, see [FilteringCLI output](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html) in the [Command Line Interface User Guide](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
     *
     * For more information, see [Searching for Users Using the ListUsers API](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api) and [Examples of Using the ListUsers API](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples) in the *Amazon Cognito Developer Guide*.
     */
    public val filter: kotlin.String? = builder.filter
    /**
     * Maximum number of users to be returned.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.
     */
    public val paginationToken: kotlin.String? = builder.paginationToken
    /**
     * The user pool ID for the user pool on which the search should be performed.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListUsersRequest(")
        append("attributesToGet=$attributesToGet,")
        append("filter=$filter,")
        append("limit=$limit,")
        append("paginationToken=$paginationToken,")
        append("userPoolId=$userPoolId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributesToGet?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (paginationToken?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListUsersRequest

        if (attributesToGet != other.attributesToGet) return false
        if (filter != other.filter) return false
        if (limit != other.limit) return false
        if (paginationToken != other.paginationToken) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A JSON array of user attribute names, for example `given_name`, that you want Amazon Cognito to include in the response for each user. When you don't provide an `AttributesToGet` parameter, Amazon Cognito returns all attributes for each user.
         */
        public var attributesToGet: List<String>? = null
        /**
         * A filter string of the form "*AttributeName**Filter-Type* "*AttributeValue*"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "`family_name` = \"Reddy\"".
         * + *AttributeName*: The name of the attribute to search for. You can only search for one attribute at a time.
         * + *Filter-Type*: For an exact match, use =, for example, "`given_name` = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "`given_name` ^= \"Jon\"".
         * + *AttributeValue*: The attribute value that must be matched for each user.
         *
         * If the filter string is empty, `ListUsers` returns all users in the user pool.
         *
         * You can only search for the following standard attributes:
         * + `username` (case-sensitive)
         * + `email`
         * + `phone_number`
         * + `name`
         * + `given_name`
         * + `family_name`
         * + `preferred_username`
         * + `cognito:user_status` (called **Status** in the Console) (case-insensitive)
         * + `status (called <b>Enabled</b> in the Console) (case-sensitive)`
         * + `sub`
         *
         * Custom attributes aren't searchable.
         *
         * You can also list users with a client-side filter. The server-side filter matches no more than one attribute. For an advanced search, use a client-side filter with the `--query` parameter of the `list-users` action in the CLI. When you use a client-side filter, ListUsers returns a paginated list of zero or more users. You can receive multiple pages in a row with zero results. Repeat the query with each pagination token that is returned until you receive a null pagination token value, and then review the combined result.
         *
         * For more information about server-side and client-side filtering, see [FilteringCLI output](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html) in the [Command Line Interface User Guide](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
         *
         * For more information, see [Searching for Users Using the ListUsers API](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api) and [Examples of Using the ListUsers API](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples) in the *Amazon Cognito Developer Guide*.
         */
        public var filter: kotlin.String? = null
        /**
         * Maximum number of users to be returned.
         */
        public var limit: kotlin.Int? = null
        /**
         * An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.
         */
        public var paginationToken: kotlin.String? = null
        /**
         * The user pool ID for the user pool on which the search should be performed.
         */
        public var userPoolId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersRequest) : this() {
            this.attributesToGet = x.attributesToGet
            this.filter = x.filter
            this.limit = x.limit
            this.paginationToken = x.paginationToken
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersRequest = ListUsersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
