// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The device-remembering configuration for a user pool. A [ DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) request returns a null value for this object when the user pool isn't configured to remember devices. When device remembering is active, you can remember a user's device with a [ConfirmDevice](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html) API request. Additionally. when the property `DeviceOnlyRememberedOnUserPrompt` is `true`, you must follow `ConfirmDevice` with an [UpdateDeviceStatus](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html) API request that sets the user's device to `remembered` or `not_remembered`.
 *
 * To sign in with a remembered device, include `DEVICE_KEY` in the authentication parameters in your user's [ InitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html) request. If your app doesn't include a `DEVICE_KEY` parameter, the [response](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html#API_InitiateAuth_ResponseSyntax) from Amazon Cognito includes newly-generated `DEVICE_KEY` and `DEVICE_GROUP_KEY` values under `NewDeviceMetadata`. Store these values to use in future device-authentication requests.
 *
 * When you provide a value for any property of `DeviceConfiguration`, you activate the device remembering for the user pool.
 */
public class DeviceConfigurationType private constructor(builder: Builder) {
    /**
     * When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
     *
     * Whether or not `ChallengeRequiredOnNewDevice` is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
     */
    public val challengeRequiredOnNewDevice: kotlin.Boolean = builder.challengeRequiredOnNewDevice
    /**
     * When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a [ ConfirmDevice](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html) API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user's choice in an [ UpdateDeviceStatus](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html) API request.
     *
     * When `DeviceOnlyRememberedOnUserPrompt` is `false`, Amazon Cognito immediately remembers devices that you register in a `ConfirmDevice` API request.
     */
    public val deviceOnlyRememberedOnUserPrompt: kotlin.Boolean = builder.deviceOnlyRememberedOnUserPrompt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceConfigurationType(")
        append("challengeRequiredOnNewDevice=$challengeRequiredOnNewDevice,")
        append("deviceOnlyRememberedOnUserPrompt=$deviceOnlyRememberedOnUserPrompt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = challengeRequiredOnNewDevice.hashCode()
        result = 31 * result + (deviceOnlyRememberedOnUserPrompt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceConfigurationType

        if (challengeRequiredOnNewDevice != other.challengeRequiredOnNewDevice) return false
        if (deviceOnlyRememberedOnUserPrompt != other.deviceOnlyRememberedOnUserPrompt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
         *
         * Whether or not `ChallengeRequiredOnNewDevice` is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
         */
        public var challengeRequiredOnNewDevice: kotlin.Boolean = false
        /**
         * When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a [ ConfirmDevice](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html) API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user's choice in an [ UpdateDeviceStatus](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html) API request.
         *
         * When `DeviceOnlyRememberedOnUserPrompt` is `false`, Amazon Cognito immediately remembers devices that you register in a `ConfirmDevice` API request.
         */
        public var deviceOnlyRememberedOnUserPrompt: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType) : this() {
            this.challengeRequiredOnNewDevice = x.challengeRequiredOnNewDevice
            this.deviceOnlyRememberedOnUserPrompt = x.deviceOnlyRememberedOnUserPrompt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType = DeviceConfigurationType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
