// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Represents the request to create a user pool client.
 */
public class CreateUserPoolClientRequest private constructor(builder: Builder) {
    /**
     * The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
     *
     * For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours`, your user can authorize access with their access token for 10 hours.
     *
     * The default time unit for `AccessTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
     *
     * If you don't specify otherwise in the configuration of your app client, your access tokens are valid for one hour.
     */
    public val accessTokenValidity: kotlin.Int? = builder.accessTokenValidity
    /**
     * The allowed OAuth flows.
     *
     * ## code
     * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
     *
     * ## implicit
     * Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
     *
     * ## client_credentials
     * Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
     */
    public val allowedOAuthFlows: List<OAuthFlowType>? = builder.allowedOAuthFlows
    /**
     * Set to `true` to use OAuth 2.0 features in your user pool app client.
     *
     * `AllowedOAuthFlowsUserPoolClient` must be `true` before you can configure the following features in your app client.
     * + `CallBackURLs`: Callback URLs.
     * + `LogoutURLs`: Sign-out redirect URLs.
     * + `AllowedOAuthScopes`: OAuth 2.0 scopes.
     * + `AllowedOAuthFlows`: Support for authorization code, implicit, and client credentials OAuth 2.0 grants.
     *
     * To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set `AllowedOAuthFlowsUserPoolClient` to `true` in a `CreateUserPoolClient` or `UpdateUserPoolClient` API request. If you don't set a value for `AllowedOAuthFlowsUserPoolClient` in a request with the CLI or SDKs, it defaults to `false`.
     */
    public val allowedOAuthFlowsUserPoolClient: kotlin.Boolean? = builder.allowedOAuthFlowsUserPoolClient
    /**
     * The allowed OAuth scopes. Possible values provided by OAuth are `phone`, `email`, `openid`, and `profile`. Possible values provided by Amazon Web Services are `aws.cognito.signin.user.admin`. Custom scopes created in Resource Servers are also supported.
     */
    public val allowedOAuthScopes: List<String>? = builder.allowedOAuthScopes
    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     *
     * In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in Amazon Web Services Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
     */
    public val analyticsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType? = builder.analyticsConfiguration
    /**
     * Amazon Cognito creates a session token for each API request in an authentication flow. `AuthSessionValidity` is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.
     */
    public val authSessionValidity: kotlin.Int? = builder.authSessionValidity
    /**
     * A list of allowed redirect (callback) URLs for the IdPs.
     *
     * A redirect URI must:
     * + Be an absolute URI.
     * + Be registered with the authorization server.
     * + Not include a fragment component.
     *
     * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
     *
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *
     * App callback URLs such as myapp://example are also supported.
     */
    public val callbackUrls: List<String>? = builder.callbackUrls
    /**
     * The client name for the user pool client you would like to create.
     */
    public val clientName: kotlin.String? = builder.clientName
    /**
     * The default redirect URI. Must be in the `CallbackURLs` list.
     *
     * A redirect URI must:
     * + Be an absolute URI.
     * + Be registered with the authorization server.
     * + Not include a fragment component.
     *
     * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
     *
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *
     * App callback URLs such as myapp://example are also supported.
     */
    public val defaultRedirectUri: kotlin.String? = builder.defaultRedirectUri
    /**
     * Activates the propagation of additional user context data. For more information about propagation of user context data, see [ Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html). If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret.
     */
    public val enablePropagateAdditionalUserContextData: kotlin.Boolean? = builder.enablePropagateAdditionalUserContextData
    /**
     * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     *
     * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
     */
    public val enableTokenRevocation: kotlin.Boolean? = builder.enableTokenRevocation
    /**
     * The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.
     *
     * If you don't specify a value for `ExplicitAuthFlows`, your user client supports `ALLOW_REFRESH_TOKEN_AUTH`, `ALLOW_USER_SRP_AUTH`, and `ALLOW_CUSTOM_AUTH`.
     *
     * Valid values include:
     * + `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
     * + `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
     * + `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
     * + `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
     * + `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
     *
     * In some environments, you will see the values `ADMIN_NO_SRP_AUTH`, `CUSTOM_AUTH_FLOW_ONLY`, or `USER_PASSWORD_AUTH`. You can't assign these legacy `ExplicitAuthFlows` values to user pool clients at the same time as values that begin with `ALLOW_`, like `ALLOW_USER_SRP_AUTH`.
     */
    public val explicitAuthFlows: List<ExplicitAuthFlowsType>? = builder.explicitAuthFlows
    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    public val generateSecret: kotlin.Boolean? = builder.generateSecret
    /**
     * The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
     *
     * For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours`, your user can authenticate their session with their ID token for 10 hours.
     *
     * The default time unit for `IdTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
     *
     * If you don't specify otherwise in the configuration of your app client, your ID tokens are valid for one hour.
     */
    public val idTokenValidity: kotlin.Int? = builder.idTokenValidity
    /**
     * A list of allowed logout URLs for the IdPs.
     */
    public val logoutUrls: List<String>? = builder.logoutUrls
    /**
     * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to `ENABLED` and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs return a `UserNotFoundException` exception if the user doesn't exist in the user pool.
     *
     * Valid values include:
     * + `ENABLED` - This prevents user existence-related errors.
     * + `LEGACY` - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.
     */
    public val preventUserExistenceErrors: aws.sdk.kotlin.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes? = builder.preventUserExistenceErrors
    /**
     * The read attributes.
     */
    public val readAttributes: List<String>? = builder.readAttributes
    /**
     * The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
     *
     * For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days`, your user can refresh their session and retrieve new access and ID tokens for 10 days.
     *
     * The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. *Valid range* is displayed below in seconds.
     *
     * If you don't specify otherwise in the configuration of your app client, your refresh tokens are valid for 30 days.
     */
    public val refreshTokenValidity: kotlin.Int? = builder.refreshTokenValidity
    /**
     * A list of provider names for the identity providers (IdPs) that are supported on this client. The following are supported: `COGNITO`, `Facebook`, `Google`, `SignInWithApple`, and `LoginWithAmazon`. You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example `MySAMLIdP` or `MyOIDCIdP`.
     */
    public val supportedIdentityProviders: List<String>? = builder.supportedIdentityProviders
    /**
     * The units in which the validity times are represented. The default unit for RefreshToken is days, and default for ID and access tokens are hours.
     */
    public val tokenValidityUnits: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType? = builder.tokenValidityUnits
    /**
     * The user pool ID for the user pool where you want to create a user pool client.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The user pool attributes that the app client can write to.
     *
     * If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see [Specifying IdP Attribute Mappings for Your user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
     */
    public val writeAttributes: List<String>? = builder.writeAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolClientRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserPoolClientRequest(")
        append("accessTokenValidity=$accessTokenValidity,")
        append("allowedOAuthFlows=$allowedOAuthFlows,")
        append("allowedOAuthFlowsUserPoolClient=$allowedOAuthFlowsUserPoolClient,")
        append("allowedOAuthScopes=$allowedOAuthScopes,")
        append("analyticsConfiguration=$analyticsConfiguration,")
        append("authSessionValidity=$authSessionValidity,")
        append("callbackUrls=$callbackUrls,")
        append("clientName=$clientName,")
        append("defaultRedirectUri=$defaultRedirectUri,")
        append("enablePropagateAdditionalUserContextData=$enablePropagateAdditionalUserContextData,")
        append("enableTokenRevocation=$enableTokenRevocation,")
        append("explicitAuthFlows=$explicitAuthFlows,")
        append("generateSecret=$generateSecret,")
        append("idTokenValidity=$idTokenValidity,")
        append("logoutUrls=$logoutUrls,")
        append("preventUserExistenceErrors=$preventUserExistenceErrors,")
        append("readAttributes=$readAttributes,")
        append("refreshTokenValidity=$refreshTokenValidity,")
        append("supportedIdentityProviders=$supportedIdentityProviders,")
        append("tokenValidityUnits=$tokenValidityUnits,")
        append("userPoolId=$userPoolId,")
        append("writeAttributes=$writeAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessTokenValidity ?: 0
        result = 31 * result + (allowedOAuthFlows?.hashCode() ?: 0)
        result = 31 * result + (allowedOAuthFlowsUserPoolClient?.hashCode() ?: 0)
        result = 31 * result + (allowedOAuthScopes?.hashCode() ?: 0)
        result = 31 * result + (analyticsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (authSessionValidity ?: 0)
        result = 31 * result + (callbackUrls?.hashCode() ?: 0)
        result = 31 * result + (clientName?.hashCode() ?: 0)
        result = 31 * result + (defaultRedirectUri?.hashCode() ?: 0)
        result = 31 * result + (enablePropagateAdditionalUserContextData?.hashCode() ?: 0)
        result = 31 * result + (enableTokenRevocation?.hashCode() ?: 0)
        result = 31 * result + (explicitAuthFlows?.hashCode() ?: 0)
        result = 31 * result + (generateSecret?.hashCode() ?: 0)
        result = 31 * result + (idTokenValidity ?: 0)
        result = 31 * result + (logoutUrls?.hashCode() ?: 0)
        result = 31 * result + (preventUserExistenceErrors?.hashCode() ?: 0)
        result = 31 * result + (readAttributes?.hashCode() ?: 0)
        result = 31 * result + (refreshTokenValidity ?: 0)
        result = 31 * result + (supportedIdentityProviders?.hashCode() ?: 0)
        result = 31 * result + (tokenValidityUnits?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (writeAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserPoolClientRequest

        if (accessTokenValidity != other.accessTokenValidity) return false
        if (allowedOAuthFlows != other.allowedOAuthFlows) return false
        if (allowedOAuthFlowsUserPoolClient != other.allowedOAuthFlowsUserPoolClient) return false
        if (allowedOAuthScopes != other.allowedOAuthScopes) return false
        if (analyticsConfiguration != other.analyticsConfiguration) return false
        if (authSessionValidity != other.authSessionValidity) return false
        if (callbackUrls != other.callbackUrls) return false
        if (clientName != other.clientName) return false
        if (defaultRedirectUri != other.defaultRedirectUri) return false
        if (enablePropagateAdditionalUserContextData != other.enablePropagateAdditionalUserContextData) return false
        if (enableTokenRevocation != other.enableTokenRevocation) return false
        if (explicitAuthFlows != other.explicitAuthFlows) return false
        if (generateSecret != other.generateSecret) return false
        if (idTokenValidity != other.idTokenValidity) return false
        if (logoutUrls != other.logoutUrls) return false
        if (preventUserExistenceErrors != other.preventUserExistenceErrors) return false
        if (readAttributes != other.readAttributes) return false
        if (refreshTokenValidity != other.refreshTokenValidity) return false
        if (supportedIdentityProviders != other.supportedIdentityProviders) return false
        if (tokenValidityUnits != other.tokenValidityUnits) return false
        if (userPoolId != other.userPoolId) return false
        if (writeAttributes != other.writeAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolClientRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
         *
         * For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours`, your user can authorize access with their access token for 10 hours.
         *
         * The default time unit for `AccessTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
         *
         * If you don't specify otherwise in the configuration of your app client, your access tokens are valid for one hour.
         */
        public var accessTokenValidity: kotlin.Int? = null
        /**
         * The allowed OAuth flows.
         *
         * ## code
         * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
         *
         * ## implicit
         * Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
         *
         * ## client_credentials
         * Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
         */
        public var allowedOAuthFlows: List<OAuthFlowType>? = null
        /**
         * Set to `true` to use OAuth 2.0 features in your user pool app client.
         *
         * `AllowedOAuthFlowsUserPoolClient` must be `true` before you can configure the following features in your app client.
         * + `CallBackURLs`: Callback URLs.
         * + `LogoutURLs`: Sign-out redirect URLs.
         * + `AllowedOAuthScopes`: OAuth 2.0 scopes.
         * + `AllowedOAuthFlows`: Support for authorization code, implicit, and client credentials OAuth 2.0 grants.
         *
         * To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set `AllowedOAuthFlowsUserPoolClient` to `true` in a `CreateUserPoolClient` or `UpdateUserPoolClient` API request. If you don't set a value for `AllowedOAuthFlowsUserPoolClient` in a request with the CLI or SDKs, it defaults to `false`.
         */
        public var allowedOAuthFlowsUserPoolClient: kotlin.Boolean? = null
        /**
         * The allowed OAuth scopes. Possible values provided by OAuth are `phone`, `email`, `openid`, and `profile`. Possible values provided by Amazon Web Services are `aws.cognito.signin.user.admin`. Custom scopes created in Resource Servers are also supported.
         */
        public var allowedOAuthScopes: List<String>? = null
        /**
         * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
         *
         * In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in Amazon Web Services Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         */
        public var analyticsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType? = null
        /**
         * Amazon Cognito creates a session token for each API request in an authentication flow. `AuthSessionValidity` is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.
         */
        public var authSessionValidity: kotlin.Int? = null
        /**
         * A list of allowed redirect (callback) URLs for the IdPs.
         *
         * A redirect URI must:
         * + Be an absolute URI.
         * + Be registered with the authorization server.
         * + Not include a fragment component.
         *
         * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
         *
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *
         * App callback URLs such as myapp://example are also supported.
         */
        public var callbackUrls: List<String>? = null
        /**
         * The client name for the user pool client you would like to create.
         */
        public var clientName: kotlin.String? = null
        /**
         * The default redirect URI. Must be in the `CallbackURLs` list.
         *
         * A redirect URI must:
         * + Be an absolute URI.
         * + Be registered with the authorization server.
         * + Not include a fragment component.
         *
         * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
         *
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *
         * App callback URLs such as myapp://example are also supported.
         */
        public var defaultRedirectUri: kotlin.String? = null
        /**
         * Activates the propagation of additional user context data. For more information about propagation of user context data, see [ Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html). If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret.
         */
        public var enablePropagateAdditionalUserContextData: kotlin.Boolean? = null
        /**
         * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
         *
         * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
         */
        public var enableTokenRevocation: kotlin.Boolean? = null
        /**
         * The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.
         *
         * If you don't specify a value for `ExplicitAuthFlows`, your user client supports `ALLOW_REFRESH_TOKEN_AUTH`, `ALLOW_USER_SRP_AUTH`, and `ALLOW_CUSTOM_AUTH`.
         *
         * Valid values include:
         * + `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
         * + `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
         * + `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         * + `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
         * + `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
         *
         * In some environments, you will see the values `ADMIN_NO_SRP_AUTH`, `CUSTOM_AUTH_FLOW_ONLY`, or `USER_PASSWORD_AUTH`. You can't assign these legacy `ExplicitAuthFlows` values to user pool clients at the same time as values that begin with `ALLOW_`, like `ALLOW_USER_SRP_AUTH`.
         */
        public var explicitAuthFlows: List<ExplicitAuthFlowsType>? = null
        /**
         * Boolean to specify whether you want to generate a secret for the user pool client being created.
         */
        public var generateSecret: kotlin.Boolean? = null
        /**
         * The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
         *
         * For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours`, your user can authenticate their session with their ID token for 10 hours.
         *
         * The default time unit for `IdTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
         *
         * If you don't specify otherwise in the configuration of your app client, your ID tokens are valid for one hour.
         */
        public var idTokenValidity: kotlin.Int? = null
        /**
         * A list of allowed logout URLs for the IdPs.
         */
        public var logoutUrls: List<String>? = null
        /**
         * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to `ENABLED` and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs return a `UserNotFoundException` exception if the user doesn't exist in the user pool.
         *
         * Valid values include:
         * + `ENABLED` - This prevents user existence-related errors.
         * + `LEGACY` - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.
         */
        public var preventUserExistenceErrors: aws.sdk.kotlin.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes? = null
        /**
         * The read attributes.
         */
        public var readAttributes: List<String>? = null
        /**
         * The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
         *
         * For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days`, your user can refresh their session and retrieve new access and ID tokens for 10 days.
         *
         * The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. *Valid range* is displayed below in seconds.
         *
         * If you don't specify otherwise in the configuration of your app client, your refresh tokens are valid for 30 days.
         */
        public var refreshTokenValidity: kotlin.Int? = null
        /**
         * A list of provider names for the identity providers (IdPs) that are supported on this client. The following are supported: `COGNITO`, `Facebook`, `Google`, `SignInWithApple`, and `LoginWithAmazon`. You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example `MySAMLIdP` or `MyOIDCIdP`.
         */
        public var supportedIdentityProviders: List<String>? = null
        /**
         * The units in which the validity times are represented. The default unit for RefreshToken is days, and default for ID and access tokens are hours.
         */
        public var tokenValidityUnits: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType? = null
        /**
         * The user pool ID for the user pool where you want to create a user pool client.
         */
        public var userPoolId: kotlin.String? = null
        /**
         * The user pool attributes that the app client can write to.
         *
         * If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see [Specifying IdP Attribute Mappings for Your user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
         */
        public var writeAttributes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolClientRequest) : this() {
            this.accessTokenValidity = x.accessTokenValidity
            this.allowedOAuthFlows = x.allowedOAuthFlows
            this.allowedOAuthFlowsUserPoolClient = x.allowedOAuthFlowsUserPoolClient
            this.allowedOAuthScopes = x.allowedOAuthScopes
            this.analyticsConfiguration = x.analyticsConfiguration
            this.authSessionValidity = x.authSessionValidity
            this.callbackUrls = x.callbackUrls
            this.clientName = x.clientName
            this.defaultRedirectUri = x.defaultRedirectUri
            this.enablePropagateAdditionalUserContextData = x.enablePropagateAdditionalUserContextData
            this.enableTokenRevocation = x.enableTokenRevocation
            this.explicitAuthFlows = x.explicitAuthFlows
            this.generateSecret = x.generateSecret
            this.idTokenValidity = x.idTokenValidity
            this.logoutUrls = x.logoutUrls
            this.preventUserExistenceErrors = x.preventUserExistenceErrors
            this.readAttributes = x.readAttributes
            this.refreshTokenValidity = x.refreshTokenValidity
            this.supportedIdentityProviders = x.supportedIdentityProviders
            this.tokenValidityUnits = x.tokenValidityUnits
            this.userPoolId = x.userPoolId
            this.writeAttributes = x.writeAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolClientRequest = CreateUserPoolClientRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType] inside the given [block]
         */
        public fun analyticsConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType.Builder.() -> kotlin.Unit) {
            this.analyticsConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType] inside the given [block]
         */
        public fun tokenValidityUnits(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType.Builder.() -> kotlin.Unit) {
            this.tokenValidityUnits = aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
