// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Represents the request to create a user in the specified user pool.
 */
public class AdminCreateUserRequest private constructor(builder: Builder) {
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
     *
     * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the *pre sign-up* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    public val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * Specify `"EMAIL"` if email will be used to send the welcome message. Specify `"SMS"` if the phone number will be used. The default value is `"SMS"`. You can specify more than one value.
     */
    public val desiredDeliveryMediums: List<DeliveryMediumType>? = builder.desiredDeliveryMediums
    /**
     * This parameter is used only if the `phone_number_verified` or `email_verified` attribute is set to `True`. Otherwise, it is ignored.
     *
     * If this parameter is set to `True` and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.
     *
     * If this parameter is set to `False`, the API throws an `AliasExistsException` error if the alias already exists. The default value is `False`.
     */
    public val forceAliasCreation: kotlin.Boolean? = builder.forceAliasCreation
    /**
     * Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. You can specify only one value.
     */
    public val messageAction: aws.sdk.kotlin.services.cognitoidentityprovider.model.MessageActionType? = builder.messageAction
    /**
     * The user's temporary password. This password must conform to the password policy that you specified when you created the user pool.
     *
     * The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page, along with a new password to be used in all future sign-ins.
     *
     * This parameter isn't required. If you don't specify a value, Amazon Cognito generates one for you.
     *
     * The temporary password can only be used until the user account expiration limit that you set for your user pool. To reset the account after that time limit, you must call `AdminCreateUser` again and specify `RESEND` for the `MessageAction` parameter.
     */
    public val temporaryPassword: kotlin.String? = builder.temporaryPassword
    /**
     * An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than `Username`. However, any attributes that you specify as required (when creating a user pool or in the **Attributes** tab of the console) either you should supply (in your call to `AdminCreateUser`) or the user should supply (when they sign up in response to your welcome message).
     *
     * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
     *
     * To send a message inviting the user to sign up, you must specify the user's email address or phone number. You can do this in your call to AdminCreateUser or in the **Users** tab of the Amazon Cognito console for managing your user pools.
     *
     * In your call to `AdminCreateUser`, you can set the `email_verified` attribute to `True`, and you can set the `phone_number_verified` attribute to `True`. You can also do this by calling [AdminUpdateUserAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html).
     * + **email**: The email address of the user to whom the message that contains the code and username will be sent. Required if the `email_verified` attribute is set to `True`, or if `"EMAIL"` is specified in the `DesiredDeliveryMediums` parameter.
     * + **phone_number**: The phone number of the user to whom the message that contains the code and username will be sent. Required if the `phone_number_verified` attribute is set to `True`, or if `"SMS"` is specified in the `DesiredDeliveryMediums` parameter.
     */
    public val userAttributes: List<AttributeType>? = builder.userAttributes
    /**
     * The user pool ID for the user pool where the user will be created.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The value that you want to set as the username sign-in attribute. The following conditions apply to the username parameter.
     * + The username can't be a duplicate of another username in the same user pool.
     * + You can't change the value of a username after you create it.
     * + You can only provide a value if usernames are a valid sign-in attribute for your user pool. If your user pool only supports phone numbers or email addresses as sign-in attributes, Amazon Cognito automatically generates a username value. For more information, see [Customizing sign-in attributes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases).
     */
    public val username: kotlin.String? = builder.username
    /**
     * The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.
     *
     * To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.
     *
     * The user's validation data isn't persisted.
     */
    public val validationData: List<AttributeType>? = builder.validationData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminCreateUserRequest(")
        append("clientMetadata=$clientMetadata,")
        append("desiredDeliveryMediums=$desiredDeliveryMediums,")
        append("forceAliasCreation=$forceAliasCreation,")
        append("messageAction=$messageAction,")
        append("temporaryPassword=*** Sensitive Data Redacted ***,")
        append("userAttributes=$userAttributes,")
        append("userPoolId=$userPoolId,")
        append("username=*** Sensitive Data Redacted ***,")
        append("validationData=$validationData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientMetadata?.hashCode() ?: 0
        result = 31 * result + (desiredDeliveryMediums?.hashCode() ?: 0)
        result = 31 * result + (forceAliasCreation?.hashCode() ?: 0)
        result = 31 * result + (messageAction?.hashCode() ?: 0)
        result = 31 * result + (temporaryPassword?.hashCode() ?: 0)
        result = 31 * result + (userAttributes?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        result = 31 * result + (validationData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminCreateUserRequest

        if (clientMetadata != other.clientMetadata) return false
        if (desiredDeliveryMediums != other.desiredDeliveryMediums) return false
        if (forceAliasCreation != other.forceAliasCreation) return false
        if (messageAction != other.messageAction) return false
        if (temporaryPassword != other.temporaryPassword) return false
        if (userAttributes != other.userAttributes) return false
        if (userPoolId != other.userPoolId) return false
        if (username != other.username) return false
        if (validationData != other.validationData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
         *
         * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the *pre sign-up* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        public var clientMetadata: Map<String, String>? = null
        /**
         * Specify `"EMAIL"` if email will be used to send the welcome message. Specify `"SMS"` if the phone number will be used. The default value is `"SMS"`. You can specify more than one value.
         */
        public var desiredDeliveryMediums: List<DeliveryMediumType>? = null
        /**
         * This parameter is used only if the `phone_number_verified` or `email_verified` attribute is set to `True`. Otherwise, it is ignored.
         *
         * If this parameter is set to `True` and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.
         *
         * If this parameter is set to `False`, the API throws an `AliasExistsException` error if the alias already exists. The default value is `False`.
         */
        public var forceAliasCreation: kotlin.Boolean? = null
        /**
         * Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. You can specify only one value.
         */
        public var messageAction: aws.sdk.kotlin.services.cognitoidentityprovider.model.MessageActionType? = null
        /**
         * The user's temporary password. This password must conform to the password policy that you specified when you created the user pool.
         *
         * The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page, along with a new password to be used in all future sign-ins.
         *
         * This parameter isn't required. If you don't specify a value, Amazon Cognito generates one for you.
         *
         * The temporary password can only be used until the user account expiration limit that you set for your user pool. To reset the account after that time limit, you must call `AdminCreateUser` again and specify `RESEND` for the `MessageAction` parameter.
         */
        public var temporaryPassword: kotlin.String? = null
        /**
         * An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than `Username`. However, any attributes that you specify as required (when creating a user pool or in the **Attributes** tab of the console) either you should supply (in your call to `AdminCreateUser`) or the user should supply (when they sign up in response to your welcome message).
         *
         * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
         *
         * To send a message inviting the user to sign up, you must specify the user's email address or phone number. You can do this in your call to AdminCreateUser or in the **Users** tab of the Amazon Cognito console for managing your user pools.
         *
         * In your call to `AdminCreateUser`, you can set the `email_verified` attribute to `True`, and you can set the `phone_number_verified` attribute to `True`. You can also do this by calling [AdminUpdateUserAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html).
         * + **email**: The email address of the user to whom the message that contains the code and username will be sent. Required if the `email_verified` attribute is set to `True`, or if `"EMAIL"` is specified in the `DesiredDeliveryMediums` parameter.
         * + **phone_number**: The phone number of the user to whom the message that contains the code and username will be sent. Required if the `phone_number_verified` attribute is set to `True`, or if `"SMS"` is specified in the `DesiredDeliveryMediums` parameter.
         */
        public var userAttributes: List<AttributeType>? = null
        /**
         * The user pool ID for the user pool where the user will be created.
         */
        public var userPoolId: kotlin.String? = null
        /**
         * The value that you want to set as the username sign-in attribute. The following conditions apply to the username parameter.
         * + The username can't be a duplicate of another username in the same user pool.
         * + You can't change the value of a username after you create it.
         * + You can only provide a value if usernames are a valid sign-in attribute for your user pool. If your user pool only supports phone numbers or email addresses as sign-in attributes, Amazon Cognito automatically generates a username value. For more information, see [Customizing sign-in attributes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases).
         */
        public var username: kotlin.String? = null
        /**
         * The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.
         *
         * To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.
         *
         * The user's validation data isn't persisted.
         */
        public var validationData: List<AttributeType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserRequest) : this() {
            this.clientMetadata = x.clientMetadata
            this.desiredDeliveryMediums = x.desiredDeliveryMediums
            this.forceAliasCreation = x.forceAliasCreation
            this.messageAction = x.messageAction
            this.temporaryPassword = x.temporaryPassword
            this.userAttributes = x.userAttributes
            this.userPoolId = x.userPoolId
            this.username = x.username
            this.validationData = x.validationData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserRequest = AdminCreateUserRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
