// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The configuration for creating a new user profile.
 */
public class AdminCreateUserConfigType private constructor(builder: Builder) {
    /**
     * Set to `True` if only the administrator is allowed to create user profiles. Set to `False` if users can sign themselves up via an app.
     */
    public val allowAdminCreateUserOnly: kotlin.Boolean = builder.allowAdminCreateUserOnly
    /**
     * The message template to be used for the welcome message to new users.
     *
     * See also [Customizing User Invitation Messages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization).
     */
    public val inviteMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.MessageTemplateType? = builder.inviteMessageTemplate
    /**
     * The user account expiration limit, in days, after which a new account that hasn't signed in is no longer usable. To reset the account after that time limit, you must call `AdminCreateUser` again, specifying `"RESEND"` for the `MessageAction` parameter. The default value for this parameter is 7.
     *
     * If you set a value for `TemporaryPasswordValidityDays` in `PasswordPolicy`, that value will be used, and `UnusedAccountValidityDays` will be no longer be an available parameter for that user pool.
     */
    public val unusedAccountValidityDays: kotlin.Int = builder.unusedAccountValidityDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminCreateUserConfigType(")
        append("allowAdminCreateUserOnly=$allowAdminCreateUserOnly,")
        append("inviteMessageTemplate=$inviteMessageTemplate,")
        append("unusedAccountValidityDays=$unusedAccountValidityDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowAdminCreateUserOnly.hashCode()
        result = 31 * result + (inviteMessageTemplate?.hashCode() ?: 0)
        result = 31 * result + (unusedAccountValidityDays)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminCreateUserConfigType

        if (allowAdminCreateUserOnly != other.allowAdminCreateUserOnly) return false
        if (inviteMessageTemplate != other.inviteMessageTemplate) return false
        if (unusedAccountValidityDays != other.unusedAccountValidityDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set to `True` if only the administrator is allowed to create user profiles. Set to `False` if users can sign themselves up via an app.
         */
        public var allowAdminCreateUserOnly: kotlin.Boolean = false
        /**
         * The message template to be used for the welcome message to new users.
         *
         * See also [Customizing User Invitation Messages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization).
         */
        public var inviteMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.MessageTemplateType? = null
        /**
         * The user account expiration limit, in days, after which a new account that hasn't signed in is no longer usable. To reset the account after that time limit, you must call `AdminCreateUser` again, specifying `"RESEND"` for the `MessageAction` parameter. The default value for this parameter is 7.
         *
         * If you set a value for `TemporaryPasswordValidityDays` in `PasswordPolicy`, that value will be used, and `UnusedAccountValidityDays` will be no longer be an available parameter for that user pool.
         */
        public var unusedAccountValidityDays: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType) : this() {
            this.allowAdminCreateUserOnly = x.allowAdminCreateUserOnly
            this.inviteMessageTemplate = x.inviteMessageTemplate
            this.unusedAccountValidityDays = x.unusedAccountValidityDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType = AdminCreateUserConfigType(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.MessageTemplateType] inside the given [block]
         */
        public fun inviteMessageTemplate(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.MessageTemplateType.Builder.() -> kotlin.Unit) {
            this.inviteMessageTemplate = aws.sdk.kotlin.services.cognitoidentityprovider.model.MessageTemplateType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
