// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.cognitoidentityprovider.auth.CognitoIdentityProviderAuthSchemeProvider
import aws.sdk.kotlin.services.cognitoidentityprovider.auth.DefaultCognitoIdentityProviderAuthSchemeProvider
import aws.sdk.kotlin.services.cognitoidentityprovider.endpoints.CognitoIdentityProviderEndpointParameters
import aws.sdk.kotlin.services.cognitoidentityprovider.endpoints.CognitoIdentityProviderEndpointProvider
import aws.sdk.kotlin.services.cognitoidentityprovider.endpoints.DefaultCognitoIdentityProviderEndpointProvider
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AddCustomAttributesRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AddCustomAttributesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDeleteUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDeleteUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDisableUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminDisableUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminEnableUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminEnableUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminForgetDeviceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminForgetDeviceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetDeviceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetDeviceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminGetUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminInitiateAuthRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminInitiateAuthResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListDevicesRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListDevicesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ChangePasswordRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ChangePasswordResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmDeviceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmDeviceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmSignUpRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmSignUpResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateIdentityProviderRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateIdentityProviderResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateResourceServerRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateResourceServerResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserImportJobRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserImportJobResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolClientRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolClientResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteResourceServerRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteResourceServerResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserAttributesRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserAttributesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserPoolRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserPoolResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeResourceServerRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeResourceServerResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserImportJobRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserImportJobResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserPoolRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.DescribeUserPoolResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgetDeviceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgetDeviceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgotPasswordRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgotPasswordResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetCsvHeaderRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetCsvHeaderResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetDeviceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetDeviceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetSigningCertificateRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetSigningCertificateResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUiCustomizationRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUiCustomizationResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GlobalSignOutRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GlobalSignOutResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListDevicesRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListDevicesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListGroupsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListGroupsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListResourceServersRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListResourceServersResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserImportJobsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserImportJobsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolClientsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolClientsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersInGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersInGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.RevokeTokenRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.RevokeTokenResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetRiskConfigurationRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetRiskConfigurationResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUiCustomizationRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUiCustomizationResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUserSettingsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUserSettingsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SignUpRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SignUpResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.StartUserImportJobRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.StartUserImportJobResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.StopUserImportJobRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.StopUserImportJobResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.TagResourceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.TagResourceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UntagResourceRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UntagResourceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateResourceServerRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateResourceServerResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserAttributesRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserAttributesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.VerifyUserAttributeRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.VerifyUserAttributeResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Cognito Identity Provider"
public const val SdkVersion: String = "1.0.2"

/**
 * With the Amazon Cognito user pools API, you can set up user pools and app clients, and authenticate users. To authenticate users from third-party identity providers (IdPs) in this API, you can [link IdP users to native user profiles](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html). Learn more about the authentication and authorization of federated users in the [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-userpools-server-contract-reference.html).
 *
 * This API reference provides detailed information about API operations and object types in Amazon Cognito. At the bottom of the page for each API operation and object, under *See Also*, you can learn how to use it in an Amazon Web Services SDK in the language of your choice.
 *
 * Along with resource management operations, the Amazon Cognito user pools API includes classes of operations and authorization models for client-side and server-side user operations. For more information, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html) in the *Amazon Cognito Developer Guide*.
 *
 * You can also start reading about the `CognitoIdentityProvider` client in the following SDK guides.
 * + [Amazon Web Services Command Line Interface](https://docs.aws.amazon.com/cli/latest/reference/cognito-idp/index.html#cli-aws-cognito-idp)
 * + [Amazon Web Services SDK for .NET](https://docs.aws.amazon.com/sdkfornet/v3/apidocs/items/CognitoIdentityProvider/TCognitoIdentityProviderClient.html)
 * + [Amazon Web Services SDK for C++](https://sdk.amazonaws.com/cpp/api/LATEST/aws-cpp-sdk-cognito-idp/html/class_aws_1_1_cognito_identity_provider_1_1_cognito_identity_provider_client.html)
 * + [Amazon Web Services SDK for Go](https://docs.aws.amazon.com/sdk-for-go/api/service/cognitoidentityprovider/#CognitoIdentityProvider)
 * + [Amazon Web Services SDK for Java V2](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/cognitoidentityprovider/CognitoIdentityProviderClient.html)
 * + [Amazon Web Services SDK for JavaScript](https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/CognitoIdentityServiceProvider.html)
 * + [Amazon Web Services SDK for PHP V3](https://docs.aws.amazon.com/aws-sdk-php/v3/api/api-cognito-idp-2016-04-18.html)
 * + [Amazon Web Services SDK for Python](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/cognito-idp.html)
 * + [Amazon Web Services SDK for Ruby V3](https://docs.aws.amazon.com/sdk-for-ruby/v3/api/Aws/CognitoIdentityProvider/Client.html)
 *
 * To get started with an Amazon Web Services SDK, see [Tools to Build on Amazon Web Services](http://aws.amazon.com/developer/tools/). For example actions and scenarios, see [Code examples for Amazon Cognito Identity Provider using Amazon Web Services SDKs](https://docs.aws.amazon.com/cognito/latest/developerguide/service_code_examples_cognito-identity-provider.html).
 */
public interface CognitoIdentityProviderClient : SdkClient {
    /**
     * CognitoIdentityProviderClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CognitoIdentityProviderClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CognitoIdentityProvider",
                "COGNITO_IDENTITY_PROVIDER",
                "cognito_identity_provider",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CognitoIdentityProviderClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CognitoIdentityProviderClient = DefaultCognitoIdentityProviderClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CognitoIdentityProviderEndpointProvider = builder.endpointProvider ?: DefaultCognitoIdentityProviderEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CognitoIdentityProviderAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCognitoIdentityProviderAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Cognito Identity Provider"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CognitoIdentityProviderEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CognitoIdentityProviderAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds additional user attributes to the user pool schema.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun addCustomAttributes(input: AddCustomAttributesRequest): AddCustomAttributesResponse

    /**
     * Adds the specified user to the specified group.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminAddUserToGroup(input: AdminAddUserToGroupRequest): AdminAddUserToGroupResponse

    /**
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminConfirmSignUp(input: AdminConfirmSignUpRequest): AdminConfirmSignUpResponse

    /**
     * Creates a new user in the specified user pool.
     *
     * If `MessageAction` isn't set, the default is to send a welcome message via email or phone (SMS).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.
     *
     * Alternatively, you can call `AdminCreateUser` with `SUPPRESS` for the `MessageAction` parameter, and Amazon Cognito won't send any email.
     *
     * In either case, the user will be in the `FORCE_CHANGE_PASSWORD` state until they sign in and change their password.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminCreateUser(input: AdminCreateUserRequest): AdminCreateUserResponse

    /**
     * Deletes a user as an administrator. Works on any user.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminDeleteUser(input: AdminDeleteUserRequest): AdminDeleteUserResponse

    /**
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminDeleteUserAttributes(input: AdminDeleteUserAttributesRequest): AdminDeleteUserAttributesResponse

    /**
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user and an existing user is removed. When the external user signs in again, and the user is no longer attached to the previously linked `DestinationUser`, the user must create a new user account. See [AdminLinkProviderForUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html).
     *
     * The `ProviderName` must match the value specified when creating an IdP for the pool.
     *
     * To deactivate a native username + password user, the `ProviderName` value must be `Cognito` and the `ProviderAttributeName` must be `Cognito_Subject`. The `ProviderAttributeValue` must be the name that is used in the user pool for the user.
     *
     * The `ProviderAttributeName` must always be `Cognito_Subject` for social IdPs. The `ProviderAttributeValue` must always be the exact subject that was used when the user was originally linked as a source user.
     *
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in, the `ProviderAttributeName` and `ProviderAttributeValue` must be the same values that were used for the `SourceUser` when the identities were originally linked using ` AdminLinkProviderForUser` call. (If the linking was done with `ProviderAttributeName` set to `Cognito_Subject`, the same applies here). However, if the user has already signed in, the `ProviderAttributeName` must be `Cognito_Subject` and `ProviderAttributeValue` must be the subject of the SAML assertion.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminDisableProviderForUser(input: AdminDisableProviderForUserRequest): AdminDisableProviderForUserResponse

    /**
     * Deactivates a user and revokes all access tokens for the user. A deactivated user can't sign in, but still appears in the responses to `GetUser` and `ListUsers` API requests.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminDisableUser(input: AdminDisableUserRequest): AdminDisableUserResponse

    /**
     * Enables the specified user as an administrator. Works on any user.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminEnableUser(input: AdminEnableUserRequest): AdminEnableUserResponse

    /**
     * Forgets the device, as an administrator.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminForgetDevice(input: AdminForgetDeviceRequest): AdminForgetDeviceResponse

    /**
     * Gets the device, as an administrator.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminGetDevice(input: AdminGetDeviceRequest): AdminGetDeviceResponse

    /**
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminGetUser(input: AdminGetUserRequest): AdminGetUserResponse

    /**
     * Initiates the authentication flow, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminInitiateAuth(input: AdminInitiateAuthRequest): AdminInitiateAuthResponse

    /**
     * Links an existing user account in a user pool (`DestinationUser`) to an identity from an external IdP (`SourceUser`) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account.
     *
     *  For example, if there is an existing user with a username and password, this API links that user to a federated user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
     *
     * The maximum number of federated identities linked to a user is five.
     *
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by the application owner.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminLinkProviderForUser(input: AdminLinkProviderForUserRequest): AdminLinkProviderForUserResponse

    /**
     * Lists devices, as an administrator.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminListDevices(input: AdminListDevicesRequest): AdminListDevicesResponse

    /**
     * Lists the groups that the user belongs to.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminListGroupsForUser(input: AdminListGroupsForUserRequest): AdminListGroupsForUserResponse

    /**
     * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminListUserAuthEvents(input: AdminListUserAuthEventsRequest): AdminListUserAuthEventsResponse

    /**
     * Removes the specified user from the specified group.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminRemoveUserFromGroup(input: AdminRemoveUserFromGroupRequest): AdminRemoveUserFromGroupResponse

    /**
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Deactivates a user's password, requiring them to change it. If a user tries to sign in after the API is called, Amazon Cognito responds with a `PasswordResetRequiredException` error. Your app must then perform the actions that reset your user's password: the forgot-password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminResetUserPassword(input: AdminResetUserPasswordRequest): AdminResetUserPasswordResponse

    /**
     * Responds to an authentication challenge, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminRespondToAuthChallenge(input: AdminRespondToAuthChallengeRequest): AdminRespondToAuthChallengeResponse

    /**
     * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminSetUserMfaPreference(input: AdminSetUserMfaPreferenceRequest): AdminSetUserMfaPreferenceResponse

    /**
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * The password can be temporary or permanent. If it is temporary, the user status enters the `FORCE_CHANGE_PASSWORD` state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the `NEW_PASSWORD_REQUIRED` challenge. If the user doesn't sign in before it expires, the user won't be able to sign in, and an administrator must reset their password.
     *
     * Once the user has set a new password, or the password is permanent, the user status is set to `Confirmed`.
     *
     * `AdminSetUserPassword` can set a password for the user profile that Amazon Cognito creates for third-party federated users. When you set a password, the federated user's status changes from `EXTERNAL_PROVIDER` to `CONFIRMED`. A user in this state can sign in as a federated user, and initiate authentication flows in the API like a linked native user. They can also modify their password and attributes in token-authenticated API requests like `ChangePassword` and `UpdateUserAttributes`. As a best security practice and to keep users in sync with your external IdP, don't set passwords on federated user profiles. To set up a federated user for native sign-in with a linked native user, refer to [Linking federated users to an existing user profile](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html).
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminSetUserPassword(input: AdminSetUserPasswordRequest): AdminSetUserPasswordResponse

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [AdminSetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html) instead.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminSetUserSettings(input: AdminSetUserSettingsRequest): AdminSetUserSettingsResponse

    /**
     * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminUpdateAuthEventFeedback(input: AdminUpdateAuthEventFeedbackRequest): AdminUpdateAuthEventFeedbackResponse

    /**
     * Updates the device status as an administrator.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminUpdateDeviceStatus(input: AdminUpdateDeviceStatusRequest): AdminUpdateDeviceStatusResponse

    /**
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user. To delete an attribute from your user, submit the attribute in your API request with a blank value.
     *
     * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
     *
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminUpdateUserAttributes(input: AdminUpdateUserAttributesRequest): AdminUpdateUserAttributesResponse

    /**
     * Signs out a user from all devices. `AdminUserGlobalSignOut` invalidates all identity, access and refresh tokens that Amazon Cognito has issued to a user. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the 1-hour cookie validity period.
     *
     * Your app isn't aware that a user's access token is revoked unless it attempts to authorize a user pools API request with an access token that contains the scope `aws.cognito.signin.user.admin`. Your app might otherwise accept access tokens until they expire.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun adminUserGlobalSignOut(input: AdminUserGlobalSignOutRequest): AdminUserGlobalSignOutResponse

    /**
     * Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response. You can authorize an `AssociateSoftwareToken` request with either the user's access token, or a session string from a challenge response that you received from Amazon Cognito.
     *
     * Amazon Cognito disassociates an existing software token when you verify the new token in a [ VerifySoftwareToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html) API request. If you don't verify the software token and your user pool doesn't require MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires TOTP MFA, Amazon Cognito generates an `MFA_SETUP` or `SOFTWARE_TOKEN_SETUP` challenge each time your user signs. Complete setup with `AssociateSoftwareToken` and `VerifySoftwareToken`.
     *
     * After you set up software token MFA for your user, Amazon Cognito generates a `SOFTWARE_TOKEN_MFA` challenge when they authenticate. Respond to this challenge with your user's TOTP.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun associateSoftwareToken(input: AssociateSoftwareTokenRequest = AssociateSoftwareTokenRequest { }): AssociateSoftwareTokenResponse

    /**
     * Changes the password for a specified user in a user pool.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun changePassword(input: ChangePasswordRequest): ChangePasswordResponse

    /**
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun confirmDevice(input: ConfirmDeviceRequest): ConfirmDeviceResponse

    /**
     * Allows a user to enter a confirmation code to reset a forgotten password.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun confirmForgotPassword(input: ConfirmForgotPasswordRequest): ConfirmForgotPasswordResponse

    /**
     * Confirms registration of a new user.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun confirmSignUp(input: ConfirmSignUpRequest): ConfirmSignUpResponse

    /**
     * Creates a new group in the specified user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates an IdP for a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun createIdentityProvider(input: CreateIdentityProviderRequest): CreateIdentityProviderResponse

    /**
     * Creates a new OAuth2.0 resource server and defines custom scopes within it.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun createResourceServer(input: CreateResourceServerRequest): CreateResourceServerResponse

    /**
     * Creates a user import job.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun createUserImportJob(input: CreateUserImportJobRequest): CreateUserImportJobResponse

    /**
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     *
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun createUserPool(input: CreateUserPoolRequest): CreateUserPoolResponse

    /**
     * Creates the user pool client.
     *
     * When you create a new user pool client, token revocation is automatically activated. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     *
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun createUserPoolClient(input: CreateUserPoolClientRequest): CreateUserPoolClientResponse

    /**
     * Creates a new domain for a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun createUserPoolDomain(input: CreateUserPoolDomainRequest): CreateUserPoolDomainResponse

    /**
     * Deletes a group.
     *
     * Calling this action requires developer credentials.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes an IdP for a user pool.
     */
    public suspend fun deleteIdentityProvider(input: DeleteIdentityProviderRequest): DeleteIdentityProviderResponse

    /**
     * Deletes a resource server.
     */
    public suspend fun deleteResourceServer(input: DeleteResourceServerRequest): DeleteResourceServerResponse

    /**
     * Allows a user to delete their own user profile.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes the attributes for a user.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun deleteUserAttributes(input: DeleteUserAttributesRequest): DeleteUserAttributesResponse

    /**
     * Deletes the specified Amazon Cognito user pool.
     */
    public suspend fun deleteUserPool(input: DeleteUserPoolRequest): DeleteUserPoolResponse

    /**
     * Allows the developer to delete the user pool client.
     */
    public suspend fun deleteUserPoolClient(input: DeleteUserPoolClientRequest): DeleteUserPoolClientResponse

    /**
     * Deletes a domain for a user pool.
     */
    public suspend fun deleteUserPoolDomain(input: DeleteUserPoolDomainRequest): DeleteUserPoolDomainResponse

    /**
     * Gets information about a specific IdP.
     */
    public suspend fun describeIdentityProvider(input: DescribeIdentityProviderRequest): DescribeIdentityProviderResponse

    /**
     * Describes a resource server.
     */
    public suspend fun describeResourceServer(input: DescribeResourceServerRequest): DescribeResourceServerResponse

    /**
     * Describes the risk configuration.
     */
    public suspend fun describeRiskConfiguration(input: DescribeRiskConfigurationRequest): DescribeRiskConfigurationResponse

    /**
     * Describes the user import job.
     */
    public suspend fun describeUserImportJob(input: DescribeUserImportJobRequest): DescribeUserImportJobResponse

    /**
     * Returns the configuration information and metadata of the specified user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun describeUserPool(input: DescribeUserPoolRequest): DescribeUserPoolResponse

    /**
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun describeUserPoolClient(input: DescribeUserPoolClientRequest): DescribeUserPoolClientResponse

    /**
     * Gets information about a domain.
     */
    public suspend fun describeUserPoolDomain(input: DescribeUserPoolDomainRequest): DescribeUserPoolDomainResponse

    /**
     * Forgets the specified device.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun forgetDevice(input: ForgetDeviceRequest): ForgetDeviceResponse

    /**
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the `Username` parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see [Recovering User Accounts](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html) in the *Amazon Cognito Developer Guide*. To use the confirmation code for resetting the password, call [ConfirmForgotPassword](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html).
     *
     * If neither a verified phone number nor a verified email exists, this API returns `InvalidParameterException`. If your app client has a client secret and you don't provide a `SECRET_HASH` parameter, this API returns `NotAuthorizedException`.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun forgotPassword(input: ForgotPasswordRequest): ForgotPasswordResponse

    /**
     * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
     */
    public suspend fun getCsvHeader(input: GetCsvHeaderRequest): GetCsvHeaderResponse

    /**
     * Gets the device.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse

    /**
     * Gets a group.
     *
     * Calling this action requires developer credentials.
     */
    public suspend fun getGroup(input: GetGroupRequest): GetGroupResponse

    /**
     * Gets the specified IdP.
     */
    public suspend fun getIdentityProviderByIdentifier(input: GetIdentityProviderByIdentifierRequest): GetIdentityProviderByIdentifierResponse

    /**
     * Gets the detailed activity logging configuration for a user pool.
     */
    public suspend fun getLogDeliveryConfiguration(input: GetLogDeliveryConfigurationRequest): GetLogDeliveryConfigurationResponse

    /**
     * This method takes a user pool ID, and returns the signing certificate. The issued certificate is valid for 10 years from the date of issue.
     *
     * Amazon Cognito issues and assigns a new signing certificate annually. This process returns a new value in the response to `GetSigningCertificate`, but doesn't invalidate the original certificate.
     */
    public suspend fun getSigningCertificate(input: GetSigningCertificateRequest): GetSigningCertificateResponse

    /**
     * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app `clientId` is `ALL`), then that information is returned. If nothing is present, then an empty shape is returned.
     */
    public suspend fun getUiCustomization(input: GetUiCustomizationRequest): GetUiCustomizationResponse

    /**
     * Gets the user attributes and metadata for a user.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun getUser(input: GetUserRequest): GetUserResponse

    /**
     * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun getUserAttributeVerificationCode(input: GetUserAttributeVerificationCodeRequest): GetUserAttributeVerificationCodeResponse

    /**
     * Gets the user pool multi-factor authentication (MFA) configuration.
     */
    public suspend fun getUserPoolMfaConfig(input: GetUserPoolMfaConfigRequest): GetUserPoolMfaConfigResponse

    /**
     * Signs out a user from all devices. `GlobalSignOut` invalidates all identity, access and refresh tokens that Amazon Cognito has issued to a user. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the 1-hour cookie validity period.
     *
     * Your app isn't aware that a user's access token is revoked unless it attempts to authorize a user pools API request with an access token that contains the scope `aws.cognito.signin.user.admin`. Your app might otherwise accept access tokens until they expire.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun globalSignOut(input: GlobalSignOutRequest): GlobalSignOutResponse

    /**
     * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP with `InitiateAuth`. For more information, see [ Adding user pool sign-in through a third party](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html).
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun initiateAuth(input: InitiateAuthRequest): InitiateAuthResponse

    /**
     * Lists the sign-in devices that Amazon Cognito has registered to the current user.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse

    /**
     * Lists the groups associated with a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists information about all IdPs for a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse

    /**
     * Lists the resource servers for a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listResourceServers(input: ListResourceServersRequest): ListResourceServersResponse

    /**
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     *
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * You can use this action up to 10 times per second, per account.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists user import jobs for a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listUserImportJobs(input: ListUserImportJobsRequest): ListUserImportJobsResponse

    /**
     * Lists the clients that have been created for the specified user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listUserPoolClients(input: ListUserPoolClientsRequest): ListUserPoolClientsResponse

    /**
     * Lists the user pools associated with an Amazon Web Services account.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listUserPools(input: ListUserPoolsRequest): ListUserPoolsResponse

    /**
     * Lists users and their basic details in a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists the users in the specified group.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun listUsersInGroup(input: ListUsersInGroupRequest): ListUsersInGroupResponse

    /**
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun resendConfirmationCode(input: ResendConfirmationCodeRequest): ResendConfirmationCodeResponse

    /**
     * Responds to the authentication challenge.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun respondToAuthChallenge(input: RespondToAuthChallengeRequest): RespondToAuthChallengeResponse

    /**
     * Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a token is revoked, you can't use the revoked token to access Amazon Cognito user APIs, or to authorize access to your resource server.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun revokeToken(input: RevokeTokenRequest): RevokeTokenResponse

    /**
     * Sets up or modifies the detailed activity logging configuration of a user pool.
     */
    public suspend fun setLogDeliveryConfiguration(input: SetLogDeliveryConfigurationRequest): SetLogDeliveryConfigurationResponse

    /**
     * Configures actions on detected risks. To delete the risk configuration for `UserPoolId` or `ClientId`, pass null values for all four configuration types.
     *
     * To activate Amazon Cognito advanced security features, update the user pool to include the `UserPoolAddOns` key`AdvancedSecurityMode`.
     */
    public suspend fun setRiskConfiguration(input: SetRiskConfigurationRequest): SetRiskConfigurationResponse

    /**
     * Sets the user interface (UI) customization information for a user pool's built-in app UI.
     *
     * You can specify app UI customization settings for a single client (with a specific `clientId`) or for all clients (by setting the `clientId` to `ALL`). If you specify `ALL`, the default configuration is used for every client that has no previously set UI customization. If you specify UI customization settings for a particular client, it will no longer return to the `ALL` configuration.
     *
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app's pages, and the service will throw an error.
     */
    public suspend fun setUiCustomization(input: SetUiCustomizationRequest): SetUiCustomizationResponse

    /**
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun setUserMfaPreference(input: SetUserMfaPreferenceRequest): SetUserMfaPreferenceResponse

    /**
     * Sets the user pool multi-factor authentication (MFA) configuration.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun setUserPoolMfaConfig(input: SetUserPoolMfaConfigRequest): SetUserPoolMfaConfigResponse

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [SetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html) instead.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun setUserSettings(input: SetUserSettingsRequest): SetUserSettingsResponse

    /**
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun signUp(input: SignUpRequest): SignUpResponse

    /**
     * Starts the user import.
     */
    public suspend fun startUserImportJob(input: StartUserImportJobRequest): StartUserImportJobResponse

    /**
     * Stops the user import job.
     */
    public suspend fun stopUserImportJob(input: StopUserImportJobRequest): StopUserImportJobResponse

    /**
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an `Environment` tag key to both user pools. The value of this key might be `Test` for one user pool, and `Production` for the other.
     *
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag values.
     *
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun updateAuthEventFeedback(input: UpdateAuthEventFeedbackRequest): UpdateAuthEventFeedbackResponse

    /**
     * Updates the device status.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun updateDeviceStatus(input: UpdateDeviceStatusRequest): UpdateDeviceStatusResponse

    /**
     * Updates the specified group with the specified attributes.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Updates IdP information for a user pool.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun updateIdentityProvider(input: UpdateIdentityProviderRequest): UpdateIdentityProviderResponse

    /**
     * Updates the name and scopes of resource server. All other fields are read-only.
     *
     * If you don't provide a value for an attribute, it is set to the default value.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun updateResourceServer(input: UpdateResourceServerRequest): UpdateResourceServerResponse

    /**
     * Allows a user to update a specific attribute (one at a time).
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    public suspend fun updateUserAttributes(input: UpdateUserAttributesRequest): UpdateUserAttributesResponse

    /**
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html).
     *
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun updateUserPool(input: UpdateUserPoolRequest): UpdateUserPoolResponse

    /**
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using [DescribeUserPoolClient](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html).
     *
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     *
     * You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun updateUserPoolClient(input: UpdateUserPoolClientRequest): UpdateUserPoolClientResponse

    /**
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     *
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You can't use it to change the domain for a user pool.
     *
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.
     *
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.
     *
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     *
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services Region.
     *
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.
     *
     * For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
     *
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
     *
     * **Learn more**
     * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
     * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
     */
    public suspend fun updateUserPoolDomain(input: UpdateUserPoolDomainRequest): UpdateUserPoolDomainResponse

    /**
     * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun verifySoftwareToken(input: VerifySoftwareTokenRequest): VerifySoftwareTokenResponse

    /**
     * Verifies the specified user attributes in the user pool.
     *
     *  If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute updates the affected attribute to its pending value. For more information, see [ UserAttributeUpdateSettingsType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html).
     *
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
     */
    public suspend fun verifyUserAttribute(input: VerifyUserAttributeRequest): VerifyUserAttributeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CognitoIdentityProviderClient.withConfig(block: CognitoIdentityProviderClient.Config.Builder.() -> Unit): CognitoIdentityProviderClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCognitoIdentityProviderClient(newConfig)
}

/**
 * Adds additional user attributes to the user pool schema.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.addCustomAttributes(crossinline block: AddCustomAttributesRequest.Builder.() -> Unit): AddCustomAttributesResponse = addCustomAttributes(AddCustomAttributesRequest.Builder().apply(block).build())

/**
 * Adds the specified user to the specified group.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminAddUserToGroup(crossinline block: AdminAddUserToGroupRequest.Builder.() -> Unit): AdminAddUserToGroupResponse = adminAddUserToGroup(AdminAddUserToGroupRequest.Builder().apply(block).build())

/**
 * Confirms user registration as an admin without using a confirmation code. Works on any user.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminConfirmSignUp(crossinline block: AdminConfirmSignUpRequest.Builder.() -> Unit): AdminConfirmSignUpResponse = adminConfirmSignUp(AdminConfirmSignUpRequest.Builder().apply(block).build())

/**
 * Creates a new user in the specified user pool.
 *
 * If `MessageAction` isn't set, the default is to send a welcome message via email or phone (SMS).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 *
 * This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.
 *
 * Alternatively, you can call `AdminCreateUser` with `SUPPRESS` for the `MessageAction` parameter, and Amazon Cognito won't send any email.
 *
 * In either case, the user will be in the `FORCE_CHANGE_PASSWORD` state until they sign in and change their password.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminCreateUser(crossinline block: AdminCreateUserRequest.Builder.() -> Unit): AdminCreateUserResponse = adminCreateUser(AdminCreateUserRequest.Builder().apply(block).build())

/**
 * Deletes a user as an administrator. Works on any user.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminDeleteUser(crossinline block: AdminDeleteUserRequest.Builder.() -> Unit): AdminDeleteUserResponse = adminDeleteUser(AdminDeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes the user attributes in a user pool as an administrator. Works on any user.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminDeleteUserAttributes(crossinline block: AdminDeleteUserAttributesRequest.Builder.() -> Unit): AdminDeleteUserAttributesResponse = adminDeleteUserAttributes(AdminDeleteUserAttributesRequest.Builder().apply(block).build())

/**
 * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user and an existing user is removed. When the external user signs in again, and the user is no longer attached to the previously linked `DestinationUser`, the user must create a new user account. See [AdminLinkProviderForUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html).
 *
 * The `ProviderName` must match the value specified when creating an IdP for the pool.
 *
 * To deactivate a native username + password user, the `ProviderName` value must be `Cognito` and the `ProviderAttributeName` must be `Cognito_Subject`. The `ProviderAttributeValue` must be the name that is used in the user pool for the user.
 *
 * The `ProviderAttributeName` must always be `Cognito_Subject` for social IdPs. The `ProviderAttributeValue` must always be the exact subject that was used when the user was originally linked as a source user.
 *
 * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in, the `ProviderAttributeName` and `ProviderAttributeValue` must be the same values that were used for the `SourceUser` when the identities were originally linked using ` AdminLinkProviderForUser` call. (If the linking was done with `ProviderAttributeName` set to `Cognito_Subject`, the same applies here). However, if the user has already signed in, the `ProviderAttributeName` must be `Cognito_Subject` and `ProviderAttributeValue` must be the subject of the SAML assertion.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminDisableProviderForUser(crossinline block: AdminDisableProviderForUserRequest.Builder.() -> Unit): AdminDisableProviderForUserResponse = adminDisableProviderForUser(AdminDisableProviderForUserRequest.Builder().apply(block).build())

/**
 * Deactivates a user and revokes all access tokens for the user. A deactivated user can't sign in, but still appears in the responses to `GetUser` and `ListUsers` API requests.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminDisableUser(crossinline block: AdminDisableUserRequest.Builder.() -> Unit): AdminDisableUserResponse = adminDisableUser(AdminDisableUserRequest.Builder().apply(block).build())

/**
 * Enables the specified user as an administrator. Works on any user.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminEnableUser(crossinline block: AdminEnableUserRequest.Builder.() -> Unit): AdminEnableUserResponse = adminEnableUser(AdminEnableUserRequest.Builder().apply(block).build())

/**
 * Forgets the device, as an administrator.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminForgetDevice(crossinline block: AdminForgetDeviceRequest.Builder.() -> Unit): AdminForgetDeviceResponse = adminForgetDevice(AdminForgetDeviceRequest.Builder().apply(block).build())

/**
 * Gets the device, as an administrator.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminGetDevice(crossinline block: AdminGetDeviceRequest.Builder.() -> Unit): AdminGetDeviceResponse = adminGetDevice(AdminGetDeviceRequest.Builder().apply(block).build())

/**
 * Gets the specified user by user name in a user pool as an administrator. Works on any user.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminGetUser(crossinline block: AdminGetUserRequest.Builder.() -> Unit): AdminGetUserResponse = adminGetUser(AdminGetUserRequest.Builder().apply(block).build())

/**
 * Initiates the authentication flow, as an administrator.
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminInitiateAuth(crossinline block: AdminInitiateAuthRequest.Builder.() -> Unit): AdminInitiateAuthResponse = adminInitiateAuth(AdminInitiateAuthRequest.Builder().apply(block).build())

/**
 * Links an existing user account in a user pool (`DestinationUser`) to an identity from an external IdP (`SourceUser`) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account.
 *
 *  For example, if there is an existing user with a username and password, this API links that user to a federated user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
 *
 * The maximum number of federated identities linked to a user is five.
 *
 * Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by the application owner.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminLinkProviderForUser(crossinline block: AdminLinkProviderForUserRequest.Builder.() -> Unit): AdminLinkProviderForUserResponse = adminLinkProviderForUser(AdminLinkProviderForUserRequest.Builder().apply(block).build())

/**
 * Lists devices, as an administrator.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminListDevices(crossinline block: AdminListDevicesRequest.Builder.() -> Unit): AdminListDevicesResponse = adminListDevices(AdminListDevicesRequest.Builder().apply(block).build())

/**
 * Lists the groups that the user belongs to.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminListGroupsForUser(crossinline block: AdminListGroupsForUserRequest.Builder.() -> Unit): AdminListGroupsForUserResponse = adminListGroupsForUser(AdminListGroupsForUserRequest.Builder().apply(block).build())

/**
 * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminListUserAuthEvents(crossinline block: AdminListUserAuthEventsRequest.Builder.() -> Unit): AdminListUserAuthEventsResponse = adminListUserAuthEvents(AdminListUserAuthEventsRequest.Builder().apply(block).build())

/**
 * Removes the specified user from the specified group.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminRemoveUserFromGroup(crossinline block: AdminRemoveUserFromGroupRequest.Builder.() -> Unit): AdminRemoveUserFromGroupResponse = adminRemoveUserFromGroup(AdminRemoveUserFromGroupRequest.Builder().apply(block).build())

/**
 * Resets the specified user's password in a user pool as an administrator. Works on any user.
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 *
 * Deactivates a user's password, requiring them to change it. If a user tries to sign in after the API is called, Amazon Cognito responds with a `PasswordResetRequiredException` error. Your app must then perform the actions that reset your user's password: the forgot-password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminResetUserPassword(crossinline block: AdminResetUserPasswordRequest.Builder.() -> Unit): AdminResetUserPasswordResponse = adminResetUserPassword(AdminResetUserPasswordRequest.Builder().apply(block).build())

/**
 * Responds to an authentication challenge, as an administrator.
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminRespondToAuthChallenge(crossinline block: AdminRespondToAuthChallengeRequest.Builder.() -> Unit): AdminRespondToAuthChallengeResponse = adminRespondToAuthChallenge(AdminRespondToAuthChallengeRequest.Builder().apply(block).build())

/**
 * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminSetUserMfaPreference(crossinline block: AdminSetUserMfaPreferenceRequest.Builder.() -> Unit): AdminSetUserMfaPreferenceResponse = adminSetUserMfaPreference(AdminSetUserMfaPreferenceRequest.Builder().apply(block).build())

/**
 * Sets the specified user's password in a user pool as an administrator. Works on any user.
 *
 * The password can be temporary or permanent. If it is temporary, the user status enters the `FORCE_CHANGE_PASSWORD` state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the `NEW_PASSWORD_REQUIRED` challenge. If the user doesn't sign in before it expires, the user won't be able to sign in, and an administrator must reset their password.
 *
 * Once the user has set a new password, or the password is permanent, the user status is set to `Confirmed`.
 *
 * `AdminSetUserPassword` can set a password for the user profile that Amazon Cognito creates for third-party federated users. When you set a password, the federated user's status changes from `EXTERNAL_PROVIDER` to `CONFIRMED`. A user in this state can sign in as a federated user, and initiate authentication flows in the API like a linked native user. They can also modify their password and attributes in token-authenticated API requests like `ChangePassword` and `UpdateUserAttributes`. As a best security practice and to keep users in sync with your external IdP, don't set passwords on federated user profiles. To set up a federated user for native sign-in with a linked native user, refer to [Linking federated users to an existing user profile](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html).
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminSetUserPassword(crossinline block: AdminSetUserPasswordRequest.Builder.() -> Unit): AdminSetUserPasswordResponse = adminSetUserPassword(AdminSetUserPasswordRequest.Builder().apply(block).build())

/**
 * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [AdminSetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html) instead.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminSetUserSettings(crossinline block: AdminSetUserSettingsRequest.Builder.() -> Unit): AdminSetUserSettingsResponse = adminSetUserSettings(AdminSetUserSettingsRequest.Builder().apply(block).build())

/**
 * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminUpdateAuthEventFeedback(crossinline block: AdminUpdateAuthEventFeedbackRequest.Builder.() -> Unit): AdminUpdateAuthEventFeedbackResponse = adminUpdateAuthEventFeedback(AdminUpdateAuthEventFeedbackRequest.Builder().apply(block).build())

/**
 * Updates the device status as an administrator.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminUpdateDeviceStatus(crossinline block: AdminUpdateDeviceStatusRequest.Builder.() -> Unit): AdminUpdateDeviceStatusResponse = adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest.Builder().apply(block).build())

/**
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 *
 * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user. To delete an attribute from your user, submit the attribute in your API request with a blank value.
 *
 * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
 *
 * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminUpdateUserAttributes(crossinline block: AdminUpdateUserAttributesRequest.Builder.() -> Unit): AdminUpdateUserAttributesResponse = adminUpdateUserAttributes(AdminUpdateUserAttributesRequest.Builder().apply(block).build())

/**
 * Signs out a user from all devices. `AdminUserGlobalSignOut` invalidates all identity, access and refresh tokens that Amazon Cognito has issued to a user. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the 1-hour cookie validity period.
 *
 * Your app isn't aware that a user's access token is revoked unless it attempts to authorize a user pools API request with an access token that contains the scope `aws.cognito.signin.user.admin`. Your app might otherwise accept access tokens until they expire.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.adminUserGlobalSignOut(crossinline block: AdminUserGlobalSignOutRequest.Builder.() -> Unit): AdminUserGlobalSignOutResponse = adminUserGlobalSignOut(AdminUserGlobalSignOutRequest.Builder().apply(block).build())

/**
 * Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response. You can authorize an `AssociateSoftwareToken` request with either the user's access token, or a session string from a challenge response that you received from Amazon Cognito.
 *
 * Amazon Cognito disassociates an existing software token when you verify the new token in a [ VerifySoftwareToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html) API request. If you don't verify the software token and your user pool doesn't require MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires TOTP MFA, Amazon Cognito generates an `MFA_SETUP` or `SOFTWARE_TOKEN_SETUP` challenge each time your user signs. Complete setup with `AssociateSoftwareToken` and `VerifySoftwareToken`.
 *
 * After you set up software token MFA for your user, Amazon Cognito generates a `SOFTWARE_TOKEN_MFA` challenge when they authenticate. Respond to this challenge with your user's TOTP.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.associateSoftwareToken(crossinline block: AssociateSoftwareTokenRequest.Builder.() -> Unit): AssociateSoftwareTokenResponse = associateSoftwareToken(AssociateSoftwareTokenRequest.Builder().apply(block).build())

/**
 * Changes the password for a specified user in a user pool.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.changePassword(crossinline block: ChangePasswordRequest.Builder.() -> Unit): ChangePasswordResponse = changePassword(ChangePasswordRequest.Builder().apply(block).build())

/**
 * Confirms tracking of the device. This API call is the call that begins device tracking.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.confirmDevice(crossinline block: ConfirmDeviceRequest.Builder.() -> Unit): ConfirmDeviceResponse = confirmDevice(ConfirmDeviceRequest.Builder().apply(block).build())

/**
 * Allows a user to enter a confirmation code to reset a forgotten password.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.confirmForgotPassword(crossinline block: ConfirmForgotPasswordRequest.Builder.() -> Unit): ConfirmForgotPasswordResponse = confirmForgotPassword(ConfirmForgotPasswordRequest.Builder().apply(block).build())

/**
 * Confirms registration of a new user.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.confirmSignUp(crossinline block: ConfirmSignUpRequest.Builder.() -> Unit): ConfirmSignUpResponse = confirmSignUp(ConfirmSignUpRequest.Builder().apply(block).build())

/**
 * Creates a new group in the specified user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Creates an IdP for a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.createIdentityProvider(crossinline block: CreateIdentityProviderRequest.Builder.() -> Unit): CreateIdentityProviderResponse = createIdentityProvider(CreateIdentityProviderRequest.Builder().apply(block).build())

/**
 * Creates a new OAuth2.0 resource server and defines custom scopes within it.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.createResourceServer(crossinline block: CreateResourceServerRequest.Builder.() -> Unit): CreateResourceServerResponse = createResourceServer(CreateResourceServerRequest.Builder().apply(block).build())

/**
 * Creates a user import job.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.createUserImportJob(crossinline block: CreateUserImportJobRequest.Builder.() -> Unit): CreateUserImportJobResponse = createUserImportJob(CreateUserImportJobRequest.Builder().apply(block).build())

/**
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 *
 * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
 *
 * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.createUserPool(crossinline block: CreateUserPoolRequest.Builder.() -> Unit): CreateUserPoolResponse = createUserPool(CreateUserPoolRequest.Builder().apply(block).build())

/**
 * Creates the user pool client.
 *
 * When you create a new user pool client, token revocation is automatically activated. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
 *
 * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.createUserPoolClient(crossinline block: CreateUserPoolClientRequest.Builder.() -> Unit): CreateUserPoolClientResponse = createUserPoolClient(CreateUserPoolClientRequest.Builder().apply(block).build())

/**
 * Creates a new domain for a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.createUserPoolDomain(crossinline block: CreateUserPoolDomainRequest.Builder.() -> Unit): CreateUserPoolDomainResponse = createUserPoolDomain(CreateUserPoolDomainRequest.Builder().apply(block).build())

/**
 * Deletes a group.
 *
 * Calling this action requires developer credentials.
 */
public suspend inline fun CognitoIdentityProviderClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Deletes an IdP for a user pool.
 */
public suspend inline fun CognitoIdentityProviderClient.deleteIdentityProvider(crossinline block: DeleteIdentityProviderRequest.Builder.() -> Unit): DeleteIdentityProviderResponse = deleteIdentityProvider(DeleteIdentityProviderRequest.Builder().apply(block).build())

/**
 * Deletes a resource server.
 */
public suspend inline fun CognitoIdentityProviderClient.deleteResourceServer(crossinline block: DeleteResourceServerRequest.Builder.() -> Unit): DeleteResourceServerResponse = deleteResourceServer(DeleteResourceServerRequest.Builder().apply(block).build())

/**
 * Allows a user to delete their own user profile.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes the attributes for a user.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.deleteUserAttributes(crossinline block: DeleteUserAttributesRequest.Builder.() -> Unit): DeleteUserAttributesResponse = deleteUserAttributes(DeleteUserAttributesRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Cognito user pool.
 */
public suspend inline fun CognitoIdentityProviderClient.deleteUserPool(crossinline block: DeleteUserPoolRequest.Builder.() -> Unit): DeleteUserPoolResponse = deleteUserPool(DeleteUserPoolRequest.Builder().apply(block).build())

/**
 * Allows the developer to delete the user pool client.
 */
public suspend inline fun CognitoIdentityProviderClient.deleteUserPoolClient(crossinline block: DeleteUserPoolClientRequest.Builder.() -> Unit): DeleteUserPoolClientResponse = deleteUserPoolClient(DeleteUserPoolClientRequest.Builder().apply(block).build())

/**
 * Deletes a domain for a user pool.
 */
public suspend inline fun CognitoIdentityProviderClient.deleteUserPoolDomain(crossinline block: DeleteUserPoolDomainRequest.Builder.() -> Unit): DeleteUserPoolDomainResponse = deleteUserPoolDomain(DeleteUserPoolDomainRequest.Builder().apply(block).build())

/**
 * Gets information about a specific IdP.
 */
public suspend inline fun CognitoIdentityProviderClient.describeIdentityProvider(crossinline block: DescribeIdentityProviderRequest.Builder.() -> Unit): DescribeIdentityProviderResponse = describeIdentityProvider(DescribeIdentityProviderRequest.Builder().apply(block).build())

/**
 * Describes a resource server.
 */
public suspend inline fun CognitoIdentityProviderClient.describeResourceServer(crossinline block: DescribeResourceServerRequest.Builder.() -> Unit): DescribeResourceServerResponse = describeResourceServer(DescribeResourceServerRequest.Builder().apply(block).build())

/**
 * Describes the risk configuration.
 */
public suspend inline fun CognitoIdentityProviderClient.describeRiskConfiguration(crossinline block: DescribeRiskConfigurationRequest.Builder.() -> Unit): DescribeRiskConfigurationResponse = describeRiskConfiguration(DescribeRiskConfigurationRequest.Builder().apply(block).build())

/**
 * Describes the user import job.
 */
public suspend inline fun CognitoIdentityProviderClient.describeUserImportJob(crossinline block: DescribeUserImportJobRequest.Builder.() -> Unit): DescribeUserImportJobResponse = describeUserImportJob(DescribeUserImportJobRequest.Builder().apply(block).build())

/**
 * Returns the configuration information and metadata of the specified user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.describeUserPool(crossinline block: DescribeUserPoolRequest.Builder.() -> Unit): DescribeUserPoolResponse = describeUserPool(DescribeUserPoolRequest.Builder().apply(block).build())

/**
 * Client method for returning the configuration information and metadata of the specified user pool app client.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.describeUserPoolClient(crossinline block: DescribeUserPoolClientRequest.Builder.() -> Unit): DescribeUserPoolClientResponse = describeUserPoolClient(DescribeUserPoolClientRequest.Builder().apply(block).build())

/**
 * Gets information about a domain.
 */
public suspend inline fun CognitoIdentityProviderClient.describeUserPoolDomain(crossinline block: DescribeUserPoolDomainRequest.Builder.() -> Unit): DescribeUserPoolDomainResponse = describeUserPoolDomain(DescribeUserPoolDomainRequest.Builder().apply(block).build())

/**
 * Forgets the specified device.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.forgetDevice(crossinline block: ForgetDeviceRequest.Builder.() -> Unit): ForgetDeviceResponse = forgetDevice(ForgetDeviceRequest.Builder().apply(block).build())

/**
 * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the `Username` parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see [Recovering User Accounts](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html) in the *Amazon Cognito Developer Guide*. To use the confirmation code for resetting the password, call [ConfirmForgotPassword](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html).
 *
 * If neither a verified phone number nor a verified email exists, this API returns `InvalidParameterException`. If your app client has a client secret and you don't provide a `SECRET_HASH` parameter, this API returns `NotAuthorizedException`.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.forgotPassword(crossinline block: ForgotPasswordRequest.Builder.() -> Unit): ForgotPasswordResponse = forgotPassword(ForgotPasswordRequest.Builder().apply(block).build())

/**
 * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
 */
public suspend inline fun CognitoIdentityProviderClient.getCsvHeader(crossinline block: GetCsvHeaderRequest.Builder.() -> Unit): GetCsvHeaderResponse = getCsvHeader(GetCsvHeaderRequest.Builder().apply(block).build())

/**
 * Gets the device.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.getDevice(crossinline block: GetDeviceRequest.Builder.() -> Unit): GetDeviceResponse = getDevice(GetDeviceRequest.Builder().apply(block).build())

/**
 * Gets a group.
 *
 * Calling this action requires developer credentials.
 */
public suspend inline fun CognitoIdentityProviderClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Gets the specified IdP.
 */
public suspend inline fun CognitoIdentityProviderClient.getIdentityProviderByIdentifier(crossinline block: GetIdentityProviderByIdentifierRequest.Builder.() -> Unit): GetIdentityProviderByIdentifierResponse = getIdentityProviderByIdentifier(GetIdentityProviderByIdentifierRequest.Builder().apply(block).build())

/**
 * Gets the detailed activity logging configuration for a user pool.
 */
public suspend inline fun CognitoIdentityProviderClient.getLogDeliveryConfiguration(crossinline block: GetLogDeliveryConfigurationRequest.Builder.() -> Unit): GetLogDeliveryConfigurationResponse = getLogDeliveryConfiguration(GetLogDeliveryConfigurationRequest.Builder().apply(block).build())

/**
 * This method takes a user pool ID, and returns the signing certificate. The issued certificate is valid for 10 years from the date of issue.
 *
 * Amazon Cognito issues and assigns a new signing certificate annually. This process returns a new value in the response to `GetSigningCertificate`, but doesn't invalidate the original certificate.
 */
public suspend inline fun CognitoIdentityProviderClient.getSigningCertificate(crossinline block: GetSigningCertificateRequest.Builder.() -> Unit): GetSigningCertificateResponse = getSigningCertificate(GetSigningCertificateRequest.Builder().apply(block).build())

/**
 * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app `clientId` is `ALL`), then that information is returned. If nothing is present, then an empty shape is returned.
 */
public suspend inline fun CognitoIdentityProviderClient.getUiCustomization(crossinline block: GetUiCustomizationRequest.Builder.() -> Unit): GetUiCustomizationResponse = getUiCustomization(GetUiCustomizationRequest.Builder().apply(block).build())

/**
 * Gets the user attributes and metadata for a user.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.getUser(crossinline block: GetUserRequest.Builder.() -> Unit): GetUserResponse = getUser(GetUserRequest.Builder().apply(block).build())

/**
 * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.getUserAttributeVerificationCode(crossinline block: GetUserAttributeVerificationCodeRequest.Builder.() -> Unit): GetUserAttributeVerificationCodeResponse = getUserAttributeVerificationCode(GetUserAttributeVerificationCodeRequest.Builder().apply(block).build())

/**
 * Gets the user pool multi-factor authentication (MFA) configuration.
 */
public suspend inline fun CognitoIdentityProviderClient.getUserPoolMfaConfig(crossinline block: GetUserPoolMfaConfigRequest.Builder.() -> Unit): GetUserPoolMfaConfigResponse = getUserPoolMfaConfig(GetUserPoolMfaConfigRequest.Builder().apply(block).build())

/**
 * Signs out a user from all devices. `GlobalSignOut` invalidates all identity, access and refresh tokens that Amazon Cognito has issued to a user. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the 1-hour cookie validity period.
 *
 * Your app isn't aware that a user's access token is revoked unless it attempts to authorize a user pools API request with an access token that contains the scope `aws.cognito.signin.user.admin`. Your app might otherwise accept access tokens until they expire.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.globalSignOut(crossinline block: GlobalSignOutRequest.Builder.() -> Unit): GlobalSignOutResponse = globalSignOut(GlobalSignOutRequest.Builder().apply(block).build())

/**
 * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP with `InitiateAuth`. For more information, see [ Adding user pool sign-in through a third party](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html).
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.initiateAuth(crossinline block: InitiateAuthRequest.Builder.() -> Unit): InitiateAuthResponse = initiateAuth(InitiateAuthRequest.Builder().apply(block).build())

/**
 * Lists the sign-in devices that Amazon Cognito has registered to the current user.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.listDevices(crossinline block: ListDevicesRequest.Builder.() -> Unit): ListDevicesResponse = listDevices(ListDevicesRequest.Builder().apply(block).build())

/**
 * Lists the groups associated with a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Lists information about all IdPs for a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listIdentityProviders(crossinline block: ListIdentityProvidersRequest.Builder.() -> Unit): ListIdentityProvidersResponse = listIdentityProviders(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * Lists the resource servers for a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listResourceServers(crossinline block: ListResourceServersRequest.Builder.() -> Unit): ListResourceServersResponse = listResourceServers(ListResourceServersRequest.Builder().apply(block).build())

/**
 * Lists the tags that are assigned to an Amazon Cognito user pool.
 *
 * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
 *
 * You can use this action up to 10 times per second, per account.
 */
public suspend inline fun CognitoIdentityProviderClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists user import jobs for a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listUserImportJobs(crossinline block: ListUserImportJobsRequest.Builder.() -> Unit): ListUserImportJobsResponse = listUserImportJobs(ListUserImportJobsRequest.Builder().apply(block).build())

/**
 * Lists the clients that have been created for the specified user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listUserPoolClients(crossinline block: ListUserPoolClientsRequest.Builder.() -> Unit): ListUserPoolClientsResponse = listUserPoolClients(ListUserPoolClientsRequest.Builder().apply(block).build())

/**
 * Lists the user pools associated with an Amazon Web Services account.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listUserPools(crossinline block: ListUserPoolsRequest.Builder.() -> Unit): ListUserPoolsResponse = listUserPools(ListUserPoolsRequest.Builder().apply(block).build())

/**
 * Lists users and their basic details in a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Lists the users in the specified group.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.listUsersInGroup(crossinline block: ListUsersInGroupRequest.Builder.() -> Unit): ListUsersInGroupResponse = listUsersInGroup(ListUsersInGroupRequest.Builder().apply(block).build())

/**
 * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.resendConfirmationCode(crossinline block: ResendConfirmationCodeRequest.Builder.() -> Unit): ResendConfirmationCodeResponse = resendConfirmationCode(ResendConfirmationCodeRequest.Builder().apply(block).build())

/**
 * Responds to the authentication challenge.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.respondToAuthChallenge(crossinline block: RespondToAuthChallengeRequest.Builder.() -> Unit): RespondToAuthChallengeResponse = respondToAuthChallenge(RespondToAuthChallengeRequest.Builder().apply(block).build())

/**
 * Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a token is revoked, you can't use the revoked token to access Amazon Cognito user APIs, or to authorize access to your resource server.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.revokeToken(crossinline block: RevokeTokenRequest.Builder.() -> Unit): RevokeTokenResponse = revokeToken(RevokeTokenRequest.Builder().apply(block).build())

/**
 * Sets up or modifies the detailed activity logging configuration of a user pool.
 */
public suspend inline fun CognitoIdentityProviderClient.setLogDeliveryConfiguration(crossinline block: SetLogDeliveryConfigurationRequest.Builder.() -> Unit): SetLogDeliveryConfigurationResponse = setLogDeliveryConfiguration(SetLogDeliveryConfigurationRequest.Builder().apply(block).build())

/**
 * Configures actions on detected risks. To delete the risk configuration for `UserPoolId` or `ClientId`, pass null values for all four configuration types.
 *
 * To activate Amazon Cognito advanced security features, update the user pool to include the `UserPoolAddOns` key`AdvancedSecurityMode`.
 */
public suspend inline fun CognitoIdentityProviderClient.setRiskConfiguration(crossinline block: SetRiskConfigurationRequest.Builder.() -> Unit): SetRiskConfigurationResponse = setRiskConfiguration(SetRiskConfigurationRequest.Builder().apply(block).build())

/**
 * Sets the user interface (UI) customization information for a user pool's built-in app UI.
 *
 * You can specify app UI customization settings for a single client (with a specific `clientId`) or for all clients (by setting the `clientId` to `ALL`). If you specify `ALL`, the default configuration is used for every client that has no previously set UI customization. If you specify UI customization settings for a particular client, it will no longer return to the `ALL` configuration.
 *
 * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app's pages, and the service will throw an error.
 */
public suspend inline fun CognitoIdentityProviderClient.setUiCustomization(crossinline block: SetUiCustomizationRequest.Builder.() -> Unit): SetUiCustomizationResponse = setUiCustomization(SetUiCustomizationRequest.Builder().apply(block).build())

/**
 * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.setUserMfaPreference(crossinline block: SetUserMfaPreferenceRequest.Builder.() -> Unit): SetUserMfaPreferenceResponse = setUserMfaPreference(SetUserMfaPreferenceRequest.Builder().apply(block).build())

/**
 * Sets the user pool multi-factor authentication (MFA) configuration.
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.setUserPoolMfaConfig(crossinline block: SetUserPoolMfaConfigRequest.Builder.() -> Unit): SetUserPoolMfaConfigResponse = setUserPoolMfaConfig(SetUserPoolMfaConfigRequest.Builder().apply(block).build())

/**
 * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [SetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html) instead.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.setUserSettings(crossinline block: SetUserSettingsRequest.Builder.() -> Unit): SetUserSettingsResponse = setUserSettings(SetUserSettingsRequest.Builder().apply(block).build())

/**
 * Registers the user in the specified user pool and creates a user name, password, and user attributes.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.signUp(crossinline block: SignUpRequest.Builder.() -> Unit): SignUpResponse = signUp(SignUpRequest.Builder().apply(block).build())

/**
 * Starts the user import.
 */
public suspend inline fun CognitoIdentityProviderClient.startUserImportJob(crossinline block: StartUserImportJobRequest.Builder.() -> Unit): StartUserImportJobResponse = startUserImportJob(StartUserImportJobRequest.Builder().apply(block).build())

/**
 * Stops the user import job.
 */
public suspend inline fun CognitoIdentityProviderClient.stopUserImportJob(crossinline block: StopUserImportJobRequest.Builder.() -> Unit): StopUserImportJobResponse = stopUserImportJob(StopUserImportJobRequest.Builder().apply(block).build())

/**
 * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
 *
 * Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an `Environment` tag key to both user pools. The value of this key might be `Test` for one user pool, and `Production` for the other.
 *
 * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag values.
 *
 * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
 */
public suspend inline fun CognitoIdentityProviderClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.
 */
public suspend inline fun CognitoIdentityProviderClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.updateAuthEventFeedback(crossinline block: UpdateAuthEventFeedbackRequest.Builder.() -> Unit): UpdateAuthEventFeedbackResponse = updateAuthEventFeedback(UpdateAuthEventFeedbackRequest.Builder().apply(block).build())

/**
 * Updates the device status.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.updateDeviceStatus(crossinline block: UpdateDeviceStatusRequest.Builder.() -> Unit): UpdateDeviceStatusResponse = updateDeviceStatus(UpdateDeviceStatusRequest.Builder().apply(block).build())

/**
 * Updates the specified group with the specified attributes.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Updates IdP information for a user pool.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.updateIdentityProvider(crossinline block: UpdateIdentityProviderRequest.Builder.() -> Unit): UpdateIdentityProviderResponse = updateIdentityProvider(UpdateIdentityProviderRequest.Builder().apply(block).build())

/**
 * Updates the name and scopes of resource server. All other fields are read-only.
 *
 * If you don't provide a value for an attribute, it is set to the default value.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.updateResourceServer(crossinline block: UpdateResourceServerRequest.Builder.() -> Unit): UpdateResourceServerResponse = updateResourceServer(UpdateResourceServerRequest.Builder().apply(block).build())

/**
 * Allows a user to update a specific attribute (one at a time).
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 *
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 */
public suspend inline fun CognitoIdentityProviderClient.updateUserAttributes(crossinline block: UpdateUserAttributesRequest.Builder.() -> Unit): UpdateUserAttributesResponse = updateUserAttributes(UpdateUserAttributesRequest.Builder().apply(block).build())

/**
 * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
 *
 * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) in the *Amazon Cognito Developer Guide*.
 *
 * Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html).
 *
 * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.updateUserPool(crossinline block: UpdateUserPoolRequest.Builder.() -> Unit): UpdateUserPoolResponse = updateUserPool(UpdateUserPoolRequest.Builder().apply(block).build())

/**
 * Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using [DescribeUserPoolClient](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html).
 *
 * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
 *
 * You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.updateUserPoolClient(crossinline block: UpdateUserPoolClientRequest.Builder.() -> Unit): UpdateUserPoolClientResponse = updateUserPoolClient(UpdateUserPoolClientRequest.Builder().apply(block).build())

/**
 * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
 *
 * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You can't use it to change the domain for a user pool.
 *
 * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.
 *
 * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.
 *
 * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
 *
 * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services Region.
 *
 * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.
 *
 * For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
 *
 * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding IAM permission in a policy.
 *
 * **Learn more**
 * + [Signing Amazon Web Services API Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html)
 * + [Using the Amazon Cognito user pools API and user pool endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html)
 */
public suspend inline fun CognitoIdentityProviderClient.updateUserPoolDomain(crossinline block: UpdateUserPoolDomainRequest.Builder.() -> Unit): UpdateUserPoolDomainResponse = updateUserPoolDomain(UpdateUserPoolDomainRequest.Builder().apply(block).build())

/**
 * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.verifySoftwareToken(crossinline block: VerifySoftwareTokenRequest.Builder.() -> Unit): VerifySoftwareTokenResponse = verifySoftwareToken(VerifySoftwareTokenRequest.Builder().apply(block).build())

/**
 * Verifies the specified user attributes in the user pool.
 *
 *  If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute updates the affected attribute to its pending value. For more information, see [ UserAttributeUpdateSettingsType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html).
 *
 * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation. For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in policies. For more information about authorization models in Amazon Cognito, see [Using the Amazon Cognito native and OIDC APIs](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html).
 */
public suspend inline fun CognitoIdentityProviderClient.verifyUserAttribute(crossinline block: VerifyUserAttributeRequest.Builder.() -> Unit): VerifyUserAttributeResponse = verifyUserAttribute(VerifyUserAttributeRequest.Builder().apply(block).build())
