// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.IdentityDescription
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentitiesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListIdentitiesOperationDeserializer: HttpDeserialize<ListIdentitiesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListIdentitiesResponse {
        if (!response.status.isSuccess()) {
            throwListIdentitiesError(context, response)
        }
        val builder = ListIdentitiesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListIdentitiesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeListIdentitiesOperationBody(builder: ListIdentitiesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Identities"))
    val IDENTITYPOOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityPoolId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITIES_DESCRIPTOR)
        field(IDENTITYPOOLID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITIES_DESCRIPTOR.index -> builder.identities =
                    deserializer.deserializeList(IDENTITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<IdentityDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIdentityDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IDENTITYPOOLID_DESCRIPTOR.index -> builder.identityPoolId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListIdentitiesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        else -> throw CognitoIdentityException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
