// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPrincipalTagAttributeMapOperationDeserializer: HttpDeserialize<GetPrincipalTagAttributeMapResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPrincipalTagAttributeMapResponse {
        if (!response.status.isSuccess()) {
            throwGetPrincipalTagAttributeMapError(context, response)
        }
        val builder = GetPrincipalTagAttributeMapResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPrincipalTagAttributeMapOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetPrincipalTagAttributeMapOperationBody(builder: GetPrincipalTagAttributeMapResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYPOOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityPoolId"))
    val IDENTITYPROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityProviderName"))
    val PRINCIPALTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("PrincipalTags"))
    val USEDEFAULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseDefaults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYPOOLID_DESCRIPTOR)
        field(IDENTITYPROVIDERNAME_DESCRIPTOR)
        field(PRINCIPALTAGS_DESCRIPTOR)
        field(USEDEFAULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYPOOLID_DESCRIPTOR.index -> builder.identityPoolId = deserializeString()
                IDENTITYPROVIDERNAME_DESCRIPTOR.index -> builder.identityProviderName = deserializeString()
                PRINCIPALTAGS_DESCRIPTOR.index -> builder.principalTags =
                    deserializer.deserializeMap(PRINCIPALTAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USEDEFAULTS_DESCRIPTOR.index -> builder.useDefaults = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetPrincipalTagAttributeMapError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        else -> throw CognitoIdentityException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
