// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetOpenIdTokenForDeveloperIdentityOperationDeserializer: HttpDeserialize<GetOpenIdTokenForDeveloperIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetOpenIdTokenForDeveloperIdentityResponse {
        if (!response.status.isSuccess()) {
            throwGetOpenIdTokenForDeveloperIdentityError(context, response)
        }
        val builder = GetOpenIdTokenForDeveloperIdentityResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetOpenIdTokenForDeveloperIdentityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetOpenIdTokenForDeveloperIdentityOperationBody(builder: GetOpenIdTokenForDeveloperIdentityResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityId"))
    val TOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Token"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYID_DESCRIPTOR)
        field(TOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYID_DESCRIPTOR.index -> builder.identityId = deserializeString()
                TOKEN_DESCRIPTOR.index -> builder.token = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetOpenIdTokenForDeveloperIdentityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DeveloperUserAlreadyRegisteredException" -> DeveloperUserAlreadyRegisteredExceptionDeserializer()
        "InternalErrorException" -> InternalErrorExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer()
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        else -> throw CognitoIdentityException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
