// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.GetCredentialsForIdentityResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCredentialsForIdentityOperationDeserializer: HttpDeserialize<GetCredentialsForIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCredentialsForIdentityResponse {
        if (!response.status.isSuccess()) {
            throwGetCredentialsForIdentityError(context, response)
        }
        val builder = GetCredentialsForIdentityResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCredentialsForIdentityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetCredentialsForIdentityOperationBody(builder: GetCredentialsForIdentityResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Credentials"))
    val IDENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREDENTIALS_DESCRIPTOR)
        field(IDENTITYID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeCredentialsDocument(deserializer)
                IDENTITYID_DESCRIPTOR.index -> builder.identityId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetCredentialsForIdentityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ExternalServiceException" -> ExternalServiceExceptionDeserializer()
        "InternalErrorException" -> InternalErrorExceptionDeserializer()
        "InvalidIdentityPoolConfigurationException" -> InvalidIdentityPoolConfigurationExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer()
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        else -> throw CognitoIdentityException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
