// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the SetIdentityPoolRoles action.
 */
class SetIdentityPoolRolesRequest private constructor(builder: BuilderImpl) {
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: String? = builder.identityPoolId
    /**
     * How users for a specific identity provider are to mapped to roles. This is a string
     * to RoleMapping object map. The string identifies the identity provider,
     * for example, "graph.facebook.com" or
     * "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
     * Up to 25 rules can be specified per identity provider.
     */
    val roleMappings: Map<String, RoleMapping>? = builder.roleMappings
    /**
     * The map of roles associated with this pool. For a given role, the key will be either
     * "authenticated" or "unauthenticated" and the value will be the Role ARN.
     */
    val roles: Map<String, String>? = builder.roles

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SetIdentityPoolRolesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityPoolRolesRequest(")
        append("identityPoolId=$identityPoolId,")
        append("roleMappings=$roleMappings,")
        append("roles=$roles)")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityPoolId?.hashCode() ?: 0
        result = 31 * result + (roleMappings?.hashCode() ?: 0)
        result = 31 * result + (roles?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SetIdentityPoolRolesRequest

        if (identityPoolId != other.identityPoolId) return false
        if (roleMappings != other.roleMappings) return false
        if (roles != other.roles) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SetIdentityPoolRolesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SetIdentityPoolRolesRequest
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        fun identityPoolId(identityPoolId: String): FluentBuilder
        /**
         * How users for a specific identity provider are to mapped to roles. This is a string
         * to RoleMapping object map. The string identifies the identity provider,
         * for example, "graph.facebook.com" or
         * "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         * Up to 25 rules can be specified per identity provider.
         */
        fun roleMappings(roleMappings: Map<String, RoleMapping>): FluentBuilder
        /**
         * The map of roles associated with this pool. For a given role, the key will be either
         * "authenticated" or "unauthenticated" and the value will be the Role ARN.
         */
        fun roles(roles: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: String?
        /**
         * How users for a specific identity provider are to mapped to roles. This is a string
         * to RoleMapping object map. The string identifies the identity provider,
         * for example, "graph.facebook.com" or
         * "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         * Up to 25 rules can be specified per identity provider.
         */
        var roleMappings: Map<String, RoleMapping>?
        /**
         * The map of roles associated with this pool. For a given role, the key will be either
         * "authenticated" or "unauthenticated" and the value will be the Role ARN.
         */
        var roles: Map<String, String>?

        fun build(): SetIdentityPoolRolesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var identityPoolId: String? = null
        override var roleMappings: Map<String, RoleMapping>? = null
        override var roles: Map<String, String>? = null

        constructor(x: SetIdentityPoolRolesRequest) : this() {
            this.identityPoolId = x.identityPoolId
            this.roleMappings = x.roleMappings
            this.roles = x.roles
        }

        override fun build(): SetIdentityPoolRolesRequest = SetIdentityPoolRolesRequest(this)
        override fun identityPoolId(identityPoolId: String): FluentBuilder = apply { this.identityPoolId = identityPoolId }
        override fun roleMappings(roleMappings: Map<String, RoleMapping>): FluentBuilder = apply { this.roleMappings = roleMappings }
        override fun roles(roles: Map<String, String>): FluentBuilder = apply { this.roles = roles }
    }
}
