// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * A role mapping.
 */
class RoleMapping private constructor(builder: BuilderImpl) {
    /**
     * If you specify Token or Rules as the Type,
     * AmbiguousRoleResolution is required.
     * Specifies the action to be taken if either no rules match the claim value for the
     * Rules type, or there is no cognito:preferred_role claim and
     * there are multiple cognito:roles matches for the Token
     * type.
     */
    val ambiguousRoleResolution: AmbiguousRoleResolutionType? = builder.ambiguousRoleResolution
    /**
     * The rules to be used for mapping users to roles.
     * If you specify Rules as the role mapping type, RulesConfiguration is
     * required.
     */
    val rulesConfiguration: RulesConfigurationType? = builder.rulesConfiguration
    /**
     * The role mapping type. Token will use cognito:roles and
     * cognito:preferred_role claims from the Cognito identity provider token to
     * map groups to roles. Rules will attempt to match claims from the token to map to a
     * role.
     */
    val type: RoleMappingType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RoleMapping = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RoleMapping(")
        append("ambiguousRoleResolution=$ambiguousRoleResolution,")
        append("rulesConfiguration=$rulesConfiguration,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ambiguousRoleResolution?.hashCode() ?: 0
        result = 31 * result + (rulesConfiguration?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RoleMapping

        if (ambiguousRoleResolution != other.ambiguousRoleResolution) return false
        if (rulesConfiguration != other.rulesConfiguration) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RoleMapping = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RoleMapping
        /**
         * If you specify Token or Rules as the Type,
         * AmbiguousRoleResolution is required.
         * Specifies the action to be taken if either no rules match the claim value for the
         * Rules type, or there is no cognito:preferred_role claim and
         * there are multiple cognito:roles matches for the Token
         * type.
         */
        fun ambiguousRoleResolution(ambiguousRoleResolution: AmbiguousRoleResolutionType): FluentBuilder
        /**
         * The rules to be used for mapping users to roles.
         * If you specify Rules as the role mapping type, RulesConfiguration is
         * required.
         */
        fun rulesConfiguration(rulesConfiguration: RulesConfigurationType): FluentBuilder
        /**
         * The role mapping type. Token will use cognito:roles and
         * cognito:preferred_role claims from the Cognito identity provider token to
         * map groups to roles. Rules will attempt to match claims from the token to map to a
         * role.
         */
        fun type(type: RoleMappingType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If you specify Token or Rules as the Type,
         * AmbiguousRoleResolution is required.
         * Specifies the action to be taken if either no rules match the claim value for the
         * Rules type, or there is no cognito:preferred_role claim and
         * there are multiple cognito:roles matches for the Token
         * type.
         */
        var ambiguousRoleResolution: AmbiguousRoleResolutionType?
        /**
         * The rules to be used for mapping users to roles.
         * If you specify Rules as the role mapping type, RulesConfiguration is
         * required.
         */
        var rulesConfiguration: RulesConfigurationType?
        /**
         * The role mapping type. Token will use cognito:roles and
         * cognito:preferred_role claims from the Cognito identity provider token to
         * map groups to roles. Rules will attempt to match claims from the token to map to a
         * role.
         */
        var type: RoleMappingType?

        fun build(): RoleMapping
        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentity.model.RulesConfigurationType] inside the given [block]
         */
        fun rulesConfiguration(block: RulesConfigurationType.DslBuilder.() -> kotlin.Unit) {
            this.rulesConfiguration = RulesConfigurationType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var ambiguousRoleResolution: AmbiguousRoleResolutionType? = null
        override var rulesConfiguration: RulesConfigurationType? = null
        override var type: RoleMappingType? = null

        constructor(x: RoleMapping) : this() {
            this.ambiguousRoleResolution = x.ambiguousRoleResolution
            this.rulesConfiguration = x.rulesConfiguration
            this.type = x.type
        }

        override fun build(): RoleMapping = RoleMapping(this)
        override fun ambiguousRoleResolution(ambiguousRoleResolution: AmbiguousRoleResolutionType): FluentBuilder = apply { this.ambiguousRoleResolution = ambiguousRoleResolution }
        override fun rulesConfiguration(rulesConfiguration: RulesConfigurationType): FluentBuilder = apply { this.rulesConfiguration = rulesConfiguration }
        override fun type(type: RoleMappingType): FluentBuilder = apply { this.type = type }
    }
}
