// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the MergeDeveloperIdentities action.
 */
class MergeDeveloperIdentitiesRequest private constructor(builder: BuilderImpl) {
    /**
     * User identifier for the destination user. The value should be a
     * DeveloperUserIdentifier.
     */
    val destinationUserIdentifier: String? = builder.destinationUserIdentifier
    /**
     * The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
     * name that you provide while creating an identity pool. This name acts as a placeholder that
     * allows your backend and the Cognito service to communicate about the developer provider.
     * For the DeveloperProviderName, you can use letters as well as period (.),
     * underscore (_), and dash (-).
     */
    val developerProviderName: String? = builder.developerProviderName
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: String? = builder.identityPoolId
    /**
     * User identifier for the source user. The value should be a
     * DeveloperUserIdentifier.
     */
    val sourceUserIdentifier: String? = builder.sourceUserIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MergeDeveloperIdentitiesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MergeDeveloperIdentitiesRequest(")
        append("destinationUserIdentifier=$destinationUserIdentifier,")
        append("developerProviderName=$developerProviderName,")
        append("identityPoolId=$identityPoolId,")
        append("sourceUserIdentifier=$sourceUserIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationUserIdentifier?.hashCode() ?: 0
        result = 31 * result + (developerProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (sourceUserIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MergeDeveloperIdentitiesRequest

        if (destinationUserIdentifier != other.destinationUserIdentifier) return false
        if (developerProviderName != other.developerProviderName) return false
        if (identityPoolId != other.identityPoolId) return false
        if (sourceUserIdentifier != other.sourceUserIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MergeDeveloperIdentitiesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MergeDeveloperIdentitiesRequest
        /**
         * User identifier for the destination user. The value should be a
         * DeveloperUserIdentifier.
         */
        fun destinationUserIdentifier(destinationUserIdentifier: String): FluentBuilder
        /**
         * The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
         * name that you provide while creating an identity pool. This name acts as a placeholder that
         * allows your backend and the Cognito service to communicate about the developer provider.
         * For the DeveloperProviderName, you can use letters as well as period (.),
         * underscore (_), and dash (-).
         */
        fun developerProviderName(developerProviderName: String): FluentBuilder
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        fun identityPoolId(identityPoolId: String): FluentBuilder
        /**
         * User identifier for the source user. The value should be a
         * DeveloperUserIdentifier.
         */
        fun sourceUserIdentifier(sourceUserIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * User identifier for the destination user. The value should be a
         * DeveloperUserIdentifier.
         */
        var destinationUserIdentifier: String?
        /**
         * The "domain" by which Cognito will refer to your users. This is a (pseudo) domain
         * name that you provide while creating an identity pool. This name acts as a placeholder that
         * allows your backend and the Cognito service to communicate about the developer provider.
         * For the DeveloperProviderName, you can use letters as well as period (.),
         * underscore (_), and dash (-).
         */
        var developerProviderName: String?
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: String?
        /**
         * User identifier for the source user. The value should be a
         * DeveloperUserIdentifier.
         */
        var sourceUserIdentifier: String?

        fun build(): MergeDeveloperIdentitiesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationUserIdentifier: String? = null
        override var developerProviderName: String? = null
        override var identityPoolId: String? = null
        override var sourceUserIdentifier: String? = null

        constructor(x: MergeDeveloperIdentitiesRequest) : this() {
            this.destinationUserIdentifier = x.destinationUserIdentifier
            this.developerProviderName = x.developerProviderName
            this.identityPoolId = x.identityPoolId
            this.sourceUserIdentifier = x.sourceUserIdentifier
        }

        override fun build(): MergeDeveloperIdentitiesRequest = MergeDeveloperIdentitiesRequest(this)
        override fun destinationUserIdentifier(destinationUserIdentifier: String): FluentBuilder = apply { this.destinationUserIdentifier = destinationUserIdentifier }
        override fun developerProviderName(developerProviderName: String): FluentBuilder = apply { this.developerProviderName = developerProviderName }
        override fun identityPoolId(identityPoolId: String): FluentBuilder = apply { this.identityPoolId = identityPoolId }
        override fun sourceUserIdentifier(sourceUserIdentifier: String): FluentBuilder = apply { this.sourceUserIdentifier = sourceUserIdentifier }
    }
}
