// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * A rule that maps a claim name, a claim value, and a match type to a role
 * ARN.
 */
class MappingRule private constructor(builder: BuilderImpl) {
    /**
     * The claim name that must be present in the token, for example, "isAdmin" or
     * "paid".
     */
    val claim: String? = builder.claim
    /**
     * The match condition that specifies how closely the claim value in the IdP token must
     * match Value.
     */
    val matchType: MappingRuleMatchType? = builder.matchType
    /**
     * The role ARN.
     */
    val roleArn: String? = builder.roleArn
    /**
     * A brief string that the claim must match, for example, "paid" or "yes".
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MappingRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MappingRule(")
        append("claim=$claim,")
        append("matchType=$matchType,")
        append("roleArn=$roleArn,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = claim?.hashCode() ?: 0
        result = 31 * result + (matchType?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MappingRule

        if (claim != other.claim) return false
        if (matchType != other.matchType) return false
        if (roleArn != other.roleArn) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MappingRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MappingRule
        /**
         * The claim name that must be present in the token, for example, "isAdmin" or
         * "paid".
         */
        fun claim(claim: String): FluentBuilder
        /**
         * The match condition that specifies how closely the claim value in the IdP token must
         * match Value.
         */
        fun matchType(matchType: MappingRuleMatchType): FluentBuilder
        /**
         * The role ARN.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * A brief string that the claim must match, for example, "paid" or "yes".
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The claim name that must be present in the token, for example, "isAdmin" or
         * "paid".
         */
        var claim: String?
        /**
         * The match condition that specifies how closely the claim value in the IdP token must
         * match Value.
         */
        var matchType: MappingRuleMatchType?
        /**
         * The role ARN.
         */
        var roleArn: String?
        /**
         * A brief string that the claim must match, for example, "paid" or "yes".
         */
        var value: String?

        fun build(): MappingRule
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var claim: String? = null
        override var matchType: MappingRuleMatchType? = null
        override var roleArn: String? = null
        override var value: String? = null

        constructor(x: MappingRule) : this() {
            this.claim = x.claim
            this.matchType = x.matchType
            this.roleArn = x.roleArn
            this.value = x.value
        }

        override fun build(): MappingRule = MappingRule(this)
        override fun claim(claim: String): FluentBuilder = apply { this.claim = claim }
        override fun matchType(matchType: MappingRuleMatchType): FluentBuilder = apply { this.matchType = matchType }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
