// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the LookupDeveloperIdentityInput action.
 */
class LookupDeveloperIdentityRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique ID used by your backend authentication process to identify a user.
     * Typically, a developer identity provider would issue many developer user identifiers, in
     * keeping with the number of users.
     */
    val developerUserIdentifier: String? = builder.developerUserIdentifier
    /**
     * A unique identifier in the format REGION:GUID.
     */
    val identityId: String? = builder.identityId
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: String? = builder.identityPoolId
    /**
     * The maximum number of identities to return.
     */
    val maxResults: Int = builder.maxResults
    /**
     * A pagination token. The first call you make will have NextToken set to
     * null. After that the service will return NextToken values as needed. For
     * example, let's say you make a request with MaxResults set to 10, and there are
     * 20 matches in the database. The service will return a pagination token as a part of the
     * response. This token can be used to call the API again and get results starting from the
     * 11th match.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LookupDeveloperIdentityRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LookupDeveloperIdentityRequest(")
        append("developerUserIdentifier=$developerUserIdentifier,")
        append("identityId=$identityId,")
        append("identityPoolId=$identityPoolId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = developerUserIdentifier?.hashCode() ?: 0
        result = 31 * result + (identityId?.hashCode() ?: 0)
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LookupDeveloperIdentityRequest

        if (developerUserIdentifier != other.developerUserIdentifier) return false
        if (identityId != other.identityId) return false
        if (identityPoolId != other.identityPoolId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LookupDeveloperIdentityRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LookupDeveloperIdentityRequest
        /**
         * A unique ID used by your backend authentication process to identify a user.
         * Typically, a developer identity provider would issue many developer user identifiers, in
         * keeping with the number of users.
         */
        fun developerUserIdentifier(developerUserIdentifier: String): FluentBuilder
        /**
         * A unique identifier in the format REGION:GUID.
         */
        fun identityId(identityId: String): FluentBuilder
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        fun identityPoolId(identityPoolId: String): FluentBuilder
        /**
         * The maximum number of identities to return.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A pagination token. The first call you make will have NextToken set to
         * null. After that the service will return NextToken values as needed. For
         * example, let's say you make a request with MaxResults set to 10, and there are
         * 20 matches in the database. The service will return a pagination token as a part of the
         * response. This token can be used to call the API again and get results starting from the
         * 11th match.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique ID used by your backend authentication process to identify a user.
         * Typically, a developer identity provider would issue many developer user identifiers, in
         * keeping with the number of users.
         */
        var developerUserIdentifier: String?
        /**
         * A unique identifier in the format REGION:GUID.
         */
        var identityId: String?
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: String?
        /**
         * The maximum number of identities to return.
         */
        var maxResults: Int
        /**
         * A pagination token. The first call you make will have NextToken set to
         * null. After that the service will return NextToken values as needed. For
         * example, let's say you make a request with MaxResults set to 10, and there are
         * 20 matches in the database. The service will return a pagination token as a part of the
         * response. This token can be used to call the API again and get results starting from the
         * 11th match.
         */
        var nextToken: String?

        fun build(): LookupDeveloperIdentityRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var developerUserIdentifier: String? = null
        override var identityId: String? = null
        override var identityPoolId: String? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null

        constructor(x: LookupDeveloperIdentityRequest) : this() {
            this.developerUserIdentifier = x.developerUserIdentifier
            this.identityId = x.identityId
            this.identityPoolId = x.identityPoolId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): LookupDeveloperIdentityRequest = LookupDeveloperIdentityRequest(this)
        override fun developerUserIdentifier(developerUserIdentifier: String): FluentBuilder = apply { this.developerUserIdentifier = developerUserIdentifier }
        override fun identityId(identityId: String): FluentBuilder = apply { this.identityId = identityId }
        override fun identityPoolId(identityPoolId: String): FluentBuilder = apply { this.identityPoolId = identityPoolId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
