// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the ListIdentities action.
 */
class ListIdentitiesRequest private constructor(builder: BuilderImpl) {
    /**
     * An optional boolean parameter that allows you to hide disabled identities. If
     * omitted, the ListIdentities API will include disabled identities in the response.
     */
    val hideDisabled: Boolean = builder.hideDisabled
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: String? = builder.identityPoolId
    /**
     * The maximum number of identities to return.
     */
    val maxResults: Int = builder.maxResults
    /**
     * A pagination token.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListIdentitiesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListIdentitiesRequest(")
        append("hideDisabled=$hideDisabled,")
        append("identityPoolId=$identityPoolId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hideDisabled.hashCode()
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListIdentitiesRequest

        if (hideDisabled != other.hideDisabled) return false
        if (identityPoolId != other.identityPoolId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListIdentitiesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListIdentitiesRequest
        /**
         * An optional boolean parameter that allows you to hide disabled identities. If
         * omitted, the ListIdentities API will include disabled identities in the response.
         */
        fun hideDisabled(hideDisabled: Boolean): FluentBuilder
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        fun identityPoolId(identityPoolId: String): FluentBuilder
        /**
         * The maximum number of identities to return.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A pagination token.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An optional boolean parameter that allows you to hide disabled identities. If
         * omitted, the ListIdentities API will include disabled identities in the response.
         */
        var hideDisabled: Boolean
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: String?
        /**
         * The maximum number of identities to return.
         */
        var maxResults: Int
        /**
         * A pagination token.
         */
        var nextToken: String?

        fun build(): ListIdentitiesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var hideDisabled: Boolean = false
        override var identityPoolId: String? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null

        constructor(x: ListIdentitiesRequest) : this() {
            this.hideDisabled = x.hideDisabled
            this.identityPoolId = x.identityPoolId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListIdentitiesRequest = ListIdentitiesRequest(this)
        override fun hideDisabled(hideDisabled: Boolean): FluentBuilder = apply { this.hideDisabled = hideDisabled }
        override fun identityPoolId(identityPoolId: String): FluentBuilder = apply { this.identityPoolId = identityPoolId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
