// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the GetOpenIdTokenForDeveloperIdentity action.
 */
class GetOpenIdTokenForDeveloperIdentityRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique identifier in the format REGION:GUID.
     */
    val identityId: String? = builder.identityId
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: String? = builder.identityPoolId
    /**
     * A set of optional name-value pairs that map provider names to provider tokens. Each
     * name-value pair represents a user from a public provider or developer provider. If the user
     * is from a developer provider, the name-value pair will follow the syntax
     * "developer_provider_name": "developer_user_identifier". The developer
     * provider is the "domain" by which Cognito will refer to your users; you provided this
     * domain while creating/updating the identity pool. The developer user identifier is an
     * identifier from your backend that uniquely identifies a user. When you create an identity
     * pool, you can specify the supported logins.
     */
    val logins: Map<String, String>? = builder.logins
    /**
     * Use this operation to configure attribute mappings for custom providers.
     */
    val principalTags: Map<String, String>? = builder.principalTags
    /**
     * The expiration time of the token, in seconds. You can specify a custom expiration
     * time for the token so that you can cache it. If you don't provide an expiration time, the
     * token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
     * credentials, which are valid for a maximum of one hour. The maximum token duration you can
     * set is 24 hours. You should take care in setting the expiration time for a token, as there
     * are significant security implications: an attacker could use a leaked token to access your
     * AWS resources for the token's duration.
     * Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.
     */
    val tokenDuration: Long? = builder.tokenDuration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetOpenIdTokenForDeveloperIdentityRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetOpenIdTokenForDeveloperIdentityRequest(")
        append("identityId=$identityId,")
        append("identityPoolId=$identityPoolId,")
        append("logins=$logins,")
        append("principalTags=$principalTags,")
        append("tokenDuration=$tokenDuration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityId?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (logins?.hashCode() ?: 0)
        result = 31 * result + (principalTags?.hashCode() ?: 0)
        result = 31 * result + (tokenDuration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetOpenIdTokenForDeveloperIdentityRequest

        if (identityId != other.identityId) return false
        if (identityPoolId != other.identityPoolId) return false
        if (logins != other.logins) return false
        if (principalTags != other.principalTags) return false
        if (tokenDuration != other.tokenDuration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetOpenIdTokenForDeveloperIdentityRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetOpenIdTokenForDeveloperIdentityRequest
        /**
         * A unique identifier in the format REGION:GUID.
         */
        fun identityId(identityId: String): FluentBuilder
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        fun identityPoolId(identityPoolId: String): FluentBuilder
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. Each
         * name-value pair represents a user from a public provider or developer provider. If the user
         * is from a developer provider, the name-value pair will follow the syntax
         * "developer_provider_name": "developer_user_identifier". The developer
         * provider is the "domain" by which Cognito will refer to your users; you provided this
         * domain while creating/updating the identity pool. The developer user identifier is an
         * identifier from your backend that uniquely identifies a user. When you create an identity
         * pool, you can specify the supported logins.
         */
        fun logins(logins: Map<String, String>): FluentBuilder
        /**
         * Use this operation to configure attribute mappings for custom providers.
         */
        fun principalTags(principalTags: Map<String, String>): FluentBuilder
        /**
         * The expiration time of the token, in seconds. You can specify a custom expiration
         * time for the token so that you can cache it. If you don't provide an expiration time, the
         * token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
         * credentials, which are valid for a maximum of one hour. The maximum token duration you can
         * set is 24 hours. You should take care in setting the expiration time for a token, as there
         * are significant security implications: an attacker could use a leaked token to access your
         * AWS resources for the token's duration.
         * Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.
         */
        fun tokenDuration(tokenDuration: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique identifier in the format REGION:GUID.
         */
        var identityId: String?
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: String?
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. Each
         * name-value pair represents a user from a public provider or developer provider. If the user
         * is from a developer provider, the name-value pair will follow the syntax
         * "developer_provider_name": "developer_user_identifier". The developer
         * provider is the "domain" by which Cognito will refer to your users; you provided this
         * domain while creating/updating the identity pool. The developer user identifier is an
         * identifier from your backend that uniquely identifies a user. When you create an identity
         * pool, you can specify the supported logins.
         */
        var logins: Map<String, String>?
        /**
         * Use this operation to configure attribute mappings for custom providers.
         */
        var principalTags: Map<String, String>?
        /**
         * The expiration time of the token, in seconds. You can specify a custom expiration
         * time for the token so that you can cache it. If you don't provide an expiration time, the
         * token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS
         * credentials, which are valid for a maximum of one hour. The maximum token duration you can
         * set is 24 hours. You should take care in setting the expiration time for a token, as there
         * are significant security implications: an attacker could use a leaked token to access your
         * AWS resources for the token's duration.
         * Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.
         */
        var tokenDuration: Long?

        fun build(): GetOpenIdTokenForDeveloperIdentityRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var identityId: String? = null
        override var identityPoolId: String? = null
        override var logins: Map<String, String>? = null
        override var principalTags: Map<String, String>? = null
        override var tokenDuration: Long? = null

        constructor(x: GetOpenIdTokenForDeveloperIdentityRequest) : this() {
            this.identityId = x.identityId
            this.identityPoolId = x.identityPoolId
            this.logins = x.logins
            this.principalTags = x.principalTags
            this.tokenDuration = x.tokenDuration
        }

        override fun build(): GetOpenIdTokenForDeveloperIdentityRequest = GetOpenIdTokenForDeveloperIdentityRequest(this)
        override fun identityId(identityId: String): FluentBuilder = apply { this.identityId = identityId }
        override fun identityPoolId(identityPoolId: String): FluentBuilder = apply { this.identityPoolId = identityPoolId }
        override fun logins(logins: Map<String, String>): FluentBuilder = apply { this.logins = logins }
        override fun principalTags(principalTags: Map<String, String>): FluentBuilder = apply { this.principalTags = principalTags }
        override fun tokenDuration(tokenDuration: Long): FluentBuilder = apply { this.tokenDuration = tokenDuration }
    }
}
