// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the GetId action.
 */
class GetIdRequest private constructor(builder: BuilderImpl) {
    /**
     * A standard AWS account ID (9+ digits).
     */
    val accountId: String? = builder.accountId
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: String? = builder.identityPoolId
    /**
     * A set of optional name-value pairs that map provider names to provider tokens. The
     * available provider names for Logins are as follows:
     * Facebook: graph.facebook.com
     * Amazon Cognito user pool:
     * cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>,
     * for example, cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
     * Google: accounts.google.com
     * Amazon: www.amazon.com
     * Twitter: api.twitter.com
     * Digits: www.digits.com
     */
    val logins: Map<String, String>? = builder.logins

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetIdRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetIdRequest(")
        append("accountId=$accountId,")
        append("identityPoolId=$identityPoolId,")
        append("logins=$logins)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (logins?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetIdRequest

        if (accountId != other.accountId) return false
        if (identityPoolId != other.identityPoolId) return false
        if (logins != other.logins) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetIdRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetIdRequest
        /**
         * A standard AWS account ID (9+ digits).
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        fun identityPoolId(identityPoolId: String): FluentBuilder
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. The
         * available provider names for Logins are as follows:
         * Facebook: graph.facebook.com
         * Amazon Cognito user pool:
         * cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>,
         * for example, cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
         * Google: accounts.google.com
         * Amazon: www.amazon.com
         * Twitter: api.twitter.com
         * Digits: www.digits.com
         */
        fun logins(logins: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A standard AWS account ID (9+ digits).
         */
        var accountId: String?
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: String?
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. The
         * available provider names for Logins are as follows:
         * Facebook: graph.facebook.com
         * Amazon Cognito user pool:
         * cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>,
         * for example, cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
         * Google: accounts.google.com
         * Amazon: www.amazon.com
         * Twitter: api.twitter.com
         * Digits: www.digits.com
         */
        var logins: Map<String, String>?

        fun build(): GetIdRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var identityPoolId: String? = null
        override var logins: Map<String, String>? = null

        constructor(x: GetIdRequest) : this() {
            this.accountId = x.accountId
            this.identityPoolId = x.identityPoolId
            this.logins = x.logins
        }

        override fun build(): GetIdRequest = GetIdRequest(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun identityPoolId(identityPoolId: String): FluentBuilder = apply { this.identityPoolId = identityPoolId }
        override fun logins(logins: Map<String, String>): FluentBuilder = apply { this.logins = logins }
    }
}
