// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the GetCredentialsForIdentity action.
 */
class GetCredentialsForIdentityRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
     * received in the token from the identity provider. For example, a SAML-based identity
     * provider. This parameter is optional for identity providers that do not support role
     * customization.
     */
    val customRoleArn: String? = builder.customRoleArn
    /**
     * A unique identifier in the format REGION:GUID.
     */
    val identityId: String? = builder.identityId
    /**
     * A set of optional name-value pairs that map provider names to provider tokens. The
     * name-value pair will follow the syntax "provider_name":
     * "provider_user_identifier".
     * Logins should not be specified when trying to get credentials for an unauthenticated
     * identity.
     * The Logins parameter is required when using identities associated with external
     * identity providers such as Facebook. For examples of Logins maps, see the code
     * examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers section of the Amazon Cognito Developer
     * Guide.
     */
    val logins: Map<String, String>? = builder.logins

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetCredentialsForIdentityRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetCredentialsForIdentityRequest(")
        append("customRoleArn=$customRoleArn,")
        append("identityId=$identityId,")
        append("logins=$logins)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customRoleArn?.hashCode() ?: 0
        result = 31 * result + (identityId?.hashCode() ?: 0)
        result = 31 * result + (logins?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetCredentialsForIdentityRequest

        if (customRoleArn != other.customRoleArn) return false
        if (identityId != other.identityId) return false
        if (logins != other.logins) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetCredentialsForIdentityRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetCredentialsForIdentityRequest
        /**
         * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
         * received in the token from the identity provider. For example, a SAML-based identity
         * provider. This parameter is optional for identity providers that do not support role
         * customization.
         */
        fun customRoleArn(customRoleArn: String): FluentBuilder
        /**
         * A unique identifier in the format REGION:GUID.
         */
        fun identityId(identityId: String): FluentBuilder
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. The
         * name-value pair will follow the syntax "provider_name":
         * "provider_user_identifier".
         * Logins should not be specified when trying to get credentials for an unauthenticated
         * identity.
         * The Logins parameter is required when using identities associated with external
         * identity providers such as Facebook. For examples of Logins maps, see the code
         * examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers section of the Amazon Cognito Developer
         * Guide.
         */
        fun logins(logins: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were
         * received in the token from the identity provider. For example, a SAML-based identity
         * provider. This parameter is optional for identity providers that do not support role
         * customization.
         */
        var customRoleArn: String?
        /**
         * A unique identifier in the format REGION:GUID.
         */
        var identityId: String?
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. The
         * name-value pair will follow the syntax "provider_name":
         * "provider_user_identifier".
         * Logins should not be specified when trying to get credentials for an unauthenticated
         * identity.
         * The Logins parameter is required when using identities associated with external
         * identity providers such as Facebook. For examples of Logins maps, see the code
         * examples in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">External Identity Providers section of the Amazon Cognito Developer
         * Guide.
         */
        var logins: Map<String, String>?

        fun build(): GetCredentialsForIdentityRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customRoleArn: String? = null
        override var identityId: String? = null
        override var logins: Map<String, String>? = null

        constructor(x: GetCredentialsForIdentityRequest) : this() {
            this.customRoleArn = x.customRoleArn
            this.identityId = x.identityId
            this.logins = x.logins
        }

        override fun build(): GetCredentialsForIdentityRequest = GetCredentialsForIdentityRequest(this)
        override fun customRoleArn(customRoleArn: String): FluentBuilder = apply { this.customRoleArn = customRoleArn }
        override fun identityId(identityId: String): FluentBuilder = apply { this.identityId = identityId }
        override fun logins(logins: Map<String, String>): FluentBuilder = apply { this.logins = logins }
    }
}
