// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * An object representing an Amazon Cognito identity pool.
 */
class DescribeIdentityPoolResponse private constructor(builder: BuilderImpl) {
    /**
     * Enables or disables the Basic (Classic) authentication flow. For more information, see
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide.
     */
    val allowClassicFlow: Boolean? = builder.allowClassicFlow
    /**
     * TRUE if the identity pool supports unauthenticated logins.
     */
    val allowUnauthenticatedIdentities: Boolean = builder.allowUnauthenticatedIdentities
    /**
     * A list representing an Amazon Cognito user pool and its client ID.
     */
    val cognitoIdentityProviders: List<CognitoIdentityProvider>? = builder.cognitoIdentityProviders
    /**
     * The "domain" by which Cognito will refer to your users.
     */
    val developerProviderName: String? = builder.developerProviderName
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: String? = builder.identityPoolId
    /**
     * A string that you provide.
     */
    val identityPoolName: String? = builder.identityPoolName
    /**
     * The tags that are assigned to the identity pool. A tag is a label that you can apply to
     * identity pools to categorize and manage them in different ways, such as by purpose, owner,
     * environment, or other criteria.
     */
    val identityPoolTags: Map<String, String>? = builder.identityPoolTags
    /**
     * The ARNs of the OpenID Connect providers.
     */
    val openIdConnectProviderArNs: List<String>? = builder.openIdConnectProviderArNs
    /**
     * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
     * pool.
     */
    val samlProviderArNs: List<String>? = builder.samlProviderArNs
    /**
     * Optional key:value pairs mapping provider names to provider app IDs.
     */
    val supportedLoginProviders: Map<String, String>? = builder.supportedLoginProviders

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeIdentityPoolResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeIdentityPoolResponse(")
        append("allowClassicFlow=$allowClassicFlow,")
        append("allowUnauthenticatedIdentities=$allowUnauthenticatedIdentities,")
        append("cognitoIdentityProviders=$cognitoIdentityProviders,")
        append("developerProviderName=$developerProviderName,")
        append("identityPoolId=$identityPoolId,")
        append("identityPoolName=$identityPoolName,")
        append("identityPoolTags=$identityPoolTags,")
        append("openIdConnectProviderArNs=$openIdConnectProviderArNs,")
        append("samlProviderArNs=$samlProviderArNs,")
        append("supportedLoginProviders=$supportedLoginProviders)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowClassicFlow?.hashCode() ?: 0
        result = 31 * result + (allowUnauthenticatedIdentities.hashCode())
        result = 31 * result + (cognitoIdentityProviders?.hashCode() ?: 0)
        result = 31 * result + (developerProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (identityPoolName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolTags?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (samlProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (supportedLoginProviders?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeIdentityPoolResponse

        if (allowClassicFlow != other.allowClassicFlow) return false
        if (allowUnauthenticatedIdentities != other.allowUnauthenticatedIdentities) return false
        if (cognitoIdentityProviders != other.cognitoIdentityProviders) return false
        if (developerProviderName != other.developerProviderName) return false
        if (identityPoolId != other.identityPoolId) return false
        if (identityPoolName != other.identityPoolName) return false
        if (identityPoolTags != other.identityPoolTags) return false
        if (openIdConnectProviderArNs != other.openIdConnectProviderArNs) return false
        if (samlProviderArNs != other.samlProviderArNs) return false
        if (supportedLoginProviders != other.supportedLoginProviders) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeIdentityPoolResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeIdentityPoolResponse
        /**
         * Enables or disables the Basic (Classic) authentication flow. For more information, see
         * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide.
         */
        fun allowClassicFlow(allowClassicFlow: Boolean): FluentBuilder
        /**
         * TRUE if the identity pool supports unauthenticated logins.
         */
        fun allowUnauthenticatedIdentities(allowUnauthenticatedIdentities: Boolean): FluentBuilder
        /**
         * A list representing an Amazon Cognito user pool and its client ID.
         */
        fun cognitoIdentityProviders(cognitoIdentityProviders: List<CognitoIdentityProvider>): FluentBuilder
        /**
         * The "domain" by which Cognito will refer to your users.
         */
        fun developerProviderName(developerProviderName: String): FluentBuilder
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        fun identityPoolId(identityPoolId: String): FluentBuilder
        /**
         * A string that you provide.
         */
        fun identityPoolName(identityPoolName: String): FluentBuilder
        /**
         * The tags that are assigned to the identity pool. A tag is a label that you can apply to
         * identity pools to categorize and manage them in different ways, such as by purpose, owner,
         * environment, or other criteria.
         */
        fun identityPoolTags(identityPoolTags: Map<String, String>): FluentBuilder
        /**
         * The ARNs of the OpenID Connect providers.
         */
        fun openIdConnectProviderArNs(openIdConnectProviderArNs: List<String>): FluentBuilder
        /**
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
         * pool.
         */
        fun samlProviderArNs(samlProviderArNs: List<String>): FluentBuilder
        /**
         * Optional key:value pairs mapping provider names to provider app IDs.
         */
        fun supportedLoginProviders(supportedLoginProviders: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Enables or disables the Basic (Classic) authentication flow. For more information, see
         * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide.
         */
        var allowClassicFlow: Boolean?
        /**
         * TRUE if the identity pool supports unauthenticated logins.
         */
        var allowUnauthenticatedIdentities: Boolean
        /**
         * A list representing an Amazon Cognito user pool and its client ID.
         */
        var cognitoIdentityProviders: List<CognitoIdentityProvider>?
        /**
         * The "domain" by which Cognito will refer to your users.
         */
        var developerProviderName: String?
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: String?
        /**
         * A string that you provide.
         */
        var identityPoolName: String?
        /**
         * The tags that are assigned to the identity pool. A tag is a label that you can apply to
         * identity pools to categorize and manage them in different ways, such as by purpose, owner,
         * environment, or other criteria.
         */
        var identityPoolTags: Map<String, String>?
        /**
         * The ARNs of the OpenID Connect providers.
         */
        var openIdConnectProviderArNs: List<String>?
        /**
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
         * pool.
         */
        var samlProviderArNs: List<String>?
        /**
         * Optional key:value pairs mapping provider names to provider app IDs.
         */
        var supportedLoginProviders: Map<String, String>?

        fun build(): DescribeIdentityPoolResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowClassicFlow: Boolean? = null
        override var allowUnauthenticatedIdentities: Boolean = false
        override var cognitoIdentityProviders: List<CognitoIdentityProvider>? = null
        override var developerProviderName: String? = null
        override var identityPoolId: String? = null
        override var identityPoolName: String? = null
        override var identityPoolTags: Map<String, String>? = null
        override var openIdConnectProviderArNs: List<String>? = null
        override var samlProviderArNs: List<String>? = null
        override var supportedLoginProviders: Map<String, String>? = null

        constructor(x: DescribeIdentityPoolResponse) : this() {
            this.allowClassicFlow = x.allowClassicFlow
            this.allowUnauthenticatedIdentities = x.allowUnauthenticatedIdentities
            this.cognitoIdentityProviders = x.cognitoIdentityProviders
            this.developerProviderName = x.developerProviderName
            this.identityPoolId = x.identityPoolId
            this.identityPoolName = x.identityPoolName
            this.identityPoolTags = x.identityPoolTags
            this.openIdConnectProviderArNs = x.openIdConnectProviderArNs
            this.samlProviderArNs = x.samlProviderArNs
            this.supportedLoginProviders = x.supportedLoginProviders
        }

        override fun build(): DescribeIdentityPoolResponse = DescribeIdentityPoolResponse(this)
        override fun allowClassicFlow(allowClassicFlow: Boolean): FluentBuilder = apply { this.allowClassicFlow = allowClassicFlow }
        override fun allowUnauthenticatedIdentities(allowUnauthenticatedIdentities: Boolean): FluentBuilder = apply { this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities }
        override fun cognitoIdentityProviders(cognitoIdentityProviders: List<CognitoIdentityProvider>): FluentBuilder = apply { this.cognitoIdentityProviders = cognitoIdentityProviders }
        override fun developerProviderName(developerProviderName: String): FluentBuilder = apply { this.developerProviderName = developerProviderName }
        override fun identityPoolId(identityPoolId: String): FluentBuilder = apply { this.identityPoolId = identityPoolId }
        override fun identityPoolName(identityPoolName: String): FluentBuilder = apply { this.identityPoolName = identityPoolName }
        override fun identityPoolTags(identityPoolTags: Map<String, String>): FluentBuilder = apply { this.identityPoolTags = identityPoolTags }
        override fun openIdConnectProviderArNs(openIdConnectProviderArNs: List<String>): FluentBuilder = apply { this.openIdConnectProviderArNs = openIdConnectProviderArNs }
        override fun samlProviderArNs(samlProviderArNs: List<String>): FluentBuilder = apply { this.samlProviderArNs = samlProviderArNs }
        override fun supportedLoginProviders(supportedLoginProviders: Map<String, String>): FluentBuilder = apply { this.supportedLoginProviders = supportedLoginProviders }
    }
}
