// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the CreateIdentityPool action.
 */
class CreateIdentityPoolRequest private constructor(builder: BuilderImpl) {
    /**
     * Enables or disables the Basic (Classic) authentication flow. For more information, see
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide.
     */
    val allowClassicFlow: Boolean? = builder.allowClassicFlow
    /**
     * TRUE if the identity pool supports unauthenticated logins.
     */
    val allowUnauthenticatedIdentities: Boolean = builder.allowUnauthenticatedIdentities
    /**
     * An array of Amazon Cognito user pools and their client IDs.
     */
    val cognitoIdentityProviders: List<CognitoIdentityProvider>? = builder.cognitoIdentityProviders
    /**
     * The "domain" by which Cognito will refer to your users. This name acts as a
     * placeholder that allows your backend and the Cognito service to communicate about the
     * developer provider. For the DeveloperProviderName, you can use letters as well
     * as period (.), underscore (_), and dash
     * (-).
     * Once you have set a developer provider name, you cannot change it. Please take care
     * in setting this parameter.
     */
    val developerProviderName: String? = builder.developerProviderName
    /**
     * A string that you provide.
     */
    val identityPoolName: String? = builder.identityPoolName
    /**
     * Tags to assign to the identity pool. A tag is a label that you can apply to identity
     * pools to categorize and manage them in different ways, such as by purpose, owner,
     * environment, or other criteria.
     */
    val identityPoolTags: Map<String, String>? = builder.identityPoolTags
    /**
     * The Amazon Resource Names (ARN) of the OpenID Connect providers.
     */
    val openIdConnectProviderArNs: List<String>? = builder.openIdConnectProviderArNs
    /**
     * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
     * pool.
     */
    val samlProviderArNs: List<String>? = builder.samlProviderArNs
    /**
     * Optional key:value pairs mapping provider names to provider app IDs.
     */
    val supportedLoginProviders: Map<String, String>? = builder.supportedLoginProviders

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateIdentityPoolRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIdentityPoolRequest(")
        append("allowClassicFlow=$allowClassicFlow,")
        append("allowUnauthenticatedIdentities=$allowUnauthenticatedIdentities,")
        append("cognitoIdentityProviders=$cognitoIdentityProviders,")
        append("developerProviderName=$developerProviderName,")
        append("identityPoolName=$identityPoolName,")
        append("identityPoolTags=$identityPoolTags,")
        append("openIdConnectProviderArNs=$openIdConnectProviderArNs,")
        append("samlProviderArNs=$samlProviderArNs,")
        append("supportedLoginProviders=$supportedLoginProviders)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowClassicFlow?.hashCode() ?: 0
        result = 31 * result + (allowUnauthenticatedIdentities.hashCode())
        result = 31 * result + (cognitoIdentityProviders?.hashCode() ?: 0)
        result = 31 * result + (developerProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolTags?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (samlProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (supportedLoginProviders?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateIdentityPoolRequest

        if (allowClassicFlow != other.allowClassicFlow) return false
        if (allowUnauthenticatedIdentities != other.allowUnauthenticatedIdentities) return false
        if (cognitoIdentityProviders != other.cognitoIdentityProviders) return false
        if (developerProviderName != other.developerProviderName) return false
        if (identityPoolName != other.identityPoolName) return false
        if (identityPoolTags != other.identityPoolTags) return false
        if (openIdConnectProviderArNs != other.openIdConnectProviderArNs) return false
        if (samlProviderArNs != other.samlProviderArNs) return false
        if (supportedLoginProviders != other.supportedLoginProviders) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateIdentityPoolRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateIdentityPoolRequest
        /**
         * Enables or disables the Basic (Classic) authentication flow. For more information, see
         * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide.
         */
        fun allowClassicFlow(allowClassicFlow: Boolean): FluentBuilder
        /**
         * TRUE if the identity pool supports unauthenticated logins.
         */
        fun allowUnauthenticatedIdentities(allowUnauthenticatedIdentities: Boolean): FluentBuilder
        /**
         * An array of Amazon Cognito user pools and their client IDs.
         */
        fun cognitoIdentityProviders(cognitoIdentityProviders: List<CognitoIdentityProvider>): FluentBuilder
        /**
         * The "domain" by which Cognito will refer to your users. This name acts as a
         * placeholder that allows your backend and the Cognito service to communicate about the
         * developer provider. For the DeveloperProviderName, you can use letters as well
         * as period (.), underscore (_), and dash
         * (-).
         * Once you have set a developer provider name, you cannot change it. Please take care
         * in setting this parameter.
         */
        fun developerProviderName(developerProviderName: String): FluentBuilder
        /**
         * A string that you provide.
         */
        fun identityPoolName(identityPoolName: String): FluentBuilder
        /**
         * Tags to assign to the identity pool. A tag is a label that you can apply to identity
         * pools to categorize and manage them in different ways, such as by purpose, owner,
         * environment, or other criteria.
         */
        fun identityPoolTags(identityPoolTags: Map<String, String>): FluentBuilder
        /**
         * The Amazon Resource Names (ARN) of the OpenID Connect providers.
         */
        fun openIdConnectProviderArNs(openIdConnectProviderArNs: List<String>): FluentBuilder
        /**
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
         * pool.
         */
        fun samlProviderArNs(samlProviderArNs: List<String>): FluentBuilder
        /**
         * Optional key:value pairs mapping provider names to provider app IDs.
         */
        fun supportedLoginProviders(supportedLoginProviders: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Enables or disables the Basic (Classic) authentication flow. For more information, see
         * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide.
         */
        var allowClassicFlow: Boolean?
        /**
         * TRUE if the identity pool supports unauthenticated logins.
         */
        var allowUnauthenticatedIdentities: Boolean
        /**
         * An array of Amazon Cognito user pools and their client IDs.
         */
        var cognitoIdentityProviders: List<CognitoIdentityProvider>?
        /**
         * The "domain" by which Cognito will refer to your users. This name acts as a
         * placeholder that allows your backend and the Cognito service to communicate about the
         * developer provider. For the DeveloperProviderName, you can use letters as well
         * as period (.), underscore (_), and dash
         * (-).
         * Once you have set a developer provider name, you cannot change it. Please take care
         * in setting this parameter.
         */
        var developerProviderName: String?
        /**
         * A string that you provide.
         */
        var identityPoolName: String?
        /**
         * Tags to assign to the identity pool. A tag is a label that you can apply to identity
         * pools to categorize and manage them in different ways, such as by purpose, owner,
         * environment, or other criteria.
         */
        var identityPoolTags: Map<String, String>?
        /**
         * The Amazon Resource Names (ARN) of the OpenID Connect providers.
         */
        var openIdConnectProviderArNs: List<String>?
        /**
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
         * pool.
         */
        var samlProviderArNs: List<String>?
        /**
         * Optional key:value pairs mapping provider names to provider app IDs.
         */
        var supportedLoginProviders: Map<String, String>?

        fun build(): CreateIdentityPoolRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowClassicFlow: Boolean? = null
        override var allowUnauthenticatedIdentities: Boolean = false
        override var cognitoIdentityProviders: List<CognitoIdentityProvider>? = null
        override var developerProviderName: String? = null
        override var identityPoolName: String? = null
        override var identityPoolTags: Map<String, String>? = null
        override var openIdConnectProviderArNs: List<String>? = null
        override var samlProviderArNs: List<String>? = null
        override var supportedLoginProviders: Map<String, String>? = null

        constructor(x: CreateIdentityPoolRequest) : this() {
            this.allowClassicFlow = x.allowClassicFlow
            this.allowUnauthenticatedIdentities = x.allowUnauthenticatedIdentities
            this.cognitoIdentityProviders = x.cognitoIdentityProviders
            this.developerProviderName = x.developerProviderName
            this.identityPoolName = x.identityPoolName
            this.identityPoolTags = x.identityPoolTags
            this.openIdConnectProviderArNs = x.openIdConnectProviderArNs
            this.samlProviderArNs = x.samlProviderArNs
            this.supportedLoginProviders = x.supportedLoginProviders
        }

        override fun build(): CreateIdentityPoolRequest = CreateIdentityPoolRequest(this)
        override fun allowClassicFlow(allowClassicFlow: Boolean): FluentBuilder = apply { this.allowClassicFlow = allowClassicFlow }
        override fun allowUnauthenticatedIdentities(allowUnauthenticatedIdentities: Boolean): FluentBuilder = apply { this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities }
        override fun cognitoIdentityProviders(cognitoIdentityProviders: List<CognitoIdentityProvider>): FluentBuilder = apply { this.cognitoIdentityProviders = cognitoIdentityProviders }
        override fun developerProviderName(developerProviderName: String): FluentBuilder = apply { this.developerProviderName = developerProviderName }
        override fun identityPoolName(identityPoolName: String): FluentBuilder = apply { this.identityPoolName = identityPoolName }
        override fun identityPoolTags(identityPoolTags: Map<String, String>): FluentBuilder = apply { this.identityPoolTags = identityPoolTags }
        override fun openIdConnectProviderArNs(openIdConnectProviderArNs: List<String>): FluentBuilder = apply { this.openIdConnectProviderArNs = openIdConnectProviderArNs }
        override fun samlProviderArNs(samlProviderArNs: List<String>): FluentBuilder = apply { this.samlProviderArNs = samlProviderArNs }
        override fun supportedLoginProviders(supportedLoginProviders: Map<String, String>): FluentBuilder = apply { this.supportedLoginProviders = supportedLoginProviders }
    }
}
