// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * A provider representing an Amazon Cognito user pool and its client ID.
 */
class CognitoIdentityProvider private constructor(builder: BuilderImpl) {
    /**
     * The client ID for the Amazon Cognito user pool.
     */
    val clientId: String? = builder.clientId
    /**
     * The provider name for an Amazon Cognito user pool. For example,
     * cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
     */
    val providerName: String? = builder.providerName
    /**
     * TRUE if server-side token validation is enabled for the identity provider’s
     * token.
     * Once you set ServerSideTokenCheck to TRUE for an identity pool, that
     * identity pool will check with the integrated user pools to make sure that the user has not
     * been globally signed out or deleted before the identity pool provides an OIDC token or AWS
     * credentials for the user.
     * If the user is signed out or deleted, the identity pool will return a 400 Not
     * Authorized error.
     */
    val serverSideTokenCheck: Boolean = builder.serverSideTokenCheck

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CognitoIdentityProvider = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoIdentityProvider(")
        append("clientId=$clientId,")
        append("providerName=$providerName,")
        append("serverSideTokenCheck=$serverSideTokenCheck)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (serverSideTokenCheck.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CognitoIdentityProvider

        if (clientId != other.clientId) return false
        if (providerName != other.providerName) return false
        if (serverSideTokenCheck != other.serverSideTokenCheck) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CognitoIdentityProvider = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CognitoIdentityProvider
        /**
         * The client ID for the Amazon Cognito user pool.
         */
        fun clientId(clientId: String): FluentBuilder
        /**
         * The provider name for an Amazon Cognito user pool. For example,
         * cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
         */
        fun providerName(providerName: String): FluentBuilder
        /**
         * TRUE if server-side token validation is enabled for the identity provider’s
         * token.
         * Once you set ServerSideTokenCheck to TRUE for an identity pool, that
         * identity pool will check with the integrated user pools to make sure that the user has not
         * been globally signed out or deleted before the identity pool provides an OIDC token or AWS
         * credentials for the user.
         * If the user is signed out or deleted, the identity pool will return a 400 Not
         * Authorized error.
         */
        fun serverSideTokenCheck(serverSideTokenCheck: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The client ID for the Amazon Cognito user pool.
         */
        var clientId: String?
        /**
         * The provider name for an Amazon Cognito user pool. For example,
         * cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
         */
        var providerName: String?
        /**
         * TRUE if server-side token validation is enabled for the identity provider’s
         * token.
         * Once you set ServerSideTokenCheck to TRUE for an identity pool, that
         * identity pool will check with the integrated user pools to make sure that the user has not
         * been globally signed out or deleted before the identity pool provides an OIDC token or AWS
         * credentials for the user.
         * If the user is signed out or deleted, the identity pool will return a 400 Not
         * Authorized error.
         */
        var serverSideTokenCheck: Boolean

        fun build(): CognitoIdentityProvider
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientId: String? = null
        override var providerName: String? = null
        override var serverSideTokenCheck: Boolean = false

        constructor(x: CognitoIdentityProvider) : this() {
            this.clientId = x.clientId
            this.providerName = x.providerName
            this.serverSideTokenCheck = x.serverSideTokenCheck
        }

        override fun build(): CognitoIdentityProvider = CognitoIdentityProvider(this)
        override fun clientId(clientId: String): FluentBuilder = apply { this.clientId = clientId }
        override fun providerName(providerName: String): FluentBuilder = apply { this.providerName = providerName }
        override fun serverSideTokenCheck(serverSideTokenCheck: Boolean): FluentBuilder = apply { this.serverSideTokenCheck = serverSideTokenCheck }
    }
}
