// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.cognitoidentity.model.*
import aws.smithy.kotlin.runtime.http.middleware.RetryFeature
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation

private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

internal fun registerCreateIdentityPoolMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<CreateIdentityPoolRequest,CreateIdentityPoolResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerDeleteIdentitiesMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<DeleteIdentitiesRequest,DeleteIdentitiesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerDeleteIdentityPoolMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<DeleteIdentityPoolRequest,DeleteIdentityPoolResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerDescribeIdentityMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<DescribeIdentityRequest,DescribeIdentityResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerDescribeIdentityPoolMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<DescribeIdentityPoolRequest,DescribeIdentityPoolResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerGetCredentialsForIdentityMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<GetCredentialsForIdentityRequest,GetCredentialsForIdentityResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
    }
}

internal fun registerGetIdMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<GetIdRequest,GetIdResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
    }
}

internal fun registerGetIdentityPoolRolesMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<GetIdentityPoolRolesRequest,GetIdentityPoolRolesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerGetOpenIdTokenMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<GetOpenIdTokenRequest,GetOpenIdTokenResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
    }
}

internal fun registerGetOpenIdTokenForDeveloperIdentityMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<GetOpenIdTokenForDeveloperIdentityRequest,GetOpenIdTokenForDeveloperIdentityResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerGetPrincipalTagAttributeMapMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<GetPrincipalTagAttributeMapRequest,GetPrincipalTagAttributeMapResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerListIdentitiesMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<ListIdentitiesRequest,ListIdentitiesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerListIdentityPoolsMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<ListIdentityPoolsRequest,ListIdentityPoolsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerListTagsForResourceMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<ListTagsForResourceRequest,ListTagsForResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerLookupDeveloperIdentityMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<LookupDeveloperIdentityRequest,LookupDeveloperIdentityResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerMergeDeveloperIdentitiesMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<MergeDeveloperIdentitiesRequest,MergeDeveloperIdentitiesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerSetIdentityPoolRolesMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<SetIdentityPoolRolesRequest,SetIdentityPoolRolesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerSetPrincipalTagAttributeMapMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<SetPrincipalTagAttributeMapRequest,SetPrincipalTagAttributeMapResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerTagResourceMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<TagResourceRequest,TagResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerUnlinkDeveloperIdentityMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<UnlinkDeveloperIdentityRequest,UnlinkDeveloperIdentityResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerUnlinkIdentityMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<UnlinkIdentityRequest,UnlinkIdentityResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
    }
}

internal fun registerUntagResourceMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<UntagResourceRequest,UntagResourceResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}

internal fun registerUpdateIdentityPoolMiddleware(config: CognitoIdentityClient.Config, op: SdkHttpOperation<UpdateIdentityPoolRequest,UpdateIdentityPoolResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AWSCognitoIdentityService"
            version = "1.1"
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cognito-identity"
        }
    }
}
