// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.cognitoidentity.model.*
import aws.sdk.kotlin.services.cognitoidentity.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Cognito Identity"
const val ServiceApiVersion: String = "2014-06-30"
const val SdkVersion: String = "0.9.0-alpha"

internal class DefaultCognitoIdentityClient(override val config: CognitoIdentityClient.Config) : CognitoIdentityClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Creates a new identity pool. The identity pool is a store of user identity
     * information that is specific to your AWS account. The keys for SupportedLoginProviders are as follows:
     * Facebook: graph.facebook.com
     * Google: accounts.google.com
     * Amazon: www.amazon.com
     * Twitter: api.twitter.com
     * Digits: www.digits.com
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun createIdentityPool(input: CreateIdentityPoolRequest): CreateIdentityPoolResponse {
        val op = SdkHttpOperation.build<CreateIdentityPoolRequest, CreateIdentityPoolResponse> {
            serializer = CreateIdentityPoolOperationSerializer()
            deserializer = CreateIdentityPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIdentityPool"
            }
        }
        registerCreateIdentityPoolMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes identities from an identity pool. You can specify a list of 1-60 identities
     * that you want to delete.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun deleteIdentities(input: DeleteIdentitiesRequest): DeleteIdentitiesResponse {
        val op = SdkHttpOperation.build<DeleteIdentitiesRequest, DeleteIdentitiesResponse> {
            serializer = DeleteIdentitiesOperationSerializer()
            deserializer = DeleteIdentitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIdentities"
            }
        }
        registerDeleteIdentitiesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an identity pool. Once a pool is deleted, users will not be able to
     * authenticate with the pool.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun deleteIdentityPool(input: DeleteIdentityPoolRequest): DeleteIdentityPoolResponse {
        val op = SdkHttpOperation.build<DeleteIdentityPoolRequest, DeleteIdentityPoolResponse> {
            serializer = DeleteIdentityPoolOperationSerializer()
            deserializer = DeleteIdentityPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIdentityPool"
            }
        }
        registerDeleteIdentityPoolMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata related to the given identity, including when the identity was
     * created and any associated linked logins.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun describeIdentity(input: DescribeIdentityRequest): DescribeIdentityResponse {
        val op = SdkHttpOperation.build<DescribeIdentityRequest, DescribeIdentityResponse> {
            serializer = DescribeIdentityOperationSerializer()
            deserializer = DescribeIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIdentity"
            }
        }
        registerDescribeIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a particular identity pool, including the pool name, ID
     * description, creation date, and current number of users.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun describeIdentityPool(input: DescribeIdentityPoolRequest): DescribeIdentityPoolResponse {
        val op = SdkHttpOperation.build<DescribeIdentityPoolRequest, DescribeIdentityPoolResponse> {
            serializer = DescribeIdentityPoolOperationSerializer()
            deserializer = DescribeIdentityPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIdentityPool"
            }
        }
        registerDescribeIdentityPoolMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns credentials for the provided identity ID. Any provided logins will be
     * validated against supported login providers. If the token is for
     * cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service
     * with the appropriate role for the token.
     * This is a public API. You do not need any credentials to call this API.
     */
    override suspend fun getCredentialsForIdentity(input: GetCredentialsForIdentityRequest): GetCredentialsForIdentityResponse {
        val op = SdkHttpOperation.build<GetCredentialsForIdentityRequest, GetCredentialsForIdentityResponse> {
            serializer = GetCredentialsForIdentityOperationSerializer()
            deserializer = GetCredentialsForIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCredentialsForIdentity"
            }
        }
        registerGetCredentialsForIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an
     * implicit linked account.
     * This is a public API. You do not need any credentials to call this API.
     */
    override suspend fun getId(input: GetIdRequest): GetIdResponse {
        val op = SdkHttpOperation.build<GetIdRequest, GetIdResponse> {
            serializer = GetIdOperationSerializer()
            deserializer = GetIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetId"
            }
        }
        registerGetIdMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the roles for an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun getIdentityPoolRoles(input: GetIdentityPoolRolesRequest): GetIdentityPoolRolesResponse {
        val op = SdkHttpOperation.build<GetIdentityPoolRolesRequest, GetIdentityPoolRolesResponse> {
            serializer = GetIdentityPoolRolesOperationSerializer()
            deserializer = GetIdentityPoolRolesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIdentityPoolRoles"
            }
        }
        registerGetIdentityPoolRolesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by
     * GetId. You can optionally add additional logins for the identity.
     * Supplying multiple logins creates an implicit link.
     * The OpenID token is valid for 10 minutes.
     * This is a public API. You do not need any credentials to call this API.
     */
    override suspend fun getOpenIdToken(input: GetOpenIdTokenRequest): GetOpenIdTokenResponse {
        val op = SdkHttpOperation.build<GetOpenIdTokenRequest, GetOpenIdTokenResponse> {
            serializer = GetOpenIdTokenOperationSerializer()
            deserializer = GetOpenIdTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOpenIdToken"
            }
        }
        registerGetOpenIdTokenMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Registers (or retrieves) a Cognito IdentityId and an OpenID Connect
     * token for a user authenticated by your backend authentication process. Supplying multiple
     * logins will create an implicit linked account. You can only specify one developer provider
     * as part of the Logins map, which is linked to the identity pool. The developer
     * provider is the "domain" by which Cognito will refer to your users.
     * You can use GetOpenIdTokenForDeveloperIdentity to create a new identity
     * and to link new logins (that is, user credentials issued by a public provider or developer
     * provider) to an existing identity. When you want to create a new identity, the
     * IdentityId should be null. When you want to associate a new login with an
     * existing authenticated/unauthenticated identity, you can do so by providing the existing
     * IdentityId. This API will create the identity in the specified
     * IdentityPoolId.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun getOpenIdTokenForDeveloperIdentity(input: GetOpenIdTokenForDeveloperIdentityRequest): GetOpenIdTokenForDeveloperIdentityResponse {
        val op = SdkHttpOperation.build<GetOpenIdTokenForDeveloperIdentityRequest, GetOpenIdTokenForDeveloperIdentityResponse> {
            serializer = GetOpenIdTokenForDeveloperIdentityOperationSerializer()
            deserializer = GetOpenIdTokenForDeveloperIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOpenIdTokenForDeveloperIdentity"
            }
        }
        registerGetOpenIdTokenForDeveloperIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Use GetPrincipalTagAttributeMap to list all mappings between PrincipalTags and user attributes.
     */
    override suspend fun getPrincipalTagAttributeMap(input: GetPrincipalTagAttributeMapRequest): GetPrincipalTagAttributeMapResponse {
        val op = SdkHttpOperation.build<GetPrincipalTagAttributeMapRequest, GetPrincipalTagAttributeMapResponse> {
            serializer = GetPrincipalTagAttributeMapOperationSerializer()
            deserializer = GetPrincipalTagAttributeMapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPrincipalTagAttributeMap"
            }
        }
        registerGetPrincipalTagAttributeMapMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the identities in an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun listIdentities(input: ListIdentitiesRequest): ListIdentitiesResponse {
        val op = SdkHttpOperation.build<ListIdentitiesRequest, ListIdentitiesResponse> {
            serializer = ListIdentitiesOperationSerializer()
            deserializer = ListIdentitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIdentities"
            }
        }
        registerListIdentitiesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the Cognito identity pools registered for your account.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun listIdentityPools(input: ListIdentityPoolsRequest): ListIdentityPoolsResponse {
        val op = SdkHttpOperation.build<ListIdentityPoolsRequest, ListIdentityPoolsResponse> {
            serializer = ListIdentityPoolsOperationSerializer()
            deserializer = ListIdentityPoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIdentityPools"
            }
        }
        registerListIdentityPoolsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags that are assigned to an Amazon Cognito identity pool.
     * A tag is a label that you can apply to identity pools to categorize and manage them in
     * different ways, such as by purpose, owner, environment, or other criteria.
     * You can use this action up to 10 times per second, per account.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the IdentityID associated with a
     * DeveloperUserIdentifier or the list of DeveloperUserIdentifier
     * values associated with an IdentityId for an existing identity. Either
     * IdentityID or DeveloperUserIdentifier must not be null. If you
     * supply only one of these values, the other value will be searched in the database and
     * returned as a part of the response. If you supply both,
     * DeveloperUserIdentifier will be matched against IdentityID. If
     * the values are verified against the database, the response returns both values and is the
     * same as the request. Otherwise a ResourceConflictException is
     * thrown.
     * LookupDeveloperIdentity is intended for low-throughput control plane
     * operations: for example, to enable customer service to locate an identity ID by username.
     * If you are using it for higher-volume operations such as user authentication, your requests
     * are likely to be throttled. GetOpenIdTokenForDeveloperIdentity is a
     * better option for higher-volume operations for user authentication.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun lookupDeveloperIdentity(input: LookupDeveloperIdentityRequest): LookupDeveloperIdentityResponse {
        val op = SdkHttpOperation.build<LookupDeveloperIdentityRequest, LookupDeveloperIdentityResponse> {
            serializer = LookupDeveloperIdentityOperationSerializer()
            deserializer = LookupDeveloperIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "LookupDeveloperIdentity"
            }
        }
        registerLookupDeveloperIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Merges two users having different IdentityIds, existing in the same
     * identity pool, and identified by the same developer provider. You can use this action to
     * request that discrete users be merged and identified as a single user in the Cognito
     * environment. Cognito associates the given source user (SourceUserIdentifier)
     * with the IdentityId of the DestinationUserIdentifier. Only
     * developer-authenticated users can be merged. If the users to be merged are associated with
     * the same public provider, but as two different users, an exception will be
     * thrown.
     * The number of linked logins is limited to 20. So, the number of linked logins for the
     * source user, SourceUserIdentifier, and the destination user,
     * DestinationUserIdentifier, together should not be larger than 20.
     * Otherwise, an exception will be thrown.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun mergeDeveloperIdentities(input: MergeDeveloperIdentitiesRequest): MergeDeveloperIdentitiesResponse {
        val op = SdkHttpOperation.build<MergeDeveloperIdentitiesRequest, MergeDeveloperIdentitiesResponse> {
            serializer = MergeDeveloperIdentitiesOperationSerializer()
            deserializer = MergeDeveloperIdentitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MergeDeveloperIdentities"
            }
        }
        registerMergeDeveloperIdentitiesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the roles for an identity pool. These roles are used when making calls to GetCredentialsForIdentity action.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun setIdentityPoolRoles(input: SetIdentityPoolRolesRequest): SetIdentityPoolRolesResponse {
        val op = SdkHttpOperation.build<SetIdentityPoolRolesRequest, SetIdentityPoolRolesResponse> {
            serializer = SetIdentityPoolRolesOperationSerializer()
            deserializer = SetIdentityPoolRolesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetIdentityPoolRoles"
            }
        }
        registerSetIdentityPoolRolesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
     */
    override suspend fun setPrincipalTagAttributeMap(input: SetPrincipalTagAttributeMapRequest): SetPrincipalTagAttributeMapResponse {
        val op = SdkHttpOperation.build<SetPrincipalTagAttributeMapRequest, SetPrincipalTagAttributeMapResponse> {
            serializer = SetPrincipalTagAttributeMapOperationSerializer()
            deserializer = SetPrincipalTagAttributeMapOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetPrincipalTagAttributeMap"
            }
        }
        registerSetPrincipalTagAttributeMapMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label
     * that you can use to categorize and manage identity pools in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * Each tag consists of a key and value, both of which you define. A key is a general
     * category for more specific values. For example, if you have two versions of an identity
     * pool, one for testing and another for production, you might assign an
     * Environment tag key to both identity pools. The value of this key might be
     * Test for one identity pool and Production for the
     * other.
     * Tags are useful for cost tracking and access control. You can activate your tags so that
     * they appear on the Billing and Cost Management console, where you can track the costs
     * associated with your identity pools. In an IAM policy, you can constrain permissions for
     * identity pools based on specific tags or tag values.
     * You can use this action up to 5 times per second, per account. An identity pool can have
     * as many as 50 tags.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Unlinks a DeveloperUserIdentifier from an existing identity. Unlinked
     * developer users will be considered new identities next time they are seen. If, for a given
     * Cognito identity, you remove all federated identities as well as the developer user
     * identifier, the Cognito identity becomes inaccessible.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun unlinkDeveloperIdentity(input: UnlinkDeveloperIdentityRequest): UnlinkDeveloperIdentityResponse {
        val op = SdkHttpOperation.build<UnlinkDeveloperIdentityRequest, UnlinkDeveloperIdentityResponse> {
            serializer = UnlinkDeveloperIdentityOperationSerializer()
            deserializer = UnlinkDeveloperIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnlinkDeveloperIdentity"
            }
        }
        registerUnlinkDeveloperIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Unlinks a federated identity from an existing account. Unlinked logins will be
     * considered new identities next time they are seen. Removing the last linked login will make
     * this identity inaccessible.
     * This is a public API. You do not need any credentials to call this API.
     */
    override suspend fun unlinkIdentity(input: UnlinkIdentityRequest): UnlinkIdentityResponse {
        val op = SdkHttpOperation.build<UnlinkIdentityRequest, UnlinkIdentityResponse> {
            serializer = UnlinkIdentityOperationSerializer()
            deserializer = UnlinkIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnlinkIdentity"
            }
        }
        registerUnlinkIdentityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified Amazon Cognito identity pool. You can use
     * this action up to 5 times per second, per account
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    override suspend fun updateIdentityPool(input: UpdateIdentityPoolRequest): UpdateIdentityPoolResponse {
        val op = SdkHttpOperation.build<UpdateIdentityPoolRequest, UpdateIdentityPoolResponse> {
            serializer = UpdateIdentityPoolOperationSerializer()
            deserializer = UpdateIdentityPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIdentityPool"
            }
        }
        registerUpdateIdentityPoolMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
