// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.cognitoidentity.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cognitoidentity.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon Cognito Federated Identities</fullname>
 * Amazon Cognito Federated Identities is a web service that delivers scoped temporary
 * credentials to mobile devices and other untrusted environments. It uniquely identifies a
 * device and supplies the user with a consistent identity over the lifetime of an
 * application.
 * Using Amazon Cognito Federated Identities, you can enable authentication with one or
 * more third-party identity providers (Facebook, Google, or Login with Amazon) or an Amazon
 * Cognito user pool, and you can also choose to support unauthenticated access from your app.
 * Cognito delivers a unique identifier for each user and acts as an OpenID token provider
 * trusted by AWS Security Token Service (STS) to access temporary, limited-privilege AWS
 * credentials.
 * For a description of the authentication flow from the Amazon Cognito Developer Guide
 * see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html">Authentication Flow.
 * For more information see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html">Amazon Cognito Federated Identities.
 */
interface CognitoIdentityClient : SdkClient {

    override val serviceName: String
        get() = "Cognito Identity"
    /**
     * CognitoIdentityClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): CognitoIdentityClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultCognitoIdentityClient(config)
        }

        operator fun invoke(config: Config): CognitoIdentityClient = DefaultCognitoIdentityClient(config)

        /**
         * Construct a [CognitoIdentityClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): CognitoIdentityClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return CognitoIdentityClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Creates a new identity pool. The identity pool is a store of user identity
     * information that is specific to your AWS account. The keys for SupportedLoginProviders are as follows:
     * Facebook: graph.facebook.com
     * Google: accounts.google.com
     * Amazon: www.amazon.com
     * Twitter: api.twitter.com
     * Digits: www.digits.com
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun createIdentityPool(input: CreateIdentityPoolRequest): CreateIdentityPoolResponse

    /**
     * Creates a new identity pool. The identity pool is a store of user identity
     * information that is specific to your AWS account. The keys for SupportedLoginProviders are as follows:
     * Facebook: graph.facebook.com
     * Google: accounts.google.com
     * Amazon: www.amazon.com
     * Twitter: api.twitter.com
     * Digits: www.digits.com
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun createIdentityPool(block: CreateIdentityPoolRequest.DslBuilder.() -> Unit) = createIdentityPool(CreateIdentityPoolRequest.builder().apply(block).build())

    /**
     * Deletes identities from an identity pool. You can specify a list of 1-60 identities
     * that you want to delete.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun deleteIdentities(input: DeleteIdentitiesRequest): DeleteIdentitiesResponse

    /**
     * Deletes identities from an identity pool. You can specify a list of 1-60 identities
     * that you want to delete.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun deleteIdentities(block: DeleteIdentitiesRequest.DslBuilder.() -> Unit) = deleteIdentities(DeleteIdentitiesRequest.builder().apply(block).build())

    /**
     * Deletes an identity pool. Once a pool is deleted, users will not be able to
     * authenticate with the pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun deleteIdentityPool(input: DeleteIdentityPoolRequest): DeleteIdentityPoolResponse

    /**
     * Deletes an identity pool. Once a pool is deleted, users will not be able to
     * authenticate with the pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun deleteIdentityPool(block: DeleteIdentityPoolRequest.DslBuilder.() -> Unit) = deleteIdentityPool(DeleteIdentityPoolRequest.builder().apply(block).build())

    /**
     * Returns metadata related to the given identity, including when the identity was
     * created and any associated linked logins.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun describeIdentity(input: DescribeIdentityRequest): DescribeIdentityResponse

    /**
     * Returns metadata related to the given identity, including when the identity was
     * created and any associated linked logins.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun describeIdentity(block: DescribeIdentityRequest.DslBuilder.() -> Unit) = describeIdentity(DescribeIdentityRequest.builder().apply(block).build())

    /**
     * Gets details about a particular identity pool, including the pool name, ID
     * description, creation date, and current number of users.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun describeIdentityPool(input: DescribeIdentityPoolRequest): DescribeIdentityPoolResponse

    /**
     * Gets details about a particular identity pool, including the pool name, ID
     * description, creation date, and current number of users.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun describeIdentityPool(block: DescribeIdentityPoolRequest.DslBuilder.() -> Unit) = describeIdentityPool(DescribeIdentityPoolRequest.builder().apply(block).build())

    /**
     * Returns credentials for the provided identity ID. Any provided logins will be
     * validated against supported login providers. If the token is for
     * cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service
     * with the appropriate role for the token.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun getCredentialsForIdentity(input: GetCredentialsForIdentityRequest): GetCredentialsForIdentityResponse

    /**
     * Returns credentials for the provided identity ID. Any provided logins will be
     * validated against supported login providers. If the token is for
     * cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service
     * with the appropriate role for the token.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun getCredentialsForIdentity(block: GetCredentialsForIdentityRequest.DslBuilder.() -> Unit) = getCredentialsForIdentity(GetCredentialsForIdentityRequest.builder().apply(block).build())

    /**
     * Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an
     * implicit linked account.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun getId(input: GetIdRequest): GetIdResponse

    /**
     * Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an
     * implicit linked account.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun getId(block: GetIdRequest.DslBuilder.() -> Unit) = getId(GetIdRequest.builder().apply(block).build())

    /**
     * Gets the roles for an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun getIdentityPoolRoles(input: GetIdentityPoolRolesRequest): GetIdentityPoolRolesResponse

    /**
     * Gets the roles for an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun getIdentityPoolRoles(block: GetIdentityPoolRolesRequest.DslBuilder.() -> Unit) = getIdentityPoolRoles(GetIdentityPoolRolesRequest.builder().apply(block).build())

    /**
     * Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by
     * GetId. You can optionally add additional logins for the identity.
     * Supplying multiple logins creates an implicit link.
     * The OpenID token is valid for 10 minutes.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun getOpenIdToken(input: GetOpenIdTokenRequest): GetOpenIdTokenResponse

    /**
     * Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by
     * GetId. You can optionally add additional logins for the identity.
     * Supplying multiple logins creates an implicit link.
     * The OpenID token is valid for 10 minutes.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun getOpenIdToken(block: GetOpenIdTokenRequest.DslBuilder.() -> Unit) = getOpenIdToken(GetOpenIdTokenRequest.builder().apply(block).build())

    /**
     * Registers (or retrieves) a Cognito IdentityId and an OpenID Connect
     * token for a user authenticated by your backend authentication process. Supplying multiple
     * logins will create an implicit linked account. You can only specify one developer provider
     * as part of the Logins map, which is linked to the identity pool. The developer
     * provider is the "domain" by which Cognito will refer to your users.
     * You can use GetOpenIdTokenForDeveloperIdentity to create a new identity
     * and to link new logins (that is, user credentials issued by a public provider or developer
     * provider) to an existing identity. When you want to create a new identity, the
     * IdentityId should be null. When you want to associate a new login with an
     * existing authenticated/unauthenticated identity, you can do so by providing the existing
     * IdentityId. This API will create the identity in the specified
     * IdentityPoolId.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun getOpenIdTokenForDeveloperIdentity(input: GetOpenIdTokenForDeveloperIdentityRequest): GetOpenIdTokenForDeveloperIdentityResponse

    /**
     * Registers (or retrieves) a Cognito IdentityId and an OpenID Connect
     * token for a user authenticated by your backend authentication process. Supplying multiple
     * logins will create an implicit linked account. You can only specify one developer provider
     * as part of the Logins map, which is linked to the identity pool. The developer
     * provider is the "domain" by which Cognito will refer to your users.
     * You can use GetOpenIdTokenForDeveloperIdentity to create a new identity
     * and to link new logins (that is, user credentials issued by a public provider or developer
     * provider) to an existing identity. When you want to create a new identity, the
     * IdentityId should be null. When you want to associate a new login with an
     * existing authenticated/unauthenticated identity, you can do so by providing the existing
     * IdentityId. This API will create the identity in the specified
     * IdentityPoolId.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun getOpenIdTokenForDeveloperIdentity(block: GetOpenIdTokenForDeveloperIdentityRequest.DslBuilder.() -> Unit) = getOpenIdTokenForDeveloperIdentity(GetOpenIdTokenForDeveloperIdentityRequest.builder().apply(block).build())

    /**
     * Use GetPrincipalTagAttributeMap to list all mappings between PrincipalTags and user attributes.
     */
    suspend fun getPrincipalTagAttributeMap(input: GetPrincipalTagAttributeMapRequest): GetPrincipalTagAttributeMapResponse

    /**
     * Use GetPrincipalTagAttributeMap to list all mappings between PrincipalTags and user attributes.
     */
    suspend fun getPrincipalTagAttributeMap(block: GetPrincipalTagAttributeMapRequest.DslBuilder.() -> Unit) = getPrincipalTagAttributeMap(GetPrincipalTagAttributeMapRequest.builder().apply(block).build())

    /**
     * Lists the identities in an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun listIdentities(input: ListIdentitiesRequest): ListIdentitiesResponse

    /**
     * Lists the identities in an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun listIdentities(block: ListIdentitiesRequest.DslBuilder.() -> Unit) = listIdentities(ListIdentitiesRequest.builder().apply(block).build())

    /**
     * Lists all of the Cognito identity pools registered for your account.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun listIdentityPools(input: ListIdentityPoolsRequest): ListIdentityPoolsResponse

    /**
     * Lists all of the Cognito identity pools registered for your account.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun listIdentityPools(block: ListIdentityPoolsRequest.DslBuilder.() -> Unit) = listIdentityPools(ListIdentityPoolsRequest.builder().apply(block).build())

    /**
     * Lists the tags that are assigned to an Amazon Cognito identity pool.
     * A tag is a label that you can apply to identity pools to categorize and manage them in
     * different ways, such as by purpose, owner, environment, or other criteria.
     * You can use this action up to 10 times per second, per account.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags that are assigned to an Amazon Cognito identity pool.
     * A tag is a label that you can apply to identity pools to categorize and manage them in
     * different ways, such as by purpose, owner, environment, or other criteria.
     * You can use this action up to 10 times per second, per account.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Retrieves the IdentityID associated with a
     * DeveloperUserIdentifier or the list of DeveloperUserIdentifier
     * values associated with an IdentityId for an existing identity. Either
     * IdentityID or DeveloperUserIdentifier must not be null. If you
     * supply only one of these values, the other value will be searched in the database and
     * returned as a part of the response. If you supply both,
     * DeveloperUserIdentifier will be matched against IdentityID. If
     * the values are verified against the database, the response returns both values and is the
     * same as the request. Otherwise a ResourceConflictException is
     * thrown.
     * LookupDeveloperIdentity is intended for low-throughput control plane
     * operations: for example, to enable customer service to locate an identity ID by username.
     * If you are using it for higher-volume operations such as user authentication, your requests
     * are likely to be throttled. GetOpenIdTokenForDeveloperIdentity is a
     * better option for higher-volume operations for user authentication.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun lookupDeveloperIdentity(input: LookupDeveloperIdentityRequest): LookupDeveloperIdentityResponse

    /**
     * Retrieves the IdentityID associated with a
     * DeveloperUserIdentifier or the list of DeveloperUserIdentifier
     * values associated with an IdentityId for an existing identity. Either
     * IdentityID or DeveloperUserIdentifier must not be null. If you
     * supply only one of these values, the other value will be searched in the database and
     * returned as a part of the response. If you supply both,
     * DeveloperUserIdentifier will be matched against IdentityID. If
     * the values are verified against the database, the response returns both values and is the
     * same as the request. Otherwise a ResourceConflictException is
     * thrown.
     * LookupDeveloperIdentity is intended for low-throughput control plane
     * operations: for example, to enable customer service to locate an identity ID by username.
     * If you are using it for higher-volume operations such as user authentication, your requests
     * are likely to be throttled. GetOpenIdTokenForDeveloperIdentity is a
     * better option for higher-volume operations for user authentication.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun lookupDeveloperIdentity(block: LookupDeveloperIdentityRequest.DslBuilder.() -> Unit) = lookupDeveloperIdentity(LookupDeveloperIdentityRequest.builder().apply(block).build())

    /**
     * Merges two users having different IdentityIds, existing in the same
     * identity pool, and identified by the same developer provider. You can use this action to
     * request that discrete users be merged and identified as a single user in the Cognito
     * environment. Cognito associates the given source user (SourceUserIdentifier)
     * with the IdentityId of the DestinationUserIdentifier. Only
     * developer-authenticated users can be merged. If the users to be merged are associated with
     * the same public provider, but as two different users, an exception will be
     * thrown.
     * The number of linked logins is limited to 20. So, the number of linked logins for the
     * source user, SourceUserIdentifier, and the destination user,
     * DestinationUserIdentifier, together should not be larger than 20.
     * Otherwise, an exception will be thrown.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun mergeDeveloperIdentities(input: MergeDeveloperIdentitiesRequest): MergeDeveloperIdentitiesResponse

    /**
     * Merges two users having different IdentityIds, existing in the same
     * identity pool, and identified by the same developer provider. You can use this action to
     * request that discrete users be merged and identified as a single user in the Cognito
     * environment. Cognito associates the given source user (SourceUserIdentifier)
     * with the IdentityId of the DestinationUserIdentifier. Only
     * developer-authenticated users can be merged. If the users to be merged are associated with
     * the same public provider, but as two different users, an exception will be
     * thrown.
     * The number of linked logins is limited to 20. So, the number of linked logins for the
     * source user, SourceUserIdentifier, and the destination user,
     * DestinationUserIdentifier, together should not be larger than 20.
     * Otherwise, an exception will be thrown.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun mergeDeveloperIdentities(block: MergeDeveloperIdentitiesRequest.DslBuilder.() -> Unit) = mergeDeveloperIdentities(MergeDeveloperIdentitiesRequest.builder().apply(block).build())

    /**
     * Sets the roles for an identity pool. These roles are used when making calls to GetCredentialsForIdentity action.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun setIdentityPoolRoles(input: SetIdentityPoolRolesRequest): SetIdentityPoolRolesResponse

    /**
     * Sets the roles for an identity pool. These roles are used when making calls to GetCredentialsForIdentity action.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun setIdentityPoolRoles(block: SetIdentityPoolRolesRequest.DslBuilder.() -> Unit) = setIdentityPoolRoles(SetIdentityPoolRolesRequest.builder().apply(block).build())

    /**
     * You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
     */
    suspend fun setPrincipalTagAttributeMap(input: SetPrincipalTagAttributeMapRequest): SetPrincipalTagAttributeMapResponse

    /**
     * You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
     */
    suspend fun setPrincipalTagAttributeMap(block: SetPrincipalTagAttributeMapRequest.DslBuilder.() -> Unit) = setPrincipalTagAttributeMap(SetPrincipalTagAttributeMapRequest.builder().apply(block).build())

    /**
     * Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label
     * that you can use to categorize and manage identity pools in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * Each tag consists of a key and value, both of which you define. A key is a general
     * category for more specific values. For example, if you have two versions of an identity
     * pool, one for testing and another for production, you might assign an
     * Environment tag key to both identity pools. The value of this key might be
     * Test for one identity pool and Production for the
     * other.
     * Tags are useful for cost tracking and access control. You can activate your tags so that
     * they appear on the Billing and Cost Management console, where you can track the costs
     * associated with your identity pools. In an IAM policy, you can constrain permissions for
     * identity pools based on specific tags or tag values.
     * You can use this action up to 5 times per second, per account. An identity pool can have
     * as many as 50 tags.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label
     * that you can use to categorize and manage identity pools in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * Each tag consists of a key and value, both of which you define. A key is a general
     * category for more specific values. For example, if you have two versions of an identity
     * pool, one for testing and another for production, you might assign an
     * Environment tag key to both identity pools. The value of this key might be
     * Test for one identity pool and Production for the
     * other.
     * Tags are useful for cost tracking and access control. You can activate your tags so that
     * they appear on the Billing and Cost Management console, where you can track the costs
     * associated with your identity pools. In an IAM policy, you can constrain permissions for
     * identity pools based on specific tags or tag values.
     * You can use this action up to 5 times per second, per account. An identity pool can have
     * as many as 50 tags.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Unlinks a DeveloperUserIdentifier from an existing identity. Unlinked
     * developer users will be considered new identities next time they are seen. If, for a given
     * Cognito identity, you remove all federated identities as well as the developer user
     * identifier, the Cognito identity becomes inaccessible.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun unlinkDeveloperIdentity(input: UnlinkDeveloperIdentityRequest): UnlinkDeveloperIdentityResponse

    /**
     * Unlinks a DeveloperUserIdentifier from an existing identity. Unlinked
     * developer users will be considered new identities next time they are seen. If, for a given
     * Cognito identity, you remove all federated identities as well as the developer user
     * identifier, the Cognito identity becomes inaccessible.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun unlinkDeveloperIdentity(block: UnlinkDeveloperIdentityRequest.DslBuilder.() -> Unit) = unlinkDeveloperIdentity(UnlinkDeveloperIdentityRequest.builder().apply(block).build())

    /**
     * Unlinks a federated identity from an existing account. Unlinked logins will be
     * considered new identities next time they are seen. Removing the last linked login will make
     * this identity inaccessible.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun unlinkIdentity(input: UnlinkIdentityRequest): UnlinkIdentityResponse

    /**
     * Unlinks a federated identity from an existing account. Unlinked logins will be
     * considered new identities next time they are seen. Removing the last linked login will make
     * this identity inaccessible.
     * This is a public API. You do not need any credentials to call this API.
     */
    suspend fun unlinkIdentity(block: UnlinkIdentityRequest.DslBuilder.() -> Unit) = unlinkIdentity(UnlinkIdentityRequest.builder().apply(block).build())

    /**
     * Removes the specified tags from the specified Amazon Cognito identity pool. You can use
     * this action up to 5 times per second, per account
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified Amazon Cognito identity pool. You can use
     * this action up to 5 times per second, per account
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun updateIdentityPool(input: UpdateIdentityPoolRequest): UpdateIdentityPoolResponse

    /**
     * Updates an identity pool.
     * You must use AWS Developer credentials to call this API.
     */
    suspend fun updateIdentityPool(block: UpdateIdentityPoolRequest.DslBuilder.() -> Unit) = updateIdentityPool(UpdateIdentityPoolRequest.builder().apply(block).build())
}
