// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.paginators

import aws.sdk.kotlin.services.cognitoidentity.CognitoIdentityClient
import aws.sdk.kotlin.services.cognitoidentity.model.IdentityPoolShortDescription
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentityPoolsRequest
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentityPoolsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListIdentityPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentityPoolsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityPoolsResponse]
 */
public fun CognitoIdentityClient.listIdentityPoolsPaginated(initialRequest: ListIdentityPoolsRequest): Flow<ListIdentityPoolsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentityPoolsPaginated.listIdentityPools(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentityPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityPoolsResponse]
 */
public fun CognitoIdentityClient.listIdentityPoolsPaginated(block: ListIdentityPoolsRequest.Builder.() -> Unit): Flow<ListIdentityPoolsResponse> =
    listIdentityPoolsPaginated(ListIdentityPoolsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdentityPoolsPaginated]
 * to access the nested member [IdentityPoolShortDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IdentityPoolShortDescription]
 */
@JvmName("listIdentityPoolsResponseIdentityPoolShortDescription")
public fun Flow<ListIdentityPoolsResponse>.identityPools(): Flow<IdentityPoolShortDescription> =
    transform() { response ->
        response.identityPools?.forEach {
            emit(it)
        }
    }
