// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.serde

import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityProvider
import aws.sdk.kotlin.services.cognitoidentity.model.UpdateIdentityPoolResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateIdentityPoolOperationDeserializer: HttpDeserializer.NonStreaming<UpdateIdentityPoolResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateIdentityPoolResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateIdentityPoolError(context, call, payload)
        }
        val builder = UpdateIdentityPoolResponse.Builder()

        if (payload != null) {
            deserializeUpdateIdentityPoolOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateIdentityPoolError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CognitoIdentityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateIdentityPoolOperationBody(builder: UpdateIdentityPoolResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOWCLASSICFLOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AllowClassicFlow"))
    val ALLOWUNAUTHENTICATEDIDENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AllowUnauthenticatedIdentities"))
    val COGNITOIDENTITYPROVIDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CognitoIdentityProviders"))
    val DEVELOPERPROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeveloperProviderName"))
    val IDENTITYPOOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityPoolId"))
    val IDENTITYPOOLNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityPoolName"))
    val IDENTITYPOOLTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("IdentityPoolTags"))
    val OPENIDCONNECTPROVIDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OpenIdConnectProviderARNs"))
    val SAMLPROVIDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SamlProviderARNs"))
    val SUPPORTEDLOGINPROVIDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("SupportedLoginProviders"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWCLASSICFLOW_DESCRIPTOR)
        field(ALLOWUNAUTHENTICATEDIDENTITIES_DESCRIPTOR)
        field(COGNITOIDENTITYPROVIDERS_DESCRIPTOR)
        field(DEVELOPERPROVIDERNAME_DESCRIPTOR)
        field(IDENTITYPOOLID_DESCRIPTOR)
        field(IDENTITYPOOLNAME_DESCRIPTOR)
        field(IDENTITYPOOLTAGS_DESCRIPTOR)
        field(OPENIDCONNECTPROVIDERARNS_DESCRIPTOR)
        field(SAMLPROVIDERARNS_DESCRIPTOR)
        field(SUPPORTEDLOGINPROVIDERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWCLASSICFLOW_DESCRIPTOR.index -> builder.allowClassicFlow = deserializeBoolean()
                ALLOWUNAUTHENTICATEDIDENTITIES_DESCRIPTOR.index -> builder.allowUnauthenticatedIdentities = deserializeBoolean()
                COGNITOIDENTITYPROVIDERS_DESCRIPTOR.index -> builder.cognitoIdentityProviders =
                    deserializer.deserializeList(COGNITOIDENTITYPROVIDERS_DESCRIPTOR) {
                        val col0 = mutableListOf<CognitoIdentityProvider>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCognitoIdentityProviderDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DEVELOPERPROVIDERNAME_DESCRIPTOR.index -> builder.developerProviderName = deserializeString()
                IDENTITYPOOLID_DESCRIPTOR.index -> builder.identityPoolId = deserializeString()
                IDENTITYPOOLNAME_DESCRIPTOR.index -> builder.identityPoolName = deserializeString()
                IDENTITYPOOLTAGS_DESCRIPTOR.index -> builder.identityPoolTags =
                    deserializer.deserializeMap(IDENTITYPOOLTAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                OPENIDCONNECTPROVIDERARNS_DESCRIPTOR.index -> builder.openIdConnectProviderArns =
                    deserializer.deserializeList(OPENIDCONNECTPROVIDERARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SAMLPROVIDERARNS_DESCRIPTOR.index -> builder.samlProviderArns =
                    deserializer.deserializeList(SAMLPROVIDERARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUPPORTEDLOGINPROVIDERS_DESCRIPTOR.index -> builder.supportedLoginProviders =
                    deserializer.deserializeMap(SUPPORTEDLOGINPROVIDERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
