// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input to the `SetIdentityPoolRoles` action.
 */
public class SetIdentityPoolRolesRequest private constructor(builder: Builder) {
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    public val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * How users for a specific identity provider are to mapped to roles. This is a string to RoleMapping object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
     *
     * Up to 25 rules can be specified per identity provider.
     */
    public val roleMappings: Map<String, RoleMapping>? = builder.roleMappings
    /**
     * The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
     */
    public val roles: Map<String, String>? = builder.roles

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityPoolRolesRequest(")
        append("identityPoolId=$identityPoolId,")
        append("roleMappings=$roleMappings,")
        append("roles=$roles")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityPoolId?.hashCode() ?: 0
        result = 31 * result + (roleMappings?.hashCode() ?: 0)
        result = 31 * result + (roles?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetIdentityPoolRolesRequest

        if (identityPoolId != other.identityPoolId) return false
        if (roleMappings != other.roleMappings) return false
        if (roles != other.roles) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        public var identityPoolId: kotlin.String? = null
        /**
         * How users for a specific identity provider are to mapped to roles. This is a string to RoleMapping object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         *
         * Up to 25 rules can be specified per identity provider.
         */
        public var roleMappings: Map<String, RoleMapping>? = null
        /**
         * The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
         */
        public var roles: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest) : this() {
            this.identityPoolId = x.identityPoolId
            this.roleMappings = x.roleMappings
            this.roles = x.roles
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest = SetIdentityPoolRolesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
