// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input to the `GetOpenIdTokenForDeveloperIdentity` action.
 */
public class GetOpenIdTokenForDeveloperIdentityRequest private constructor(builder: Builder) {
    /**
     * A unique identifier in the format REGION:GUID.
     */
    public val identityId: kotlin.String? = builder.identityId
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    public val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a user from a public provider or developer provider. If the user is from a developer provider, the name-value pair will follow the syntax `"developer_provider_name": "developer_user_identifier"`. The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the identity pool. The developer user identifier is an identifier from your backend that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.
     */
    public val logins: Map<String, String>? = builder.logins
    /**
     * Use this operation to configure attribute mappings for custom providers.
     */
    public val principalTags: Map<String, String>? = builder.principalTags
    /**
     * The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are significant security implications: an attacker could use a leaked token to access your AWS resources for the token's duration.
     *
     * Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.
     */
    public val tokenDuration: kotlin.Long? = builder.tokenDuration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetOpenIdTokenForDeveloperIdentityRequest(")
        append("identityId=$identityId,")
        append("identityPoolId=$identityPoolId,")
        append("logins=$logins,")
        append("principalTags=$principalTags,")
        append("tokenDuration=$tokenDuration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityId?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (logins?.hashCode() ?: 0)
        result = 31 * result + (principalTags?.hashCode() ?: 0)
        result = 31 * result + (tokenDuration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetOpenIdTokenForDeveloperIdentityRequest

        if (identityId != other.identityId) return false
        if (identityPoolId != other.identityPoolId) return false
        if (logins != other.logins) return false
        if (principalTags != other.principalTags) return false
        if (tokenDuration != other.tokenDuration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier in the format REGION:GUID.
         */
        public var identityId: kotlin.String? = null
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        public var identityPoolId: kotlin.String? = null
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a user from a public provider or developer provider. If the user is from a developer provider, the name-value pair will follow the syntax `"developer_provider_name": "developer_user_identifier"`. The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the identity pool. The developer user identifier is an identifier from your backend that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.
         */
        public var logins: Map<String, String>? = null
        /**
         * Use this operation to configure attribute mappings for custom providers.
         */
        public var principalTags: Map<String, String>? = null
        /**
         * The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are significant security implications: an attacker could use a leaked token to access your AWS resources for the token's duration.
         *
         * Please provide for a small grace period, usually no more than 5 minutes, to account for clock skew.
         */
        public var tokenDuration: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest) : this() {
            this.identityId = x.identityId
            this.identityPoolId = x.identityPoolId
            this.logins = x.logins
            this.principalTags = x.principalTags
            this.tokenDuration = x.tokenDuration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest = GetOpenIdTokenForDeveloperIdentityRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
