// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.cognitoidentity.auth.CognitoIdentityAuthSchemeProvider
import aws.sdk.kotlin.services.cognitoidentity.auth.DefaultCognitoIdentityAuthSchemeProvider
import aws.sdk.kotlin.services.cognitoidentity.endpoints.CognitoIdentityEndpointParameters
import aws.sdk.kotlin.services.cognitoidentity.endpoints.CognitoIdentityEndpointProvider
import aws.sdk.kotlin.services.cognitoidentity.endpoints.DefaultCognitoIdentityEndpointProvider
import aws.sdk.kotlin.services.cognitoidentity.model.CreateIdentityPoolRequest
import aws.sdk.kotlin.services.cognitoidentity.model.CreateIdentityPoolResponse
import aws.sdk.kotlin.services.cognitoidentity.model.DeleteIdentitiesRequest
import aws.sdk.kotlin.services.cognitoidentity.model.DeleteIdentitiesResponse
import aws.sdk.kotlin.services.cognitoidentity.model.DeleteIdentityPoolRequest
import aws.sdk.kotlin.services.cognitoidentity.model.DeleteIdentityPoolResponse
import aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityPoolRequest
import aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityPoolResponse
import aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityRequest
import aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityResponse
import aws.sdk.kotlin.services.cognitoidentity.model.GetCredentialsForIdentityRequest
import aws.sdk.kotlin.services.cognitoidentity.model.GetCredentialsForIdentityResponse
import aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest
import aws.sdk.kotlin.services.cognitoidentity.model.GetIdResponse
import aws.sdk.kotlin.services.cognitoidentity.model.GetIdentityPoolRolesRequest
import aws.sdk.kotlin.services.cognitoidentity.model.GetIdentityPoolRolesResponse
import aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest
import aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
import aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenRequest
import aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenResponse
import aws.sdk.kotlin.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest
import aws.sdk.kotlin.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentitiesRequest
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentitiesResponse
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentityPoolsRequest
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentityPoolsResponse
import aws.sdk.kotlin.services.cognitoidentity.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cognitoidentity.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cognitoidentity.model.LookupDeveloperIdentityRequest
import aws.sdk.kotlin.services.cognitoidentity.model.LookupDeveloperIdentityResponse
import aws.sdk.kotlin.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest
import aws.sdk.kotlin.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse
import aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest
import aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesResponse
import aws.sdk.kotlin.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest
import aws.sdk.kotlin.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse
import aws.sdk.kotlin.services.cognitoidentity.model.TagResourceRequest
import aws.sdk.kotlin.services.cognitoidentity.model.TagResourceResponse
import aws.sdk.kotlin.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest
import aws.sdk.kotlin.services.cognitoidentity.model.UnlinkDeveloperIdentityResponse
import aws.sdk.kotlin.services.cognitoidentity.model.UnlinkIdentityRequest
import aws.sdk.kotlin.services.cognitoidentity.model.UnlinkIdentityResponse
import aws.sdk.kotlin.services.cognitoidentity.model.UntagResourceRequest
import aws.sdk.kotlin.services.cognitoidentity.model.UntagResourceResponse
import aws.sdk.kotlin.services.cognitoidentity.model.UpdateIdentityPoolRequest
import aws.sdk.kotlin.services.cognitoidentity.model.UpdateIdentityPoolResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Cognito Identity"
public const val SdkVersion: String = "1.2.25"
public const val ServiceApiVersion: String = "2014-06-30"

/**
 * # Amazon Cognito Federated Identities
 * Amazon Cognito Federated Identities is a web service that delivers scoped temporary credentials to mobile devices and other untrusted environments. It uniquely identifies a device and supplies the user with a consistent identity over the lifetime of an application.
 *
 * Using Amazon Cognito Federated Identities, you can enable authentication with one or more third-party identity providers (Facebook, Google, or Login with Amazon) or an Amazon Cognito user pool, and you can also choose to support unauthenticated access from your app. Cognito delivers a unique identifier for each user and acts as an OpenID token provider trusted by AWS Security Token Service (STS) to access temporary, limited-privilege AWS credentials.
 *
 * For a description of the authentication flow from the Amazon Cognito Developer Guide see [Authentication Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html).
 *
 * For more information see [Amazon Cognito Federated Identities](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html).
 */
public interface CognitoIdentityClient : SdkClient {
    /**
     * CognitoIdentityClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CognitoIdentityClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CognitoIdentity",
                "COGNITO_IDENTITY",
                "cognito_identity",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CognitoIdentityClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CognitoIdentityClient = DefaultCognitoIdentityClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CognitoIdentityEndpointProvider = builder.endpointProvider ?: DefaultCognitoIdentityEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CognitoIdentityAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCognitoIdentityAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Cognito Identity"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CognitoIdentityEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CognitoIdentityAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new identity pool. The identity pool is a store of user identity information that is specific to your AWS account. The keys for `SupportedLoginProviders` are as follows:
     * + Facebook: `graph.facebook.com`
     * + Google: `accounts.google.com`
     * + Amazon: `www.amazon.com`
     * + Twitter: `api.twitter.com`
     * + Digits: `www.digits.com`
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun createIdentityPool(input: CreateIdentityPoolRequest): CreateIdentityPoolResponse

    /**
     * Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun deleteIdentities(input: DeleteIdentitiesRequest): DeleteIdentitiesResponse

    /**
     * Deletes an identity pool. Once a pool is deleted, users will not be able to authenticate with the pool.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun deleteIdentityPool(input: DeleteIdentityPoolRequest): DeleteIdentityPoolResponse

    /**
     * Returns metadata related to the given identity, including when the identity was created and any associated linked logins.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun describeIdentity(input: DescribeIdentityRequest): DescribeIdentityResponse

    /**
     * Gets details about a particular identity pool, including the pool name, ID description, creation date, and current number of users.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun describeIdentityPool(input: DescribeIdentityPoolRequest): DescribeIdentityPoolResponse

    /**
     * Returns credentials for the provided identity ID. Any provided logins will be validated against supported login providers. If the token is for cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service with the appropriate role for the token.
     *
     * This is a public API. You do not need any credentials to call this API.
     */
    public suspend fun getCredentialsForIdentity(input: GetCredentialsForIdentityRequest): GetCredentialsForIdentityResponse

    /**
     * Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.
     *
     * This is a public API. You do not need any credentials to call this API.
     */
    public suspend fun getId(input: GetIdRequest): GetIdResponse

    /**
     * Gets the roles for an identity pool.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun getIdentityPoolRoles(input: GetIdentityPoolRolesRequest): GetIdentityPoolRolesResponse

    /**
     * Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by GetId. You can optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.
     *
     * The OpenID token is valid for 10 minutes.
     *
     * This is a public API. You do not need any credentials to call this API.
     */
    public suspend fun getOpenIdToken(input: GetOpenIdTokenRequest): GetOpenIdTokenResponse

    /**
     * Registers (or retrieves) a Cognito `IdentityId` and an OpenID Connect token for a user authenticated by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can only specify one developer provider as part of the `Logins` map, which is linked to the identity pool. The developer provider is the "domain" by which Cognito will refer to your users.
     *
     * You can use `GetOpenIdTokenForDeveloperIdentity` to create a new identity and to link new logins (that is, user credentials issued by a public provider or developer provider) to an existing identity. When you want to create a new identity, the `IdentityId` should be null. When you want to associate a new login with an existing authenticated/unauthenticated identity, you can do so by providing the existing `IdentityId`. This API will create the identity in the specified `IdentityPoolId`.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun getOpenIdTokenForDeveloperIdentity(input: GetOpenIdTokenForDeveloperIdentityRequest): GetOpenIdTokenForDeveloperIdentityResponse

    /**
     * Use `GetPrincipalTagAttributeMap` to list all mappings between `PrincipalTags` and user attributes.
     */
    public suspend fun getPrincipalTagAttributeMap(input: GetPrincipalTagAttributeMapRequest): GetPrincipalTagAttributeMapResponse

    /**
     * Lists the identities in an identity pool.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun listIdentities(input: ListIdentitiesRequest): ListIdentitiesResponse

    /**
     * Lists all of the Cognito identity pools registered for your account.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun listIdentityPools(input: ListIdentityPoolsRequest): ListIdentityPoolsResponse

    /**
     * Lists the tags that are assigned to an Amazon Cognito identity pool.
     *
     * A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * You can use this action up to 10 times per second, per account.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves the `IdentityID` associated with a `DeveloperUserIdentifier` or the list of `DeveloperUserIdentifier` values associated with an `IdentityId` for an existing identity. Either `IdentityID` or `DeveloperUserIdentifier` must not be null. If you supply only one of these values, the other value will be searched in the database and returned as a part of the response. If you supply both, `DeveloperUserIdentifier` will be matched against `IdentityID`. If the values are verified against the database, the response returns both values and is the same as the request. Otherwise a `ResourceConflictException` is thrown.
     *
     * `LookupDeveloperIdentity` is intended for low-throughput control plane operations: for example, to enable customer service to locate an identity ID by username. If you are using it for higher-volume operations such as user authentication, your requests are likely to be throttled. GetOpenIdTokenForDeveloperIdentity is a better option for higher-volume operations for user authentication.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun lookupDeveloperIdentity(input: LookupDeveloperIdentityRequest): LookupDeveloperIdentityResponse

    /**
     * Merges two users having different `IdentityId`s, existing in the same identity pool, and identified by the same developer provider. You can use this action to request that discrete users be merged and identified as a single user in the Cognito environment. Cognito associates the given source user (`SourceUserIdentifier`) with the `IdentityId` of the `DestinationUserIdentifier`. Only developer-authenticated users can be merged. If the users to be merged are associated with the same public provider, but as two different users, an exception will be thrown.
     *
     * The number of linked logins is limited to 20. So, the number of linked logins for the source user, `SourceUserIdentifier`, and the destination user, `DestinationUserIdentifier`, together should not be larger than 20. Otherwise, an exception will be thrown.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun mergeDeveloperIdentities(input: MergeDeveloperIdentitiesRequest): MergeDeveloperIdentitiesResponse

    /**
     * Sets the roles for an identity pool. These roles are used when making calls to GetCredentialsForIdentity action.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun setIdentityPoolRoles(input: SetIdentityPoolRolesRequest): SetIdentityPoolRolesResponse

    /**
     * You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
     */
    public suspend fun setPrincipalTagAttributeMap(input: SetPrincipalTagAttributeMapRequest): SetPrincipalTagAttributeMapResponse

    /**
     * Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label that you can use to categorize and manage identity pools in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of an identity pool, one for testing and another for production, you might assign an `Environment` tag key to both identity pools. The value of this key might be `Test` for one identity pool and `Production` for the other.
     *
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your identity pools. In an IAM policy, you can constrain permissions for identity pools based on specific tags or tag values.
     *
     * You can use this action up to 5 times per second, per account. An identity pool can have as many as 50 tags.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Unlinks a `DeveloperUserIdentifier` from an existing identity. Unlinked developer users will be considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated identities as well as the developer user identifier, the Cognito identity becomes inaccessible.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun unlinkDeveloperIdentity(input: UnlinkDeveloperIdentityRequest): UnlinkDeveloperIdentityResponse

    /**
     * Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next time they are seen. Removing the last linked login will make this identity inaccessible.
     *
     * This is a public API. You do not need any credentials to call this API.
     */
    public suspend fun unlinkIdentity(input: UnlinkIdentityRequest): UnlinkIdentityResponse

    /**
     * Removes the specified tags from the specified Amazon Cognito identity pool. You can use this action up to 5 times per second, per account
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an identity pool.
     *
     * You must use AWS Developer credentials to call this API.
     */
    public suspend fun updateIdentityPool(input: UpdateIdentityPoolRequest): UpdateIdentityPoolResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CognitoIdentityClient.withConfig(block: CognitoIdentityClient.Config.Builder.() -> Unit): CognitoIdentityClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCognitoIdentityClient(newConfig)
}

/**
 * Creates a new identity pool. The identity pool is a store of user identity information that is specific to your AWS account. The keys for `SupportedLoginProviders` are as follows:
 * + Facebook: `graph.facebook.com`
 * + Google: `accounts.google.com`
 * + Amazon: `www.amazon.com`
 * + Twitter: `api.twitter.com`
 * + Digits: `www.digits.com`
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.createIdentityPool(crossinline block: CreateIdentityPoolRequest.Builder.() -> Unit): CreateIdentityPoolResponse = createIdentityPool(CreateIdentityPoolRequest.Builder().apply(block).build())

/**
 * Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.deleteIdentities(crossinline block: DeleteIdentitiesRequest.Builder.() -> Unit): DeleteIdentitiesResponse = deleteIdentities(DeleteIdentitiesRequest.Builder().apply(block).build())

/**
 * Deletes an identity pool. Once a pool is deleted, users will not be able to authenticate with the pool.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.deleteIdentityPool(crossinline block: DeleteIdentityPoolRequest.Builder.() -> Unit): DeleteIdentityPoolResponse = deleteIdentityPool(DeleteIdentityPoolRequest.Builder().apply(block).build())

/**
 * Returns metadata related to the given identity, including when the identity was created and any associated linked logins.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.describeIdentity(crossinline block: DescribeIdentityRequest.Builder.() -> Unit): DescribeIdentityResponse = describeIdentity(DescribeIdentityRequest.Builder().apply(block).build())

/**
 * Gets details about a particular identity pool, including the pool name, ID description, creation date, and current number of users.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.describeIdentityPool(crossinline block: DescribeIdentityPoolRequest.Builder.() -> Unit): DescribeIdentityPoolResponse = describeIdentityPool(DescribeIdentityPoolRequest.Builder().apply(block).build())

/**
 * Returns credentials for the provided identity ID. Any provided logins will be validated against supported login providers. If the token is for cognito-identity.amazonaws.com, it will be passed through to AWS Security Token Service with the appropriate role for the token.
 *
 * This is a public API. You do not need any credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.getCredentialsForIdentity(crossinline block: GetCredentialsForIdentityRequest.Builder.() -> Unit): GetCredentialsForIdentityResponse = getCredentialsForIdentity(GetCredentialsForIdentityRequest.Builder().apply(block).build())

/**
 * Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.
 *
 * This is a public API. You do not need any credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.getId(crossinline block: GetIdRequest.Builder.() -> Unit): GetIdResponse = getId(GetIdRequest.Builder().apply(block).build())

/**
 * Gets the roles for an identity pool.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.getIdentityPoolRoles(crossinline block: GetIdentityPoolRolesRequest.Builder.() -> Unit): GetIdentityPoolRolesResponse = getIdentityPoolRoles(GetIdentityPoolRolesRequest.Builder().apply(block).build())

/**
 * Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by GetId. You can optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.
 *
 * The OpenID token is valid for 10 minutes.
 *
 * This is a public API. You do not need any credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.getOpenIdToken(crossinline block: GetOpenIdTokenRequest.Builder.() -> Unit): GetOpenIdTokenResponse = getOpenIdToken(GetOpenIdTokenRequest.Builder().apply(block).build())

/**
 * Registers (or retrieves) a Cognito `IdentityId` and an OpenID Connect token for a user authenticated by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can only specify one developer provider as part of the `Logins` map, which is linked to the identity pool. The developer provider is the "domain" by which Cognito will refer to your users.
 *
 * You can use `GetOpenIdTokenForDeveloperIdentity` to create a new identity and to link new logins (that is, user credentials issued by a public provider or developer provider) to an existing identity. When you want to create a new identity, the `IdentityId` should be null. When you want to associate a new login with an existing authenticated/unauthenticated identity, you can do so by providing the existing `IdentityId`. This API will create the identity in the specified `IdentityPoolId`.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.getOpenIdTokenForDeveloperIdentity(crossinline block: GetOpenIdTokenForDeveloperIdentityRequest.Builder.() -> Unit): GetOpenIdTokenForDeveloperIdentityResponse = getOpenIdTokenForDeveloperIdentity(GetOpenIdTokenForDeveloperIdentityRequest.Builder().apply(block).build())

/**
 * Use `GetPrincipalTagAttributeMap` to list all mappings between `PrincipalTags` and user attributes.
 */
public suspend inline fun CognitoIdentityClient.getPrincipalTagAttributeMap(crossinline block: GetPrincipalTagAttributeMapRequest.Builder.() -> Unit): GetPrincipalTagAttributeMapResponse = getPrincipalTagAttributeMap(GetPrincipalTagAttributeMapRequest.Builder().apply(block).build())

/**
 * Lists the identities in an identity pool.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.listIdentities(crossinline block: ListIdentitiesRequest.Builder.() -> Unit): ListIdentitiesResponse = listIdentities(ListIdentitiesRequest.Builder().apply(block).build())

/**
 * Lists all of the Cognito identity pools registered for your account.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.listIdentityPools(crossinline block: ListIdentityPoolsRequest.Builder.() -> Unit): ListIdentityPoolsResponse = listIdentityPools(ListIdentityPoolsRequest.Builder().apply(block).build())

/**
 * Lists the tags that are assigned to an Amazon Cognito identity pool.
 *
 * A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
 *
 * You can use this action up to 10 times per second, per account.
 */
public suspend inline fun CognitoIdentityClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves the `IdentityID` associated with a `DeveloperUserIdentifier` or the list of `DeveloperUserIdentifier` values associated with an `IdentityId` for an existing identity. Either `IdentityID` or `DeveloperUserIdentifier` must not be null. If you supply only one of these values, the other value will be searched in the database and returned as a part of the response. If you supply both, `DeveloperUserIdentifier` will be matched against `IdentityID`. If the values are verified against the database, the response returns both values and is the same as the request. Otherwise a `ResourceConflictException` is thrown.
 *
 * `LookupDeveloperIdentity` is intended for low-throughput control plane operations: for example, to enable customer service to locate an identity ID by username. If you are using it for higher-volume operations such as user authentication, your requests are likely to be throttled. GetOpenIdTokenForDeveloperIdentity is a better option for higher-volume operations for user authentication.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.lookupDeveloperIdentity(crossinline block: LookupDeveloperIdentityRequest.Builder.() -> Unit): LookupDeveloperIdentityResponse = lookupDeveloperIdentity(LookupDeveloperIdentityRequest.Builder().apply(block).build())

/**
 * Merges two users having different `IdentityId`s, existing in the same identity pool, and identified by the same developer provider. You can use this action to request that discrete users be merged and identified as a single user in the Cognito environment. Cognito associates the given source user (`SourceUserIdentifier`) with the `IdentityId` of the `DestinationUserIdentifier`. Only developer-authenticated users can be merged. If the users to be merged are associated with the same public provider, but as two different users, an exception will be thrown.
 *
 * The number of linked logins is limited to 20. So, the number of linked logins for the source user, `SourceUserIdentifier`, and the destination user, `DestinationUserIdentifier`, together should not be larger than 20. Otherwise, an exception will be thrown.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.mergeDeveloperIdentities(crossinline block: MergeDeveloperIdentitiesRequest.Builder.() -> Unit): MergeDeveloperIdentitiesResponse = mergeDeveloperIdentities(MergeDeveloperIdentitiesRequest.Builder().apply(block).build())

/**
 * Sets the roles for an identity pool. These roles are used when making calls to GetCredentialsForIdentity action.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.setIdentityPoolRoles(crossinline block: SetIdentityPoolRolesRequest.Builder.() -> Unit): SetIdentityPoolRolesResponse = setIdentityPoolRoles(SetIdentityPoolRolesRequest.Builder().apply(block).build())

/**
 * You can use this operation to use default (username and clientID) attribute or custom attribute mappings.
 */
public suspend inline fun CognitoIdentityClient.setPrincipalTagAttributeMap(crossinline block: SetPrincipalTagAttributeMapRequest.Builder.() -> Unit): SetPrincipalTagAttributeMapResponse = setPrincipalTagAttributeMap(SetPrincipalTagAttributeMapRequest.Builder().apply(block).build())

/**
 * Assigns a set of tags to the specified Amazon Cognito identity pool. A tag is a label that you can use to categorize and manage identity pools in different ways, such as by purpose, owner, environment, or other criteria.
 *
 * Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of an identity pool, one for testing and another for production, you might assign an `Environment` tag key to both identity pools. The value of this key might be `Test` for one identity pool and `Production` for the other.
 *
 * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your identity pools. In an IAM policy, you can constrain permissions for identity pools based on specific tags or tag values.
 *
 * You can use this action up to 5 times per second, per account. An identity pool can have as many as 50 tags.
 */
public suspend inline fun CognitoIdentityClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Unlinks a `DeveloperUserIdentifier` from an existing identity. Unlinked developer users will be considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated identities as well as the developer user identifier, the Cognito identity becomes inaccessible.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.unlinkDeveloperIdentity(crossinline block: UnlinkDeveloperIdentityRequest.Builder.() -> Unit): UnlinkDeveloperIdentityResponse = unlinkDeveloperIdentity(UnlinkDeveloperIdentityRequest.Builder().apply(block).build())

/**
 * Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next time they are seen. Removing the last linked login will make this identity inaccessible.
 *
 * This is a public API. You do not need any credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.unlinkIdentity(crossinline block: UnlinkIdentityRequest.Builder.() -> Unit): UnlinkIdentityResponse = unlinkIdentity(UnlinkIdentityRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Amazon Cognito identity pool. You can use this action up to 5 times per second, per account
 */
public suspend inline fun CognitoIdentityClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an identity pool.
 *
 * You must use AWS Developer credentials to call this API.
 */
public suspend inline fun CognitoIdentityClient.updateIdentityPool(crossinline block: UpdateIdentityPoolRequest.Builder.() -> Unit): UpdateIdentityPoolResponse = updateIdentityPool(UpdateIdentityPoolRequest.Builder().apply(block).build())
