// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the `GetCredentialsForIdentity` action.
 */
public class GetCredentialsForIdentityRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers that do not support role customization.
     */
    public val customRoleArn: kotlin.String? = builder.customRoleArn
    /**
     * A unique identifier in the format REGION:GUID.
     */
    public val identityId: kotlin.String? = builder.identityId
    /**
     * A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will follow the syntax "provider_name": "provider_user_identifier".
     *
     * Logins should not be specified when trying to get credentials for an unauthenticated identity.
     *
     * The Logins parameter is required when using identities associated with external identity providers such as Facebook. For examples of `Logins` maps, see the code examples in the [External Identity Providers](https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html) section of the Amazon Cognito Developer Guide.
     */
    public val logins: Map<String, String>? = builder.logins

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.GetCredentialsForIdentityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCredentialsForIdentityRequest(")
        append("customRoleArn=$customRoleArn,")
        append("identityId=$identityId,")
        append("logins=$logins")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customRoleArn?.hashCode() ?: 0
        result = 31 * result + (identityId?.hashCode() ?: 0)
        result = 31 * result + (logins?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCredentialsForIdentityRequest

        if (customRoleArn != other.customRoleArn) return false
        if (identityId != other.identityId) return false
        if (logins != other.logins) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.GetCredentialsForIdentityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the role to be assumed when multiple roles were received in the token from the identity provider. For example, a SAML-based identity provider. This parameter is optional for identity providers that do not support role customization.
         */
        public var customRoleArn: kotlin.String? = null
        /**
         * A unique identifier in the format REGION:GUID.
         */
        public var identityId: kotlin.String? = null
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. The name-value pair will follow the syntax "provider_name": "provider_user_identifier".
         *
         * Logins should not be specified when trying to get credentials for an unauthenticated identity.
         *
         * The Logins parameter is required when using identities associated with external identity providers such as Facebook. For examples of `Logins` maps, see the code examples in the [External Identity Providers](https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html) section of the Amazon Cognito Developer Guide.
         */
        public var logins: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.GetCredentialsForIdentityRequest) : this() {
            this.customRoleArn = x.customRoleArn
            this.identityId = x.identityId
            this.logins = x.logins
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.GetCredentialsForIdentityRequest = GetCredentialsForIdentityRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
