// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * A provider representing an Amazon Cognito user pool and its client ID.
 */
public class CognitoIdentityProvider private constructor(builder: Builder) {
    /**
     * The client ID for the Amazon Cognito user pool.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The provider name for an Amazon Cognito user pool. For example, `cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789`.
     */
    public val providerName: kotlin.String? = builder.providerName
    /**
     * TRUE if server-side token validation is enabled for the identity provider’s token.
     *
     * Once you set `ServerSideTokenCheck` to TRUE for an identity pool, that identity pool will check with the integrated user pools to make sure that the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
     *
     * If the user is signed out or deleted, the identity pool will return a 400 Not Authorized error.
     */
    public val serverSideTokenCheck: kotlin.Boolean? = builder.serverSideTokenCheck

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoIdentityProvider(")
        append("clientId=$clientId,")
        append("providerName=$providerName,")
        append("serverSideTokenCheck=$serverSideTokenCheck")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (serverSideTokenCheck?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoIdentityProvider

        if (clientId != other.clientId) return false
        if (providerName != other.providerName) return false
        if (serverSideTokenCheck != other.serverSideTokenCheck) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityProvider = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The client ID for the Amazon Cognito user pool.
         */
        public var clientId: kotlin.String? = null
        /**
         * The provider name for an Amazon Cognito user pool. For example, `cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789`.
         */
        public var providerName: kotlin.String? = null
        /**
         * TRUE if server-side token validation is enabled for the identity provider’s token.
         *
         * Once you set `ServerSideTokenCheck` to TRUE for an identity pool, that identity pool will check with the integrated user pools to make sure that the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
         *
         * If the user is signed out or deleted, the identity pool will return a 400 Not Authorized error.
         */
        public var serverSideTokenCheck: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityProvider) : this() {
            this.clientId = x.clientId
            this.providerName = x.providerName
            this.serverSideTokenCheck = x.serverSideTokenCheck
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityProvider = CognitoIdentityProvider(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
