// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.serde

import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class SetPrincipalTagAttributeMapOperationDeserializer: HttpDeserialize<SetPrincipalTagAttributeMapResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SetPrincipalTagAttributeMapResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSetPrincipalTagAttributeMapError(context, call)
        }
        val builder = SetPrincipalTagAttributeMapResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSetPrincipalTagAttributeMapOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSetPrincipalTagAttributeMapError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CognitoIdentityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSetPrincipalTagAttributeMapOperationBody(builder: SetPrincipalTagAttributeMapResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYPOOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityPoolId"))
    val IDENTITYPROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityProviderName"))
    val PRINCIPALTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("PrincipalTags"))
    val USEDEFAULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseDefaults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYPOOLID_DESCRIPTOR)
        field(IDENTITYPROVIDERNAME_DESCRIPTOR)
        field(PRINCIPALTAGS_DESCRIPTOR)
        field(USEDEFAULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYPOOLID_DESCRIPTOR.index -> builder.identityPoolId = deserializeString()
                IDENTITYPROVIDERNAME_DESCRIPTOR.index -> builder.identityProviderName = deserializeString()
                PRINCIPALTAGS_DESCRIPTOR.index -> builder.principalTags =
                    deserializer.deserializeMap(PRINCIPALTAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USEDEFAULTS_DESCRIPTOR.index -> builder.useDefaults = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
