// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.serde

import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetOpenIdTokenForDeveloperIdentityOperationDeserializer: HttpDeserialize<GetOpenIdTokenForDeveloperIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetOpenIdTokenForDeveloperIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetOpenIdTokenForDeveloperIdentityError(context, call)
        }
        val builder = GetOpenIdTokenForDeveloperIdentityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetOpenIdTokenForDeveloperIdentityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetOpenIdTokenForDeveloperIdentityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "DeveloperUserAlreadyRegisteredException" -> DeveloperUserAlreadyRegisteredExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CognitoIdentityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetOpenIdTokenForDeveloperIdentityOperationBody(builder: GetOpenIdTokenForDeveloperIdentityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityId"))
    val TOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Token"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYID_DESCRIPTOR)
        field(TOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYID_DESCRIPTOR.index -> builder.identityId = deserializeString()
                TOKEN_DESCRIPTOR.index -> builder.token = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
