// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the `MergeDeveloperIdentities` action.
 */
public class MergeDeveloperIdentitiesRequest private constructor(builder: Builder) {
    /**
     * User identifier for the destination user. The value should be a `DeveloperUserIdentifier`.
     */
    public val destinationUserIdentifier: kotlin.String? = builder.destinationUserIdentifier
    /**
     * The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the `DeveloperProviderName`, you can use letters as well as period (.), underscore (_), and dash (-).
     */
    public val developerProviderName: kotlin.String? = builder.developerProviderName
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    public val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * User identifier for the source user. The value should be a `DeveloperUserIdentifier`.
     */
    public val sourceUserIdentifier: kotlin.String? = builder.sourceUserIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MergeDeveloperIdentitiesRequest(")
        append("destinationUserIdentifier=$destinationUserIdentifier,")
        append("developerProviderName=$developerProviderName,")
        append("identityPoolId=$identityPoolId,")
        append("sourceUserIdentifier=$sourceUserIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationUserIdentifier?.hashCode() ?: 0
        result = 31 * result + (developerProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (sourceUserIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MergeDeveloperIdentitiesRequest

        if (destinationUserIdentifier != other.destinationUserIdentifier) return false
        if (developerProviderName != other.developerProviderName) return false
        if (identityPoolId != other.identityPoolId) return false
        if (sourceUserIdentifier != other.sourceUserIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * User identifier for the destination user. The value should be a `DeveloperUserIdentifier`.
         */
        public var destinationUserIdentifier: kotlin.String? = null
        /**
         * The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the `DeveloperProviderName`, you can use letters as well as period (.), underscore (_), and dash (-).
         */
        public var developerProviderName: kotlin.String? = null
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        public var identityPoolId: kotlin.String? = null
        /**
         * User identifier for the source user. The value should be a `DeveloperUserIdentifier`.
         */
        public var sourceUserIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest) : this() {
            this.destinationUserIdentifier = x.destinationUserIdentifier
            this.developerProviderName = x.developerProviderName
            this.identityPoolId = x.identityPoolId
            this.sourceUserIdentifier = x.sourceUserIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest = MergeDeveloperIdentitiesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
