// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the GetId action.
 */
public class GetIdRequest private constructor(builder: Builder) {
    /**
     * A standard AWS account ID (9+ digits).
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    public val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * A set of optional name-value pairs that map provider names to provider tokens. The available provider names for `Logins` are as follows:
     * + Facebook: `graph.facebook.com`
     * + Amazon Cognito user pool: `cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>`, for example, `cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789`.
     * + Google: `accounts.google.com`
     * + Amazon: `www.amazon.com`
     * + Twitter: `api.twitter.com`
     * + Digits: `www.digits.com`
     */
    public val logins: Map<String, String>? = builder.logins

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetIdRequest(")
        append("accountId=$accountId,")
        append("identityPoolId=$identityPoolId,")
        append("logins=$logins")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (logins?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetIdRequest

        if (accountId != other.accountId) return false
        if (identityPoolId != other.identityPoolId) return false
        if (logins != other.logins) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A standard AWS account ID (9+ digits).
         */
        public var accountId: kotlin.String? = null
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        public var identityPoolId: kotlin.String? = null
        /**
         * A set of optional name-value pairs that map provider names to provider tokens. The available provider names for `Logins` are as follows:
         * + Facebook: `graph.facebook.com`
         * + Amazon Cognito user pool: `cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>`, for example, `cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789`.
         * + Google: `accounts.google.com`
         * + Amazon: `www.amazon.com`
         * + Twitter: `api.twitter.com`
         * + Digits: `www.digits.com`
         */
        public var logins: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest) : this() {
            this.accountId = x.accountId
            this.identityPoolId = x.identityPoolId
            this.logins = x.logins
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.GetIdRequest = GetIdRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
