// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.transform

import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetPrincipalTagAttributeMapOperationDeserializer: HttpDeserialize<GetPrincipalTagAttributeMapResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPrincipalTagAttributeMapResponse {
        if (!response.status.isSuccess()) {
            throwGetPrincipalTagAttributeMapError(context, response)
        }
        val builder = GetPrincipalTagAttributeMapResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPrincipalTagAttributeMapOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPrincipalTagAttributeMapError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPrincipalTagAttributeMapOperationBody(builder: GetPrincipalTagAttributeMapResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYPOOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityPoolId"))
    val IDENTITYPROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityProviderName"))
    val PRINCIPALTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("PrincipalTags"))
    val USEDEFAULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseDefaults"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYPOOLID_DESCRIPTOR)
        field(IDENTITYPROVIDERNAME_DESCRIPTOR)
        field(PRINCIPALTAGS_DESCRIPTOR)
        field(USEDEFAULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYPOOLID_DESCRIPTOR.index -> builder.identityPoolId = deserializeString()
                IDENTITYPROVIDERNAME_DESCRIPTOR.index -> builder.identityProviderName = deserializeString()
                PRINCIPALTAGS_DESCRIPTOR.index -> builder.principalTags =
                    deserializer.deserializeMap(PRINCIPALTAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USEDEFAULTS_DESCRIPTOR.index -> builder.useDefaults = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
