// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * An object representing an Amazon Cognito identity pool.
 */
public class DescribeIdentityPoolResponse private constructor(builder: Builder) {
    /**
     * Enables or disables the Basic (Classic) authentication flow. For more information, see [Identity Pools (Federated Identities) Authentication Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html) in the *Amazon Cognito Developer Guide*.
     */
    public val allowClassicFlow: kotlin.Boolean? = builder.allowClassicFlow
    /**
     * TRUE if the identity pool supports unauthenticated logins.
     */
    public val allowUnauthenticatedIdentities: kotlin.Boolean = builder.allowUnauthenticatedIdentities
    /**
     * A list representing an Amazon Cognito user pool and its client ID.
     */
    public val cognitoIdentityProviders: List<CognitoIdentityProvider>? = builder.cognitoIdentityProviders
    /**
     * The "domain" by which Cognito will refer to your users.
     */
    public val developerProviderName: kotlin.String? = builder.developerProviderName
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    public val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * A string that you provide.
     */
    public val identityPoolName: kotlin.String? = builder.identityPoolName
    /**
     * The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     */
    public val identityPoolTags: Map<String, String>? = builder.identityPoolTags
    /**
     * The ARNs of the OpenID Connect providers.
     */
    public val openIdConnectProviderArNs: List<String>? = builder.openIdConnectProviderArNs
    /**
     * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
     */
    public val samlProviderArNs: List<String>? = builder.samlProviderArNs
    /**
     * Optional key:value pairs mapping provider names to provider app IDs.
     */
    public val supportedLoginProviders: Map<String, String>? = builder.supportedLoginProviders

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityPoolResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeIdentityPoolResponse(")
        append("allowClassicFlow=$allowClassicFlow,")
        append("allowUnauthenticatedIdentities=$allowUnauthenticatedIdentities,")
        append("cognitoIdentityProviders=$cognitoIdentityProviders,")
        append("developerProviderName=$developerProviderName,")
        append("identityPoolId=$identityPoolId,")
        append("identityPoolName=$identityPoolName,")
        append("identityPoolTags=$identityPoolTags,")
        append("openIdConnectProviderArNs=$openIdConnectProviderArNs,")
        append("samlProviderArNs=$samlProviderArNs,")
        append("supportedLoginProviders=$supportedLoginProviders")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowClassicFlow?.hashCode() ?: 0
        result = 31 * result + (allowUnauthenticatedIdentities.hashCode())
        result = 31 * result + (cognitoIdentityProviders?.hashCode() ?: 0)
        result = 31 * result + (developerProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (identityPoolName?.hashCode() ?: 0)
        result = 31 * result + (identityPoolTags?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (samlProviderArNs?.hashCode() ?: 0)
        result = 31 * result + (supportedLoginProviders?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeIdentityPoolResponse

        if (allowClassicFlow != other.allowClassicFlow) return false
        if (allowUnauthenticatedIdentities != other.allowUnauthenticatedIdentities) return false
        if (cognitoIdentityProviders != other.cognitoIdentityProviders) return false
        if (developerProviderName != other.developerProviderName) return false
        if (identityPoolId != other.identityPoolId) return false
        if (identityPoolName != other.identityPoolName) return false
        if (identityPoolTags != other.identityPoolTags) return false
        if (openIdConnectProviderArNs != other.openIdConnectProviderArNs) return false
        if (samlProviderArNs != other.samlProviderArNs) return false
        if (supportedLoginProviders != other.supportedLoginProviders) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityPoolResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Enables or disables the Basic (Classic) authentication flow. For more information, see [Identity Pools (Federated Identities) Authentication Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html) in the *Amazon Cognito Developer Guide*.
         */
        public var allowClassicFlow: kotlin.Boolean? = null
        /**
         * TRUE if the identity pool supports unauthenticated logins.
         */
        public var allowUnauthenticatedIdentities: kotlin.Boolean = false
        /**
         * A list representing an Amazon Cognito user pool and its client ID.
         */
        public var cognitoIdentityProviders: List<CognitoIdentityProvider>? = null
        /**
         * The "domain" by which Cognito will refer to your users.
         */
        public var developerProviderName: kotlin.String? = null
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        public var identityPoolId: kotlin.String? = null
        /**
         * A string that you provide.
         */
        public var identityPoolName: kotlin.String? = null
        /**
         * The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
         */
        public var identityPoolTags: Map<String, String>? = null
        /**
         * The ARNs of the OpenID Connect providers.
         */
        public var openIdConnectProviderArNs: List<String>? = null
        /**
         * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool.
         */
        public var samlProviderArNs: List<String>? = null
        /**
         * Optional key:value pairs mapping provider names to provider app IDs.
         */
        public var supportedLoginProviders: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityPoolResponse) : this() {
            this.allowClassicFlow = x.allowClassicFlow
            this.allowUnauthenticatedIdentities = x.allowUnauthenticatedIdentities
            this.cognitoIdentityProviders = x.cognitoIdentityProviders
            this.developerProviderName = x.developerProviderName
            this.identityPoolId = x.identityPoolId
            this.identityPoolName = x.identityPoolName
            this.identityPoolTags = x.identityPoolTags
            this.openIdConnectProviderArNs = x.openIdConnectProviderArNs
            this.samlProviderArNs = x.samlProviderArNs
            this.supportedLoginProviders = x.supportedLoginProviders
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.DescribeIdentityPoolResponse = DescribeIdentityPoolResponse(this)
    }
}
