// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentity.model.CognitoIdentityException
import aws.sdk.kotlin.services.cognitoidentity.model.IdentityPoolShortDescription
import aws.sdk.kotlin.services.cognitoidentity.model.ListIdentityPoolsResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListIdentityPoolsOperationDeserializer: HttpDeserialize<ListIdentityPoolsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListIdentityPoolsResponse {
        if (!response.status.isSuccess()) {
            throwListIdentityPoolsError(context, response)
        }
        val builder = ListIdentityPoolsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListIdentityPoolsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListIdentityPoolsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListIdentityPoolsOperationBody(builder: ListIdentityPoolsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYPOOLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("IdentityPools"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYPOOLS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYPOOLS_DESCRIPTOR.index -> builder.identityPools =
                    deserializer.deserializeList(IDENTITYPOOLS_DESCRIPTOR) {
                        val col0 = mutableListOf<IdentityPoolShortDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIdentityPoolShortDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
