// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the `SetIdentityPoolRoles` action.
 */
class SetIdentityPoolRolesRequest private constructor(builder: Builder) {
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * How users for a specific identity provider are to mapped to roles. This is a string to RoleMapping object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
     *
     * Up to 25 rules can be specified per identity provider.
     */
    val roleMappings: Map<String, RoleMapping>? = builder.roleMappings
    /**
     * The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
     */
    val roles: Map<String, String>? = builder.roles

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityPoolRolesRequest(")
        append("identityPoolId=$identityPoolId,")
        append("roleMappings=$roleMappings,")
        append("roles=$roles)")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityPoolId?.hashCode() ?: 0
        result = 31 * result + (roleMappings?.hashCode() ?: 0)
        result = 31 * result + (roles?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetIdentityPoolRolesRequest

        if (identityPoolId != other.identityPoolId) return false
        if (roleMappings != other.roleMappings) return false
        if (roles != other.roles) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: kotlin.String? = null
        /**
         * How users for a specific identity provider are to mapped to roles. This is a string to RoleMapping object map. The string identifies the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         *
         * Up to 25 rules can be specified per identity provider.
         */
        var roleMappings: Map<String, RoleMapping>? = null
        /**
         * The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
         */
        var roles: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest) : this() {
            this.identityPoolId = x.identityPoolId
            this.roleMappings = x.roleMappings
            this.roles = x.roles
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.SetIdentityPoolRolesRequest = SetIdentityPoolRolesRequest(this)
    }
}
