// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * A rule that maps a claim name, a claim value, and a match type to a role ARN.
 */
class MappingRule private constructor(builder: Builder) {
    /**
     * The claim name that must be present in the token, for example, "isAdmin" or "paid".
     */
    val claim: kotlin.String? = builder.claim
    /**
     * The match condition that specifies how closely the claim value in the IdP token must match `Value`.
     */
    val matchType: aws.sdk.kotlin.services.cognitoidentity.model.MappingRuleMatchType? = builder.matchType
    /**
     * The role ARN.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * A brief string that the claim must match, for example, "paid" or "yes".
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.MappingRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MappingRule(")
        append("claim=$claim,")
        append("matchType=$matchType,")
        append("roleArn=$roleArn,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = claim?.hashCode() ?: 0
        result = 31 * result + (matchType?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MappingRule

        if (claim != other.claim) return false
        if (matchType != other.matchType) return false
        if (roleArn != other.roleArn) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.MappingRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The claim name that must be present in the token, for example, "isAdmin" or "paid".
         */
        var claim: kotlin.String? = null
        /**
         * The match condition that specifies how closely the claim value in the IdP token must match `Value`.
         */
        var matchType: aws.sdk.kotlin.services.cognitoidentity.model.MappingRuleMatchType? = null
        /**
         * The role ARN.
         */
        var roleArn: kotlin.String? = null
        /**
         * A brief string that the claim must match, for example, "paid" or "yes".
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.MappingRule) : this() {
            this.claim = x.claim
            this.matchType = x.matchType
            this.roleArn = x.roleArn
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.MappingRule = MappingRule(this)
    }
}
