// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model



/**
 * Input to the `LookupDeveloperIdentityInput` action.
 */
class LookupDeveloperIdentityRequest private constructor(builder: Builder) {
    /**
     * A unique ID used by your backend authentication process to identify a user. Typically, a developer identity provider would issue many developer user identifiers, in keeping with the number of users.
     */
    val developerUserIdentifier: kotlin.String? = builder.developerUserIdentifier
    /**
     * A unique identifier in the format REGION:GUID.
     */
    val identityId: kotlin.String? = builder.identityId
    /**
     * An identity pool ID in the format REGION:GUID.
     */
    val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * The maximum number of identities to return.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * A pagination token. The first call you make will have `NextToken` set to null. After that the service will return `NextToken` values as needed. For example, let's say you make a request with `MaxResults` set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.LookupDeveloperIdentityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LookupDeveloperIdentityRequest(")
        append("developerUserIdentifier=$developerUserIdentifier,")
        append("identityId=$identityId,")
        append("identityPoolId=$identityPoolId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = developerUserIdentifier?.hashCode() ?: 0
        result = 31 * result + (identityId?.hashCode() ?: 0)
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LookupDeveloperIdentityRequest

        if (developerUserIdentifier != other.developerUserIdentifier) return false
        if (identityId != other.identityId) return false
        if (identityPoolId != other.identityPoolId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.LookupDeveloperIdentityRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique ID used by your backend authentication process to identify a user. Typically, a developer identity provider would issue many developer user identifiers, in keeping with the number of users.
         */
        var developerUserIdentifier: kotlin.String? = null
        /**
         * A unique identifier in the format REGION:GUID.
         */
        var identityId: kotlin.String? = null
        /**
         * An identity pool ID in the format REGION:GUID.
         */
        var identityPoolId: kotlin.String? = null
        /**
         * The maximum number of identities to return.
         */
        var maxResults: kotlin.Int = 0
        /**
         * A pagination token. The first call you make will have `NextToken` set to null. After that the service will return `NextToken` values as needed. For example, let's say you make a request with `MaxResults` set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.LookupDeveloperIdentityRequest) : this() {
            this.developerUserIdentifier = x.developerUserIdentifier
            this.identityId = x.identityId
            this.identityPoolId = x.identityPoolId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.LookupDeveloperIdentityRequest = LookupDeveloperIdentityRequest(this)
    }
}
